#include "FontRenderer.h"

FontRenderer* FontRenderer::pinstance = NULL;

FontRenderer::FontRenderer()
{
	utility = GraphicsUtility::Instance();
	Init();
}

FontRenderer::~FontRenderer()
{
	SDL_FreeSurface( fontMap );
	SDL_FreeSurface( digittMap );
//	delete(utility);
}


FontRenderer* FontRenderer::Instance (){

	if (pinstance == NULL) // is it the first call?

	{

		pinstance = new FontRenderer(); // create sole instance

	}

	return pinstance; // address of sole instance

}

void FontRenderer::Init()
{
	//load in the font picture
	fontMap = utility->load_image("data/graphics/lemmings_font.png");
	printf("loaded font image\n");
	//create all the clips
	int x = 2;
	int y = 0;
	for(int n = 0; n < NUM_CHARS; n++)
	{
		characters[n].w = FontWidth;
		characters[n].h = FontHeight;

		characters[n].x = x;
		characters[n].y = y;

		x += FontWidth;

		if(n == 43 || n == 87)
		{
			x = 2;
			y += FontHeight+4;
		}
	}
	
	digittMap = utility->load_image("data/graphics/numbers_fullSize.bmp");
	printf("loaded number image\n");
	//create all the clips
	x = 0; y = 0;
	for(int n = 0; n < NUM_DIGITS; n++)
	{
		digits[n].w = DIGIT_WIDTH;
		digits[n].h = 32;

		digits[n].x = x;
		digits[n].y = y;

		x += DIGIT_WIDTH;
	}
}

void FontRenderer::RenderNumber(SDL_Surface* surface, std::string number, int xPos, int yPos)
{
	SDL_Rect offset; 
	offset.x = xPos; 
	offset.y = yPos; 
	for(unsigned int n = 0; n < number.size(); n++)
	{
		char c = number[n];
		SDL_BlitSurface( digittMap, &digits[((int)c)-48], surface, &offset );
		offset.x += DIGIT_WIDTH;
	}
}

void FontRenderer::RenderString(SDL_Surface* surface, std::string text, int xPos, int yPos,enum FONT_COLOR font_color, enum POSITION position)
{
	//printf("text: %s\n",text.c_str());

	//for now render some random chars at the right pos
	if(position == CENTER)
	{
		int newxpos = (640-(text.size()*(FontWidth-2)))/2;
		xPos = newxpos;
	}
	
	//for each char in the string
	for(unsigned int n = 0; n < text.size(); n++)
	{
		char c = text[n];
		if((int)' ' != (int)c)
		{
			DrawChar(xPos, yPos, fontMap, surface, &characters[((int)c)-33], font_color);
		}
		xPos += FontWidth-2;
	}
}

void FontRenderer::DrawChar(int x, int y, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip, FONT_COLOR font_color)
{ 
	SDL_Rect rect;
	rect.w = 1;
	rect.h = 1;
	rect.x = x;
	rect.y = y;

	//Blit 
	if(font_color == GREEN)
	{
		SDL_BlitSurface( source, clip, destination, &rect);
	}
	else
	{
		Uint8 r,g,b;

		Uint32 p,color;
		for(int xx = 0; xx < clip->w; xx++)
		{
			for(int yy = 0; yy < clip->h; yy++)
			{
				//copy each pixel..to the actualScreen
				p = utility->getpixel(source, xx+clip->x, yy+clip->y);
				SDL_GetRGB(p, source->format, &r, &g, &b);

				switch(font_color)
				{
					case (RED):
						color = SDL_MapRGB(source->format, g,r,b);
					break;
					case (GREEN):
						color = SDL_MapRGB(source->format, r,g,b);
					break;
					case (BLUE):
						color = SDL_MapRGB(source->format, b,r,g);
					break;
					case (LIGHT_BLUE):
						color = SDL_MapRGB(source->format, r,g,g);
					break;
					case (PURPLE):
						color = SDL_MapRGB(source->format, g,r,g);
					break;
					case (BROWN):
						color = SDL_MapRGB(source->format, g,g/2,0);
					break;
				}

				if(p) SDL_FillRect( destination, &rect, color );

				rect.y++;
			}
			rect.y = y;
			rect.x++;
		}
	}
} 
