#include "Game.h"
#include <sstream>
#include <math.h>

Game::Game(int ScreenWidth, int ScreenHeight, int new_framesPerSecond, int newZoom, bool Sound_enabled, int Buffer) {
	framesPerSecond = new_framesPerSecond;
	zoom = newZoom;
	sound_enabled = Sound_enabled;
	screen_size = new SDL_Rect();
	screen_size->x = screen_size->y = 0;
	screen_size->w = ScreenWidth*zoom;
	screen_size->h = 160*zoom;

	screenWidth = ScreenWidth;
	screenHeight = ScreenHeight;

	max_frame_store = Buffer;
	printf("set buffer to %d", max_frame_store);

	arLemInData = new LemData[max_frame_store];
	arLemOutData = new LemData[max_frame_store];

	LemData* p = &arLemInData[0];
	LemData* p1 = &arLemOutData[0];
	for(int n = 0; n < max_frame_store; n++){
		p->index = p1->index = INVALID_INDEX;
		p->new_state = p1->new_state = INVALID_NEW_STATE;
		p++;
		p1++;
	}

	p = &arLemInData[0];
	p1 = &arLemOutData[0];
	for(int n = 0; n < max_frame_store; n++){
		printf("arLemInData n %d: index: %d, new_state: %d\n", n, p->index, p->new_state);
		printf("arLemOutData n %d: index: %d, new_state: %d\n", n, p1->index, p1->new_state);
		p++;
		p1++;
	}

	arRebuildSurfaces = new ImageBlock[max_frame_store*max_num_lemmings];

	//now initilize the images ( or shall we not?)
	for (int n = 0; n < max_frame_store*max_num_lemmings; n++) {
		arRebuildSurfaces[n].x = arRebuildSurfaces[n].y = 0;
		arRebuildSurfaces[n].image = NULL;
	}

	printf("sizeof(Lemming) %d", sizeof(Lemming));

	fontRenderer = FontRenderer::Instance();
	utility = GraphicsUtility::Instance();
	samples = new SamplePlayer(sound_enabled);
	statusPanel = new StatusPanel(0, (LEVEL_Y_SIZE - Y_OFFSET) * 2, ScreenWidth, ScreenHeight, samples, zoom);
	currentLevel = new Level(ScreenWidth, ScreenHeight);
	sprites = new SpriteStore();

	gameType = StatusPanel::SinglePlayer;
	csd = sd = NULL;
	//Create all the Lemmings:
	for (int n = 0; n < max_num_lemmings; n++) {
		ulemmings.lemmings[n] = new Lemming(6*zoom, 9*zoom, 0, 0, zoom);
		lemmings_copy[n] = new Lemming(6*zoom, 9*zoom, 0, 0, zoom);
	}

	debugMode = false;
	effects_only = false;
	music_now_on=false;
	connected = false;
	ResetMultiplayer();
}

Game::~Game() {
	if (sd != NULL)
		SDLNet_TCP_Close(sd);
	if (csd != NULL)
		SDLNet_TCP_Close(csd);

	SDLNet_Quit();
	delete (fontRenderer);
	delete (statusPanel);
	delete (utility);
	delete (currentLevel);
	delete (samples);
	delete(screen_size);
	delete(arLemInData);
	delete(arLemOutData);

	//delete all the Lemmings:
	for (int n = 0; n < max_num_lemmings; n++)
	{
		delete (ulemmings.lemmings[n]);
		delete (lemmings_copy[n]);
	}
}

void Game::Pause() {
	pause = !pause;
}

void Game::Init(StatusPanel::GameType Sender) {
	gameData.blueOut = gameData.greenOut = gameData.releasePoint =
	gameData.numberReleased = gameData.totalOut = gameData.numHome =
	gameData.thisTotalOut = 0;

	suppress_tool_decrease = false;
	pause = false;
	nukeAll = false;
	blueNuked = greenNuked = gameData.totalledUp = false;

	lemOutData.new_state = lemInData.new_state = 127;
	lemOutData.index = lemInData.index = INVALID_INDEX;
	gameData.ticksSinceNukeClick = gameData.ticksSinceGameStart = 0;
	music_now_on = false;
	gameType = Sender;
	selectedSprite = NULL;

	//kill all the Lemmings wuhuhaahaahaa!
	for (int n = 0; n < max_num_lemmings; n++)
		ulemmings.lemmings[n]->SetDead();

	gameData.minReleaseRate = currentLevel->GetReleaseRate();
	timeRemaining = currentLevel->GetTimeInMinutes() * 60;
	//the following 2 lines ensure we get a lemming straight away
	gameData.releaseCounter = (60 - ((int) currentLevel->GetReleaseRate() * 55 / 100));
	fpsCount = framesPerSecond;

	statusPanel->SetGameStats(0, 0, 0, 0, 0, 0);
	printf("currentLevel->GetCamStartX(): %d\n", currentLevel->GetCamStartX());
	printf("screenWidth: %d\n", screenWidth);
	printf("zoom: %d\n", zoom);

	statusPanel->viewport.x = (currentLevel->GetCamStartX() - screenWidth / 2 + 16)*zoom;

	printf("statusPanel->viewport.x: %d\n", statusPanel->viewport.x);

	if (gameType != StatusPanel::SinglePlayer)
		statusPanel->viewport.x -= screenWidth / 4;

	statusPanel->SetGameMode(gameType);

	dataframe=0;
	pLemOutData=&arLemOutData[0];
	rebuildSurfaceCount=0;
}

bool Game::CloseConnection() {
	printf("(Game) Closing connection\n");
	if(sd != NULL){
		SDLNet_TCP_Close(sd);
		sd = NULL;
	}
	return true;
}

bool Game::ConnectToGame(StatusPanel::GameType Sender, std::string IPAddress) {
	IPaddress ip;
	connected = false;
	if (!connected) {
		if (gameType == StatusPanel::Server) {
			printf("Server trying to connect\n");
			if (SDLNet_Init() == 0) {
				printf("SDL_NEt has inited\n");
				/* Resolving the host using NULL make network interface to listen */
				if (SDLNet_ResolveHost(&ip, NULL, 2001) == 0) {
					printf("Server Resolved host...");
					/* Open a connection with the IP provided (listen on the host's port) */
					if (!(sd = SDLNet_TCP_Open(&ip))) {
						fprintf(stderr, "SDLNet_TCP_Open: %s\n o", SDLNet_GetError());
						exit(EXIT_FAILURE);
					} else {
						printf("Server now has port open...\n");
						connected = true;
					}
				} else {
					printf("SDLNet_ResolveHost: \n");
				}
			} else {
				printf("SDLNET failed to init\n");
			}
		} else if (gameType == StatusPanel::Client) {
			printf("Client trying to connect\n");
			if (SDLNet_Init() == 0) {
				/* Resolve the host we are connecting to */
				if (SDLNet_ResolveHost(&ip, IPAddress.c_str(), 2001) == 0) {
					fprintf(stderr, "Client Resolved host...");
					/* Open a connection with the IP provided (listen on the host's port) */
					if (!(sd = SDLNet_TCP_Open(&ip))) {
						fprintf(stderr, "SDLNet_TCP_Open: %s\n", SDLNet_GetError());
						connected = false;
					} else {
						fprintf(stderr, "Client connected to server...");
						connected = true;
					}
				}
			} else {
				printf("SDLNET failed to init\n");
			}
			fprintf(stderr, "Client ready to recieve\n");
		}
	}
	return connected;
}

SDL_Surface* Game::GetLevelPreview() {
	return currentLevel->GetLevelPreview();
}

bool Game::WaitForClientToConnect() {
	//now wait until we have a connection
	return (csd = SDLNet_TCP_Accept(sd));
}

bool Game::SetClientLevel(int newLevel){
	bool success = false;
	byte getRequest = 0;
	if (SDLNet_TCP_Recv(csd, &getRequest, 1) == 1) {
		byte newLevelData = (byte)newLevel;
		if (SDLNet_TCP_Send(csd, (void *) &newLevelData, 1) == 1) {
			success = true;
		} else {
			fprintf(stderr, "Server failed to send!\n");
		}
	} else {
		fprintf(stderr, "Server received less than it should!\n");
	}

	return success;
}

int Game::GetLevelFromServer(){
	byte levelRequest;
	byte newLevel;
	bool success = false;
	levelRequest = 1;

	if (SDLNet_TCP_Send(sd, (void *) &levelRequest, 1) == 1) {
		newLevel = 0;
		if (SDLNet_TCP_Recv(sd, &newLevel, 1) == 1) {
			success = true;
		} else {
			fprintf(stderr, "client received not enough\n");
		}
	} else {
		fprintf(stderr, "Client failed to send!\n");
	}

	if(success)
		return (int)newLevel;
	else
		return -1;
}


bool Game::RequestForData() {
	bool success = false;
	//right, we only want to do this every n frames
	if(dataframe == max_frame_store-1){
		dataframe = 0;

		if (gameType == StatusPanel::Server && csd != NULL) {
			if (SDLNet_TCP_Recv(csd, arLemInData, data_transfer_size*max_frame_store) == data_transfer_size*max_frame_store) {
				if (SDLNet_TCP_Send(csd, (void *) arLemOutData, data_transfer_size*max_frame_store) == data_transfer_size*max_frame_store) {
					success = true;
				} else {
					fprintf(stderr, "Server failed to send!\n");
				}
			} else {
				fprintf(stderr, "Server received less than it should!\n");
			}
		} else if ((gameType == StatusPanel::Client) && sd != NULL) {
			if (SDLNet_TCP_Send(sd, (void *) arLemOutData, data_transfer_size*max_frame_store) == data_transfer_size*max_frame_store) {
				if (SDLNet_TCP_Recv(sd, arLemInData, data_transfer_size*max_frame_store) == data_transfer_size*max_frame_store) {
					success = true;
				} else {
					fprintf(stderr, "client received not enough\n");
				}
			} else {
				fprintf(stderr, "Client failed to send!\n");
			}
		} else if (gameType == StatusPanel::SinglePlayer)
			success = true;

		if(success && gameType != StatusPanel::SinglePlayer){
			//right, let's do something with the data then
			//first, do we need to do anything?
			if(IsReanimationRequired()){
				//yes, it is
				//first, turn the clock back four frames

				//1. Rebuild Background
				//important we do this in the right order...
				//I.E. backwards
				for(int nn = rebuildSurfaceCount - 1; nn >= 0; nn--)
				{
					int x = (arRebuildSurfaces[nn].x);
					int y = (arRebuildSurfaces[nn].y);
					SDL_Surface* surf = (arRebuildSurfaces[nn].image);
					utility->apply_surface(x,y, surf, currentLevel->GetBackground(), NULL);
				}

				//2. Reset Lemmings states back to the last time we were here:
				for(int n = 0; n < max_num_lemmings;n++)
					ulemmings.lemmings[n]->MakeEqualTo(lemmings_copy[n]);

				gameData.ticksSinceGameStart = gameData_copy.ticksSinceGameStart;
				gameData.ticksSinceNukeClick = gameData_copy.ticksSinceNukeClick;
				gameData.totalledUp = gameData_copy.totalledUp;
				gameData.blueOut = gameData_copy.blueOut ;
				gameData.greenOut = gameData_copy.greenOut;
				gameData.releasePoint = gameData_copy.releasePoint;
				gameData.minReleaseRate = gameData_copy.minReleaseRate;
				gameData.nukeCount = gameData_copy.nukeCount;
				gameData.releaseCounter = gameData_copy.releaseCounter;
				gameData.numberReleased = gameData_copy.numberReleased;
				gameData.totalOut = gameData_copy.totalOut;
				gameData.thisTotalOut = gameData_copy.thisTotalOut;
				gameData.numHome = gameData_copy.numHome;

				//3. run n frames using lemInData and lemOutData, in the right order!
				samples->DisableSamples();
				suppress_tool_decrease = true;
				LemData* p = &arLemInData[0];
				LemData* p1 = &arLemOutData[0];
				for(int n = 0; n < max_frame_store; n++){
					AnimateFrame(p, p1);
					//whilst, we're here reset the data too
					p->index = p1->index = INVALID_INDEX;
					p->new_state = p1->new_state = INVALID_NEW_STATE;
					p1++;
					p++;
				}
				suppress_tool_decrease = false;
				samples->EnableSamples();
			}

			//reset buffer setting
			rebuildSurfaceCount = 0;
			pLemOutData = &arLemOutData[0];



		}
	}
	else{
		dataframe++;
		pLemOutData++;
		success = true;
	}

	return success;
}

void Game::StoreGameState(){
	gameData_copy.ticksSinceGameStart = gameData.ticksSinceGameStart;
	gameData_copy.ticksSinceNukeClick = gameData.ticksSinceNukeClick;
	gameData_copy.totalledUp = gameData.totalledUp;
	gameData_copy.blueOut = gameData.blueOut ;
	gameData_copy.greenOut = gameData.greenOut;
	gameData_copy.releasePoint = gameData.releasePoint;
	gameData_copy.minReleaseRate = gameData.minReleaseRate;
	gameData_copy.nukeCount = gameData.nukeCount;
	gameData_copy.releaseCounter = gameData.releaseCounter;
	gameData_copy.numberReleased = gameData.numberReleased;
	gameData_copy.totalOut = gameData.totalOut;
	gameData_copy.thisTotalOut = gameData.thisTotalOut;
	gameData_copy.numHome = gameData.numHome;
	for(int n = 0;n < max_num_lemmings;n++)
		lemmings_copy[n]->MakeEqualTo(ulemmings.lemmings[n]);
}

/*
 //THIS ONE WORKS!!!!
bool Game::RequestForData() {
	bool success = false;
	if (gameType == StatusPanel::Server) {
		if (SDLNet_TCP_Recv(csd, &lemInData, data_transfer_size) == data_transfer_size) {
			if (SDLNet_TCP_Send(csd, (void *) &lemOutData, data_transfer_size) == data_transfer_size) {
				success = true;
			} else {
				fprintf(stderr, "Server failed to send!\n");
			}
		} else {
			fprintf(stderr, "Server received less than it should!\n");
		}
	} else if (gameType == StatusPanel::Client) {
		if (SDLNet_TCP_Send(sd, (void *) &lemOutData, data_transfer_size) == data_transfer_size) {
			if (SDLNet_TCP_Recv(sd, &lemInData, data_transfer_size) == data_transfer_size) {
				success = true;
			} else {
				fprintf(stderr, "client received not enough\n");
			}
		} else {
			fprintf(stderr, "Client failed to send!\n");
		}
	} else if (gameType == StatusPanel::SinglePlayer)
		success = true;

	return success;
}*/


/* 'compressing' 2 bytes into 1 byte
bool Game::RequestForData() {
	bool success = false;
	byte dataIn=0;
	byte dataOut=0;

	if (gameType == StatusPanel::Server) {
		//
		//  SERVER RECIEVING DATA
		//
		if (SDLNet_TCP_Recv(csd, &dataIn, 1) == 1) {

			if(lemOutData.index != INVALID_INDEX) {
				dataOut = (lemOutData.new_state << 4) | (byte)lemOutData.index;
			}
			else {
				dataOut = (lemOutData.new_state << 4) | (byte)81;//81 is invalid for us
			}
			//
			// SERVER SENDING DATA
			//
			if (SDLNet_TCP_Send(csd, (void *) &dataOut, 1) == 1) {
				success = true;
				lemInData.index = (dataIn & 0xF)+80;
				lemInData.new_state = (dataIn & 0xF0) >> 4;

				if(lemInData.index == 81)
					lemInData.index = INVALID_INDEX;


			} else {
				fprintf(stderr, "Server failed to send!\n");
			}
		} else {
			fprintf(stderr, "Server received less than it should!\n");
		}

	} else if (gameType == StatusPanel::Client) {
		if(lemOutData.index != INVALID_INDEX){
			dataOut = (lemOutData.new_state << 4) | (byte)(lemOutData.index-80);
		}
		else
		{
			dataOut = (lemOutData.new_state << 4) | (byte)(81);
		}

		if (SDLNet_TCP_Send(sd, (void *) &dataOut, 1) == 1) {
			if (SDLNet_TCP_Recv(sd, &dataIn, 1) == 1) {
				success = true;
				lemInData.index = (dataIn & 0xF);
				lemInData.new_state = (dataIn & 0xF0) >> 4;

				if(lemInData.index == 81)
					lemInData.index = INVALID_INDEX;

			} else {
				fprintf(stderr, "client received not enough\n");
			}
		} else {
			fprintf(stderr, "Client failed to send!\n");
		}
	} else if (gameType == StatusPanel::SinglePlayer)
		success = true;

	return success;
}*/

void Game::LoadLevel(LevelLoader* levelLoader) {
	printf("(Game) In game LoadLevel\n");
	printf("(Game) loading level: %s\n", levelLoader->GetLevel()->c_str());
	if(currentLevel != NULL){
		printf("(Game) currentLevel is Not Null at least\n");
		currentLevel->LoadLevel(levelLoader->GetLevel());
		printf("(Game) Creating overview image next:\n");
		statusPanel->CreateOverviewImage(currentLevel->GetBackground());
		levelTune = Mix_LoadMUS(levelLoader->GetSong().c_str());
	}
}

void Game::Load2PlayerLevel(LevelLoader* levelLoader) {
	currentLevel->LoadLevel(levelLoader->GetTwoPlayerLevel(0));
	statusPanel->CreateOverviewImage(currentLevel->GetBackground());
	levelTune = Mix_LoadMUS(levelLoader->GetSong().c_str());
}

int Game::getDistanceToLemming(Lemming* l, int xp, int yp){
	int t,v;
	if(xp>l->GetX()){
		t = xp - l->GetX();
		if(yp>l->GetY()){
			v = yp - l->GetY();
		}
		else{
			v = l->GetY() - yp;
		}
	}
	else{
		t = l->GetX()-xp;
		if(yp > l->GetY()){
			v = yp - l->GetY();
		}
		else{
			v = l->GetY() - yp;
		}
	}
	return sqrt((t*t) + (v*v));
}

void Game::SetMouseClick(int x, int y, long leftButtonDown) {
	mouseX = x;
	mouseY = y;
	int iconSelected = -1;
	selectedSprite = NULL;
	int xx = mouseX;
	int yy = mouseY;
	int selectedCount = 0;
	int selectedIndex = INVALID_INDEX;

	//correct for (this is shit) multiplayer positioning
	int potdist=999;

	//nothing to do this click, so let the client know:
	lemOutData.new_state = INVALID_NEW_STATE;
	lemOutData.index = INVALID_INDEX;
	pLemOutData->new_state = INVALID_NEW_STATE;
	pLemOutData->index = INVALID_INDEX;
	bool selectThis = false;

	if(leftButtonDown)iconSelected = statusPanel->SelectIcon(x, y);
	iconSelected = statusPanel->GetSelectedIcon();

	//is the mouse over a lemmings?
	for (int n = 0; n < max_num_lemmings; n++) {
		Lemming* potentialNewSelected = ulemmings.lemmings[n];

		//first should we even do this one?
		selectThis = false;

		switch (gameType) {
			case (StatusPanel::Server):
				if (potentialNewSelected->GetPlayerNum() == 1)
					selectThis = true;
			break;
			case (StatusPanel::Client):
				if (potentialNewSelected->GetPlayerNum() == 2)
					selectThis = true;
			break;
			case (StatusPanel::SinglePlayer):
				selectThis = true;
			break;
		}

		if (potentialNewSelected != NULL && selectThis &&
				potentialNewSelected->GetAliveState() &&
				!(potentialNewSelected->GetState() & EXPLODING) &&
				!(potentialNewSelected->GetState() & ARRIVED_HOME)
				) {
			if (potentialNewSelected->IsPointWithin(xx + statusPanel->viewport.x, yy + statusPanel->viewport.y)) {
				//this lemming is a candidate
				if(selectedSprite == NULL){
					//yes, there's nowt else so a've it
					potdist = getDistanceToLemming(potentialNewSelected,xx+statusPanel->viewport.x,yy+statusPanel->viewport.y);
					selectedSprite = ulemmings.lemmings[n];
					selectedIndex = n;selectedCount++;
				}
				else{
					//this is a bit more difficult then
					//we need to decide if this one is a better
					//candidate or not.

					//the first choice should be which is closer
					int dist = getDistanceToLemming(potentialNewSelected,xx+statusPanel->viewport.x,yy+statusPanel->viewport.y);
					if(dist < potdist){
						//CLOSER
						//if potential guy is already whatever we're trying to set then don't bother EVER
						if(!(potentialNewSelected->GetState() & iconSelected)){
							//printf("  new lem is not what icon we have\n");
							//he's not one, so use him..perhaps

							//if current selected is NOT blocker and we're NOT set to nuke
							if( !((selectedSprite->GetState()&BLOCKER) && iconSelected==NUKE) ){
								selectedSprite = ulemmings.lemmings[n];
								selectedIndex = n; selectedCount++;
							}
							else if( ((potentialNewSelected->GetState()&BLOCKER) && iconSelected==NUKE) ){
								//if both the same then the closer one wins out!
								selectedSprite = ulemmings.lemmings[n];
								selectedIndex = n; selectedCount++;
							}
							else if(potentialNewSelected->GetState() == selectedSprite->GetState()){
								//if both the same then the closer one wins out!
								selectedSprite = ulemmings.lemmings[n];
								selectedIndex = n; selectedCount++;
							}
							else if(selectedSprite->GetState() & iconSelected){
								//if the one we already have is already this
								selectedSprite = ulemmings.lemmings[n];
								selectedIndex = n; selectedCount++;
							}
						}
					}
					else{
						//NOT CLOSER but still inside, so now further checks:
						//printf("new lem is NOT closer\n");
						//Is the potential one a blocker and are we tyring to nuke? (and it's not already counting down)
						if( (potentialNewSelected->GetState() & BLOCKER) && iconSelected == NUKE && (potentialNewSelected->CountingDown() != -2) ){
							//yes, so let user nuke blocker
							selectedSprite = ulemmings.lemmings[n];
							selectedIndex = n; selectedCount++;
						}
						else if( !(selectedSprite->GetState() & BLOCKER) && iconSelected == NUKE && (selectedSprite->CountingDown() != -2) ){
							selectedSprite = ulemmings.lemmings[n];
							selectedIndex = n; selectedCount++;
						}
						else if( (selectedSprite->GetState() & BLOCKER) && (iconSelected == BUILDER || iconSelected == MINER || iconSelected == BASHER)){
							selectedSprite = ulemmings.lemmings[n];
							selectedIndex = n; selectedCount++;
						}
						else if(selectedSprite->GetState() & iconSelected){
							//if the one we already have is already this
							selectedSprite = ulemmings.lemmings[n];
							selectedIndex = n; selectedCount++;
						}
					}
				}
			}
		}
	}

	if(gameData.ticksSinceNukeClick > 0)
		gameData.ticksSinceNukeClick++;

	if (leftButtonDown) {
		int doaction = -1;
		switch (statusPanel->SelectIcon(x,y)) {
			case (DIGGER):

				if (selectedSprite != NULL){
					if(currentLevel->ToolAvailable(Level::DIGGER_TOOL)){
						if(!currentLevel->IsPointMetalArea(selectedSprite->GetX(), selectedSprite->GetY()+2)){
							doaction = 7;
						}
						else
							samples->PlaySample(CHINK);
					}
				}

			break;
			case (MINER):
				if (selectedSprite != NULL){
					if(currentLevel->ToolAvailable(Level::MINER_TOOL)){
						if(!currentLevel->IsPointMetalArea(selectedSprite->GetX() +
										(selectedSprite->GetState() & GOING_LEFT) ? -6 : 8, selectedSprite->GetY()+2)){
							doaction = 6;
						}
						else samples->PlaySample(CHINK);
					}
				}
			break;
			case (BASHER):
				if (selectedSprite != NULL){
					if(currentLevel->ToolAvailable(Level::BASHER_TOOL)){
						if(!currentLevel->IsPointExpandedMetalArea(selectedSprite->GetX() +
											(selectedSprite->GetState() & GOING_LEFT) ? -8 : 10
											, selectedSprite->GetY()-2)){
							doaction = 5;
						}
						else samples->PlaySample(CHINK);
					}
				}
			break;
			case (BUILDER):
				if (selectedSprite != NULL && currentLevel->ToolAvailable(Level::BUILDER_TOOL))
					doaction = 4;
			break;
			case (BLOCKER):
				if (selectedSprite != NULL && currentLevel->ToolAvailable(Level::BLOCKER_TOOL))
					doaction = 3;
			break;
			case (NUKE):
				if (selectedSprite != NULL && currentLevel->ToolAvailable(Level::NUKE_TOOL))
					doaction = 2;
			break;
			case (FLOATER):
				if (selectedSprite != NULL && currentLevel->ToolAvailable(Level::FLOATER_TOOL))
					doaction = 1;
			break;
			case (CLIMBER):
				if (selectedSprite != NULL && currentLevel->ToolAvailable(Level::CLIMBER_TOOL))
					doaction = 0;
			break;

			case (3):
				if(gameData.ticksSinceNukeClick > 0 && gameData.ticksSinceNukeClick < 8){
					if (gameType == StatusPanel::SinglePlayer) {
						if (!nukeAll) {
							//always play oh no sample if single player
							samples->PlaySample(OHNO);
							nukeAll = true;
							gameData.nukeCount = 0;
						}
					} else {
						if (gameType == StatusPanel::Client && !greenNuked) {
							doaction = 8;
							selectedIndex = INVALID_INDEX;
						} else if (!blueNuked) {
							doaction = 8;
							selectedIndex = INVALID_INDEX;
						}
					}
					gameData.ticksSinceNukeClick=0;
				}
				else gameData.ticksSinceNukeClick = 1;
			break;

			case (-2):
				if (gameType == StatusPanel::SinglePlayer) {
					pause = !pause;
				}
			break;

			default:
				doaction = INVALID_NEW_STATE;
				selectedIndex = INVALID_INDEX;
				break;
		}

		//now, if we need to do something
		if (doaction != INVALID_NEW_STATE) {
			//we did something, so save the data
			lemOutData.new_state = (byte) doaction;
			lemOutData.index = (byte) selectedIndex;
			pLemOutData->new_state = (byte) doaction;
			pLemOutData->index = (byte) selectedIndex;
		}
	}

	//Shows the type of Lemming in the status panel
	if (selectedSprite != NULL) {
		if ((selectedSprite->GetState() & FALLING))
			statusPanel->SetSelectedStatus("Faller", selectedCount);
		else if ((selectedSprite->GetState() & CLIMBER) && (selectedSprite->GetState() & FLOATER))
			statusPanel->SetSelectedStatus("Athlete", selectedCount);
		else if ((selectedSprite->GetState() & FLOATER))
			statusPanel->SetSelectedStatus("Floater", selectedCount);
		else if ((selectedSprite->GetState() & CLIMBER))
			statusPanel->SetSelectedStatus("Climber", selectedCount);
		else if (selectedSprite->GetState() & WALKING)
			statusPanel->SetSelectedStatus("Walker", selectedCount);
		else if (selectedSprite->GetState() & NUKE)
			statusPanel->SetSelectedStatus("Bomber", selectedCount);
		else if (selectedSprite->GetState() & BUILDER)
			statusPanel->SetSelectedStatus("Builder", selectedCount);
		else if (selectedSprite->GetState() & DIGGER)
			statusPanel->SetSelectedStatus("Digger", selectedCount);
		else if (selectedSprite->GetState() & MINER)
			statusPanel->SetSelectedStatus("Miner", selectedCount);
		else if (selectedSprite->GetState() & BASHER)
			statusPanel->SetSelectedStatus("Basher", selectedCount);
		else if (selectedSprite->GetState() & BLOCKER)
			statusPanel->SetSelectedStatus("Blocker", selectedCount);
		else
			statusPanel->SetSelectedStatus("", 0);
	} else
		statusPanel->SetSelectedStatus("", 0);
}

bool Game::SetMousePosition(int x, int y, long leftButtonDown, long rightButtonDown, long lbuttonHeld){
	bool updateRequired=false;
	mouseX = x;
	mouseY = y;

	if (x < ((gameType != StatusPanel::SinglePlayer) ? 64 : 2)) {
		statusPanel->viewport.x += -(rightButtonDown ? 8 : 1);
		if (statusPanel->viewport.x <= 0)
			statusPanel->viewport.x = 0;
		else
			updateRequired=true;
	} else if (x > screenWidth * 2 - 2) {
		statusPanel->viewport.x -= -(rightButtonDown ? 8 : 1);
		if (statusPanel->viewport.x > currentLevel->GetBackgroundWidth() - (screenWidth * zoom) )
			statusPanel->viewport.x = currentLevel->GetBackgroundWidth() - screenWidth * zoom;
		else
			updateRequired=true;
	}

	if (lbuttonHeld && gameType == StatusPanel::SinglePlayer) {
		if (mouseY > statusPanel->ypos) {
			unsigned int rr = currentLevel->GetReleaseRate();
			if (mouseX > 38 && mouseX <= 38 + 20) {
				if (rr < 99){
					currentLevel->SetReleaseRate(rr + 1);
					updateRequired=true;
				}
			} else if (mouseX > 8 && mouseX <= 8 + 20) {
				if (rr > gameData.minReleaseRate){
					currentLevel->SetReleaseRate(rr - 1);
					updateRequired=true;
				}
			}
		}
	}

	if (lbuttonHeld)
		statusPanel->UpdateOverviewOffset(x, y);

	currentLevel->SetViewPort(&statusPanel->viewport);

	return updateRequired;
}

void Game::HandleKey(int key) {
	switch (key) {
	case (SDLK_UP):
		sprites->TestSprite(1);
		break;

	case (SDLK_DOWN):
		sprites->TestSprite(-1);
		break;

	case (SDLK_RIGHT):
		sprites->TestFrame(1);
				//sIconX += 16;
		//if(sIconX > 145)
		//{
		//	sIconX = 32;
		//}
		break;

	case (SDLK_LEFT):
sprites->TestFrame(-1);
				//sIconX -= 15;
		//if(sIconX < 32)
		//{
		//	sIconX = 145 + 16;
		//}
		break;

	case (SDLK_m):
		effects_only = !effects_only;
	break;

	case (SDLK_p):
		if(gameType == StatusPanel::SinglePlayer)
			Pause();
	break;

	case (SDLK_d):
#if DEBUG
		debugMode++;
		if (debugMode == 4)
			debugMode = 0;
#endif
	//currentLevel->debug = debugMode>0;
	break;
	case (SDLK_a):
		AddNewLemming(mouseX ,mouseY);
	break;
	}
}

int Game::GetPercentDone() {
	return (gameData.numHome * 100) / currentLevel->GetNumLemmings();
}

/*
 * Draw everything on the screen.
 */
void Game::Draw(SDL_Surface *screen) {
	//Clear the screen
	SDL_FillRect(screen, screen_size, BACKGROUND_COLOUR);

	currentLevel->DrawExitsEntrancesWater(screen, NULL);
	utility->apply_surface(0, 0, currentLevel->GetBackground(), screen, &statusPanel->viewport);
	currentLevel->RenderAllOneWayIndicators(screen);

	statusPanel->Draw(screen);
	DrawLemmings(screen);
	statusPanel->DrawTotals(screen);


#if DEBUG
	if(debugMode == 2){
		currentLevel->DrawDebugStuff(screen);
		sprites->DrawTestAnimationBlocks(screen);
	}
	else if(debugMode == 3)
		sprites->DrawAnimations(screen);

	if (selectedSprite != NULL && debugMode)
		utility->DrawBox(screen, selectedSprite->GetX()
				- statusPanel->viewport.x - 3, selectedSprite->GetY()
				- statusPanel->viewport.y, 10, 12);
#endif
}
void Game::DrawCursor(SDL_Surface* screen){
	if (selectedSprite == NULL) {//just draw cross-hair
		utility->apply_surface(mouseX - sprites->crossHair.offset.x,
							   mouseY - sprites->crossHair.offset.y,
							   sprites->cursors, screen,
							   &sprites->crossHair.clip);
	} else {//draw selected 'box'
		utility->apply_surface(mouseX - sprites->LemmingSelected.offset.x,
							   mouseY - sprites->LemmingSelected.offset.y,
							   sprites->cursors, screen,
							   &sprites->LemmingSelected.clip);
	}
}

void Game::DrawLemmings(SDL_Surface* screen) {
	Lemming* s;
	int state;
	SpriteStore::AnimObject *animFrame;
	for (int n = 0; n < max_num_lemmings; n++) {
		s = ulemmings.lemmings[n];
		state = s->GetState();
		if (s->GetAliveState() && !(s->GetState() & ARRIVED_HOME)) {
			//first get the correct clip/sprite
			animFrame = NULL;
			if (state & WALKING) {
				if (state & GOING_RIGHT) {
					animFrame = &sprites->walkerRight[s->GetFrame()];
				} else {
					animFrame = &sprites->walkerLeft[s->GetFrame()];
				}
			} else if (state & DIGGER) {
				animFrame = &sprites->diggerDowns[s->GetFrame()];
			} else if (state & BUILDER) {
				if (state & GOING_RIGHT) {
					animFrame = &sprites->builderRights[s->GetFrame()];
				} else {
					animFrame = &sprites->builderLefts[s->GetFrame()];
				}
				if (s->GetBuilderRunOut()) {
					samples->PlaySample(TING);
				}
			} else if (state & NOW_CLIMBING) {
				if (state & GOING_RIGHT) {
					animFrame = &sprites->climberRights[s->GetFrame()];
				} else {
					animFrame = &sprites->climberLefts[s->GetFrame()];
				}
			} else if (state & STOPPED_CLIMBING) {
				if (state & GOING_RIGHT) {
					animFrame = &sprites->stoppedClimbingRights[s->GetFrame()];
				} else {
					animFrame = &sprites->stoppedClimbingLefts[s->GetFrame()];
				}
			} else if (state & BLOCKER) {
				animFrame = &sprites->blockers[s->GetFrame()];
#ifdef DEBUG
				if (debugMode)
					utility->DrawBox(screen, s->GetX()-3 - statusPanel->viewport.x,
										 s->GetY() - statusPanel->viewport.y,
										 6, s->GetHeight()+4);
#endif
			} else if (state & FALLING) {
				if ((state & FLOATER) && s->FallingFarEnoughToOpenBrolly()) {
					if (state & GOING_RIGHT) {
						if (state & OPENING_BROLLY) {
							animFrame = &sprites->openBrollyRight[s->GetFrame()];
						} else {
							animFrame = &sprites->floaterRight[s->GetFrame()];
						}
					} else {
						if (state & OPENING_BROLLY) {
							animFrame = &sprites->openBrollyLeft[s->GetFrame()];
						} else {
							animFrame = &sprites->floaterLeft[s->GetFrame()];
						}
					}
				} else {
					if (state & GOING_RIGHT) {
						animFrame = &sprites->fallerRight[s->GetFrame()];
					} else {
						animFrame = &sprites->fallerLeft[s->GetFrame()];
					}
				}
			} else if (state & BASHER) {
				if (state & GOING_RIGHT) {
					animFrame = &sprites->basherRights[s->GetFrame()];
				} else {
					animFrame = &sprites->basherLefts[s->GetFrame()];
				}
			} else if (state & MINER) {
				if (state & GOING_RIGHT) {
					animFrame = &sprites->minerRights[s->GetFrame()];
				} else {
					animFrame = &sprites->minerLefts[s->GetFrame()];
				}
			} else if (state & DONE_BUILDING) {
				if (state & GOING_RIGHT) {
					animFrame = &sprites->doneBuildingRights[s->GetFrame()];
				} else {
					animFrame = &sprites->doneBuildingLefts[s->GetFrame()];
				}
			} else if (state & SPLATTED) {
				if (s->GetFrame() == 0)
					samples->PlaySample(SPLAT);
				animFrame = &sprites->splatters[s->GetFrame()];
			} else if ((state & NUKE)) {
				animFrame = &sprites->nukes[s->GetFrame()];
			} else if (state & GOING_HOME) {
				if (state & GOING_RIGHT) {
					animFrame = &sprites->goingHomeRight[s->GetFrame()];
				} else {
					animFrame = &sprites->goingHomeLeft[s->GetFrame()];
				}
			} else if (state & DROWNER) {
				animFrame = &sprites->drowners[s->GetFrame()];
				if (s->GetFrame() == 0)
					samples->PlaySample(SPLASH);
			} else if (state & BURNER) {
				animFrame = &sprites->burners[s->GetFrame()];
				if (s->GetFrame() == 0)
					samples->PlaySample(FIRE);
			}

#ifdef DEBUG
			//debug point
			if (debugMode)
				utility->DrawBox(screen, s->GetX() - statusPanel->viewport.x,
									 s->GetY() + s->GetHeight() - 2 - statusPanel->viewport.y,
												 2, 2);
#endif
			if (animFrame != NULL) {
				//finally actually draw the sprite frame:
				int tx = (s->GetX() - statusPanel->viewport.x) + animFrame->offset.x * zoom;
				int ty = (s->GetY() - statusPanel->viewport.y) + animFrame->offset.y * zoom;
				if(tx < screen_size->w &&
						tx > (gameType != StatusPanel::SinglePlayer ? 58 : 0) - s->GetWidth()
					&& ty > 0 && ty < screen_size->h) {
					if (s->GetPlayerNum() == 1 || gameType == StatusPanel::SinglePlayer) {

						//draw a blue lemming!
						utility->apply_surface_zoomed(tx,ty,sprites->player1Sprites, screen, &animFrame->clip, zoom);
					} else {
						//draw a green lemming!
						utility->apply_surface_zoomed(tx,ty,sprites->player2Sprites, screen, &animFrame->clip, zoom);
					}
				}

				statusPanel->DrawMarker(s->GetX(), s->GetY(), screen);
			}

			//if the lemming is moribund (dead or dying, in this case dying)
			short timeToDie = s->CountingDown();
			if ((s->GetRawNukeCount() > 1) && timeToDie != -2 && !(state & EXPLODING)) {
				//draw a countdown timer
				SDL_Rect* timeRect = &sprites->countDown[timeToDie].clip;
				utility->apply_surface_zoomed(s->GetX() - statusPanel->viewport.x
						+ sprites->countDown[timeToDie].offset.x * zoom,
						s->GetY() - statusPanel->viewport.y - (6*zoom), sprites->player1Sprites,
						screen, timeRect, zoom);
			}

			if (debugMode)
				utility->DrawBox(screen, s->GetX() - statusPanel->viewport.x,
					s->GetY() + s->GetHeight() - 2 - statusPanel->viewport.y,
												 2, 2);


		}

		if (state & EXPLODING) {
			if (s->DrawExplosion(screen, &statusPanel->viewport) == 1) {
				utility->apply_surface_zoomed(
						s->GetX() - (16*zoom) - statusPanel->viewport.x, s->GetY()
						- (10*zoom) - statusPanel->viewport.y,
						sprites->player1Sprites, screen, &sprites->bang.clip, zoom);
			}
		}
	}
}
void Game::AddNewLemming(int mx,int my) {
	ulemmings.lemmings[gameData.blueOut]->SetAlive(mx + statusPanel->viewport.x , (my + statusPanel->viewport.y));
	ulemmings.lemmings[gameData.blueOut]->SetPlayerNum(1);
	gameData.blueOut++;
}
/*
 * Adds a new Lemming.
 */
void Game::AddNewLemming() {
	bool green, blue;
	green = blue = false;
	//is this player a blue (player 1) or green (player 2)
	if (gameType != StatusPanel::SinglePlayer) {
		if (gameData.greenOut < greenGameMaxLems && gameData.blueOut < blueGameMaxLems) {
			if ((gameData.numberReleased % 2)) {//green player
				green = true;
			} else {
				blue = true;
			}
		} else {
			if ((gameData.numberReleased % 2) && greenGameMaxLems > gameData.greenOut) {
				green = true;
			} else if (greenGameMaxLems > gameData.blueOut) {
				blue = true;
			}
		}
	}
	else blue = true;

	if(green){
		ulemmings.lemmings[gameData.greenOut+80]->SetAlive(currentLevel->GetEntranceX(gameData.releasePoint),
												  currentLevel->GetEntranceY(gameData.releasePoint) - 16);
		ulemmings.lemmings[gameData.greenOut+80]->SetPlayerNum(2);
		ulemmings.lemmings[gameData.greenOut+80]->ChangeDirection();
		gameData.greenOut++;
	}
	else if(blue){
		ulemmings.lemmings[gameData.blueOut]->SetAlive(currentLevel->GetEntranceX(gameData.releasePoint),
												 currentLevel->GetEntranceY(gameData.releasePoint) - 16);
		ulemmings.lemmings[gameData.blueOut]->SetPlayerNum(1);
		gameData.blueOut++;
	}

	gameData.numberReleased++;
	gameData.releasePoint++;
}

int Game::TimeRemaining() {
	return timeRemaining;
}

void Game::SetMusicOn() {
	effects_only = false;
}

void Game::SetMusicOff() {
	effects_only = true;
}

void Game::SetAllSoundOff() {
	//TODO: Implement this function!
}

/*
 * Test to see if the game is complete.
 */
bool Game::IsGameComplete() {
	return (timeRemaining <= 0 || LemmingsSavedPercent() == 100
			||	(gameData.numberReleased == currentLevel->GetNumLemmings() && gameData.totalOut == 0)
			|| (nukeAll && gameData.totalOut == 0));
}

int Game::LemmingsSavedPercent() {
	return ((gameData.numHome * 100) / (currentLevel->GetNumLemmings()));
}

int Game::LemmingsNeededPercent() {
	return (currentLevel->GetLemmingsToBeSaved() * 100) / (currentLevel->GetNumLemmings());
}

bool Game::WasGameNuked() {
	return nukeAll && (gameData.nukeCount > 100 && gameData.totalOut == 0);
}

/*
 * Returns true if the game was won, false otherwise.
 */
bool Game::WasGameWon() {
	if(gameType == StatusPanel::SinglePlayer)
		return currentLevel->GetLemmingsToBeSaved() <= gameData.numHome;
	else {
		if(BlueHome() != GreenHome()){
			if(gameType == StatusPanel::Server)
				return BlueHome() > GreenHome();
			else //if(gameType == StatusPanel::Client)
				return GreenHome() > BlueHome();
		}
		else
		{
			//game draw
			return false;
		}
	}
}

int Game::AnimateLemming(Lemming* s) {
	int gone_home = -1;
	if (s->GetAliveState() && !(s->GetState() & ARRIVED_HOME)) {
		if (!(s->GetState() & EXPLODING))
		{
			gameData.totalOut++;
			if(s->GetPlayerNum() == 1 && gameType == StatusPanel::Server)
				gameData.thisTotalOut++;
			else if (s->GetPlayerNum() == 2 && gameType == StatusPanel::Client)
				gameData.thisTotalOut++;
		}
		s->AnimateFrame();
		s->Move(currentLevel->GetBackground());

		//now check the lemming hasn't gone outside of the screen
		if (s->GetX() >= LEVEL_X_SIZE*zoom || s->GetX() < 0 || s->GetY()
				>= (LEVEL_Y_SIZE-10)*zoom || s->GetY() < 0) {
			samples->PlaySample(DIE);
			s->SetDead();
		}
		else{
			for (int m = 0; m < max_num_lemmings; m++) {
				if (ulemmings.lemmings[m] != s) {
					s->CheckForBlocker(ulemmings.lemmings[m], m);
				}
			}

			if (nukeAll && gameData.nukeCount >= 2) {
					//don't nuke them all at the same time,
					//it looks much better if they go off at
					//different times.
					if (!(s->GetState() & GOING_HOME) && !(s->GetState() & NUKE)
							&& !(s->GetState() & EXPLODING) && !(s->GetState()
									& DROWNER) && !(s->GetState() & BURNER)) {
						s->SetToNuke();
						gameData.nukeCount = 1;
					}
			}

			//Now check if the lemming has reached the exit
			if (!(s->GetState() & GOING_HOME) && (s->GetState() != DEAD)
					&& !(s->GetState() & EXPLODING)) {
				//gone_home = currentLevel->IsPointInHome(s->GetX(), s->GetY());
				if (currentLevel->IsPointInHome(s->GetX(), s->GetY())/*gone_home*/ != -1) {
					//but a blue entrance or a green one?
					s->SetGoingHome();
					samples->PlaySample(BOING);
				}
			}

			if(s->GetState() & ARRIVED_HOME){
				//is he home yet?
				gone_home = currentLevel->IsPointInHome(s->GetX(), s->GetY());
				if(gone_home != -1){
					//but a blue entrance or a green one?
					//if (gone_home % 2 == 0) {
					if(currentLevel->IsBlueHome(gone_home)){
						gone_home = StatusPanel::Server;
					} else {
						gone_home = StatusPanel::Client;
					}
					gameData.numHome++;
				}
			}

			if (currentLevel->IsPointInTrap(s->GetX(), s->GetY())) {
				s->SetDead();
			}
			else if (currentLevel->IsPointInHazard(s->GetX(), s->GetY())
					&& !(s->GetState() & DROWNER) && !(s->GetState() & BURNER)
					&& (s->GetState() != DEAD)) {
				s->SetBurning();
			}
			else if (!(s->GetState() & DROWNER) && (s->GetState() != DEAD)) {
				if(currentLevel->IsPointInWater(s->GetX(), s->GetY()))
					s->SetDrowning();
			}

			//now Stuff that affects the background
			//check for miners,builders,diggers,bashers,bombers
			if (s->GetState() & DIGGER) {
				DoDigAction(s);
			} else if (s->GetState() & MINER) {
				DoMinerAction(s);
			} else if ((s->GetState() & BASHER)) {
				DoBasherAction(s);
			}
			else if(s->GetState() & NUKE && (!nukeAll && s->GetRawNukeCount() == 1)) {
				samples->PlaySample(OHNO);
			}
			else if ((s->GetState() & EXPLODING) && s->ShallIDrawExplosion()) {
				DoExplosion(s);
			}
			else if((s->GetState() & BUILDER) && s->ShallIBuildBlock()){
				DoBuildAction(s);
			}
		}
	}
	return gone_home;
}

void Game::DoDigAction(Lemming* s){
	if (!currentLevel->IsPointMetalArea(s->GetX(), s->GetY())) {
		//where are we digging/affecting backgrund? Lemming or here!?
		if (s->GetFrame() == 0 || s->GetFrame() == 8 || s->GetFrame() == 15) {

			if(gameType != StatusPanel::SinglePlayer){
				ImageBlock* ib = &arRebuildSurfaces[rebuildSurfaceCount];

				if(ib->image != NULL) SDL_FreeSurface(ib->image);

				//store this graphic area
				ib->x = s->GetX() - (4*zoom);
				ib->y = s->GetY() + (7*zoom);
				ib->image = SDL_CreateRGBSurface(currentLevel->GetBackground()->flags,
												(9*zoom),
												(3*zoom),
												currentLevel->GetBackground()->format->BitsPerPixel,
												currentLevel->GetBackground()->format->Rmask,
												currentLevel->GetBackground()->format->Gmask,
												currentLevel->GetBackground()->format->Bmask,
												currentLevel->GetBackground()->format->Amask);

				ib->image->format->colorkey = SDL_MapRGB(ib->image->format, 255,128, 0);

				//now copy the pixels across
				utility->CopyArea(currentLevel->GetBackground(),ib->image,ib->x,ib->y);

				//up the count!
				rebuildSurfaceCount++;
			}

			//now actually draw the thing
			SDL_Rect block;
			block.w = (9*zoom);
			block.h = (3*zoom);
			block.x = s->GetX() - (4*zoom);
			block.y = s->GetY() + (7*zoom);
			SDL_FillRect(currentLevel->GetBackground(), &block, BLACK_COLOUR);
		}
	} else {
		samples->PlaySample(CHINK);
		s->SetToWalker();
	}
}

void Game::DoMinerAction(Lemming* s){
	if (s->GetState() & GOING_RIGHT) {
		if (!currentLevel->IsPointMetalArea(s->GetX() + 10, s->GetY())) {
			if (s->Mined()) {
				//draw a black blob in the right place...
				int f = s->GetFrame();
				if (f <= 3)
				{
					if(gameType != StatusPanel::SinglePlayer){
						ImageBlock* ib = &arRebuildSurfaces[rebuildSurfaceCount];

						if(ib->image != NULL) SDL_FreeSurface(ib->image);

						//store this graphic area
						ib->x = s->GetX() + sprites->bashRightMasks[f].offset.x * zoom;
						ib->y = s->GetY() + sprites->bashRightMasks[f].offset.y * zoom;
						ib->image = SDL_CreateRGBSurface(currentLevel->GetBackground()->flags,
														sprites->bashRightMasks[f].clip.w*zoom,
														sprites->bashRightMasks[f].clip.h*zoom,
														currentLevel->GetBackground()->format->BitsPerPixel,
														currentLevel->GetBackground()->format->Rmask,
														currentLevel->GetBackground()->format->Gmask,
														currentLevel->GetBackground()->format->Bmask,
														currentLevel->GetBackground()->format->Amask);
						ib->image->format->colorkey = SDL_MapRGB(ib->image->format, 255,128, 0);
						//now copy the pixels across
						utility->CopyArea(currentLevel->GetBackground(),ib->image,ib->x,ib->y);

						//up the count!
						rebuildSurfaceCount++;
					}

					utility->apply_surface_zoomed(
									   s->GetX() + sprites->bashRightMasks[f].offset.x * zoom,
									   s->GetY() + sprites->bashRightMasks[f].offset.y * zoom,
									   sprites->player1Sprites,
									   currentLevel->GetBackground(),
									   &sprites->bashRightMasks[f].clip, MASK_COLOUR,zoom);
				}
			}
		} else {
			samples->PlaySample(CHINK);
			s->SetToWalker();
		}
	} else if (!currentLevel->IsPointMetalArea(s->GetX() - 8, s->GetY())) {

		if (s->Mined()) {
			//draw a black blob in the right place...
			int f = s->GetFrame();
			if (f <= 3)
			{
				if(gameType != StatusPanel::SinglePlayer){
					ImageBlock* ib = &arRebuildSurfaces[rebuildSurfaceCount];

					if(ib->image != NULL) SDL_FreeSurface(ib->image);

					//store this graphic area
					ib->x = s->GetX() + sprites->bashLeftMasks[f].offset.x * zoom;
					ib->y = s->GetY() + sprites->bashLeftMasks[f].offset.y * zoom;
					ib->image = SDL_CreateRGBSurface(currentLevel->GetBackground()->flags,
													sprites->bashLeftMasks[f].clip.w*zoom,
													sprites->bashLeftMasks[f].clip.h*zoom,
													currentLevel->GetBackground()->format->BitsPerPixel,
													currentLevel->GetBackground()->format->Rmask,
													currentLevel->GetBackground()->format->Gmask,
													currentLevel->GetBackground()->format->Bmask,
													currentLevel->GetBackground()->format->Amask);
					ib->image->format->colorkey = SDL_MapRGB(ib->image->format, 255,128, 0);
					//now copy the pixels across
					utility->CopyArea(currentLevel->GetBackground(),ib->image,ib->x,ib->y);

					//up the count!
					rebuildSurfaceCount++;
				}

				utility->apply_surface_zoomed(
									   s->GetX() + sprites->bashLeftMasks[f].offset.x * zoom,
									   s->GetY() + sprites->bashLeftMasks[f].offset.y * zoom,
									   sprites->player1Sprites,
									   currentLevel->GetBackground(),
									   &sprites->bashLeftMasks[f].clip, MASK_COLOUR,zoom);
			}
		}
	} else {
		samples->PlaySample(CHINK);
		s->SetToWalker();
	}
}

void Game::DoBasherAction(Lemming* s){
	SpriteStore::AnimObject* obj = NULL;
	if ((s->GetState() & GOING_RIGHT)) {
		if (!currentLevel->IsPointMetalArea(s->GetX() + 2, s->GetY())
				&& !currentLevel->IsPointOneWayArea(s->GetX() + 2, s->GetY() - 4, 1)) {
			switch (s->GetFrame()) {
			case (3):
			case (19):
			obj = &sprites->bashRightMasks[1];
			break;
			case (4):
			case (20):
			obj = &sprites->bashRightMasks[2];
			break;
			case (5):
			case (21):
			obj = &sprites->bashRightMasks[3];
			break;
			}
			if (obj != NULL)
			{
				if(gameType != StatusPanel::SinglePlayer){
					ImageBlock* ib = &arRebuildSurfaces[rebuildSurfaceCount];

					if(ib->image != NULL) SDL_FreeSurface(ib->image);

					//store this graphic area
					ib->x = s->GetX();
					ib->y = s->GetY() + zoom;
					ib->image = SDL_CreateRGBSurface(currentLevel->GetBackground()->flags,
													obj->clip.w*zoom,
													obj->clip.h*zoom,
													currentLevel->GetBackground()->format->BitsPerPixel,
													currentLevel->GetBackground()->format->Rmask,
													currentLevel->GetBackground()->format->Gmask,
													currentLevel->GetBackground()->format->Bmask,
													currentLevel->GetBackground()->format->Amask);
					ib->image->format->colorkey = SDL_MapRGB(ib->image->format, 255,128, 0);

					//now copy the pixels across
					utility->CopyArea(currentLevel->GetBackground(),ib->image,ib->x,ib->y);

					//up the count!
					rebuildSurfaceCount++;
				}

				utility->apply_surface_zoomed(s->GetX(),
											s->GetY() + zoom,
											sprites->player1Sprites,
											currentLevel->GetBackground(),
											&obj->clip,
											MASK_COLOUR, zoom);
			}
		} else {
			samples->PlaySample(CHINK);
			s->SetToWalker();
		}
	} else {//GOING LEFT
		if (!currentLevel->IsPointMetalArea(s->GetX() - 2, s->GetY())
				&& !currentLevel->IsPointOneWayArea(s->GetX() - 2, s->GetY() - 4, 0)) {
			switch (s->GetFrame()) {
				case (3):
				case (19):
				obj = &sprites->bashLeftMasks[1];
				break;
				case (4):
				case (20):
				obj = &sprites->bashLeftMasks[2];
				break;
				case (5):
				case (21):
				obj = &sprites->bashLeftMasks[3];
				break;
			}
			if (obj != NULL){
				if(gameType != StatusPanel::SinglePlayer){
					ImageBlock* ib = &arRebuildSurfaces[rebuildSurfaceCount];

					if(ib->image != NULL) SDL_FreeSurface(ib->image);

					//store this graphic area
					ib->x = s->GetX() - 7*zoom - 1*zoom;
					ib->y = s->GetY() + zoom;
					ib->image = SDL_CreateRGBSurface(currentLevel->GetBackground()->flags,
													obj->clip.w*zoom,
													obj->clip.h*zoom,
													currentLevel->GetBackground()->format->BitsPerPixel,
													currentLevel->GetBackground()->format->Rmask,
													currentLevel->GetBackground()->format->Gmask,
													currentLevel->GetBackground()->format->Bmask,
													currentLevel->GetBackground()->format->Amask);

					ib->image->format->colorkey = SDL_MapRGB(ib->image->format, 255,128, 0);

					//now copy the pixels across
					utility->CopyArea(currentLevel->GetBackground(),ib->image,ib->x,ib->y);

					//up the count!
					rebuildSurfaceCount++;
				}

				utility->apply_surface_zoomed(s->GetX() - 7*zoom - 1*zoom,
											s->GetY() + zoom,
											sprites->player1Sprites,
											currentLevel->GetBackground(),
											&obj->clip,
											MASK_COLOUR, zoom);
			}
		} else {
			samples->PlaySample(CHINK);
			s->SetToWalker();
		}
	}
}

void Game::DoExplosion(Lemming* s){
	//blow a hole in the landscape
	if(!currentLevel->IsPointExpandedMetalArea(s->GetX() - 8, s->GetY() - 8)){

		if(gameType != StatusPanel::SinglePlayer){
			ImageBlock* ib = &arRebuildSurfaces[rebuildSurfaceCount];

			if(ib->image != NULL) SDL_FreeSurface(ib->image);

			//store this graphic area
			ib->x = s->GetX() - (8*zoom);
			ib->y = s->GetY() - (8*zoom);
			ib->image = SDL_CreateRGBSurface(currentLevel->GetBackground()->flags,
											sprites->explosion.clip.w*zoom,
											sprites->explosion.clip.h*zoom,
											currentLevel->GetBackground()->format->BitsPerPixel,
											currentLevel->GetBackground()->format->Rmask,
											currentLevel->GetBackground()->format->Gmask,
											currentLevel->GetBackground()->format->Bmask,
											currentLevel->GetBackground()->format->Amask);

			ib->image->format->colorkey = SDL_MapRGB(ib->image->format, 255,128, 0);

			//now copy the pixels across
			utility->CopyArea(currentLevel->GetBackground(),ib->image,ib->x,ib->y);

			//up the count!
			rebuildSurfaceCount++;
		}

		utility->apply_surface_zoomed(s->GetX() - (8*zoom), s->GetY() - (8*zoom),
			sprites->player1Sprites, currentLevel->GetBackground(),
			&sprites->explosion.clip, MASK_COLOUR,zoom);
	}

	samples->PlaySample(EXPLODE);
}

void Game::DoBuildAction(Lemming* s){
	SDL_Rect block;
	block.w = s->GetWidth();
	block.h = zoom;

	block.y = s->GetY() + s->GetHeight();

	if(s->GetState() & GOING_LEFT)
		block.x = s->GetX() - (5*zoom);
	else
		block.x = s->GetX() + (1*zoom);

	if(gameType != StatusPanel::SinglePlayer){
		ImageBlock* ib = &arRebuildSurfaces[rebuildSurfaceCount];

		if(ib->image != NULL) SDL_FreeSurface(ib->image);

		//store this graphic area
		ib->x = block.x;
		ib->y = block.y;
		ib->image = SDL_CreateRGBSurface(currentLevel->GetBackground()->flags,
										s->GetWidth(),
												zoom,
										currentLevel->GetBackground()->format->BitsPerPixel,
										currentLevel->GetBackground()->format->Rmask,
										currentLevel->GetBackground()->format->Gmask,
										currentLevel->GetBackground()->format->Bmask,
										currentLevel->GetBackground()->format->Amask);
		//now copy the pixels across
		utility->CopyArea(currentLevel->GetBackground(),ib->image,ib->x,ib->y);

		//up the count!
		rebuildSurfaceCount++;
	}

	//draw the actual block
	SDL_FillRect( currentLevel->GetBackground(), &block, SDL_MapRGB( currentLevel->GetBackground()->format, 0xFF, 0xFF, 0xFF ) );

}

bool Game::DoLemmingAction(LemData* lemData, Lemming* incomingLem, int lemIndex) {
	bool actionDone = false;

	if (lemData->index != INVALID_INDEX && (int)lemData->index == lemIndex ) {
		switch (lemData->new_state) {
			case (7):
				actionDone = incomingLem->SetToDigger();
			break;
			case (6):
				actionDone = incomingLem->SetToMiner();
			break;
			case (5):
				 actionDone = incomingLem->SetToBasher();
			break;
			case (4):
				actionDone = incomingLem->SetToBuilder();
			break;
			case (3):
				actionDone = incomingLem->SetToBlocker();
			break;
			case (2):
				actionDone = incomingLem->SetToNuke();
			break;
			case (1):
				actionDone = incomingLem->SetToFloater();
			break;
			case (0):
				actionDone = incomingLem->SetToClimber();
			break;

			default:
				printf("!!!!!!!!!!BAD LEMMING STATE SENT!!!!!!!!!!!! index: %d state: %d\n", lemData->index, lemData->new_state);
			break;
		}
	}

	return actionDone;
}

StatusPanel::GameType Game::GetGameType() {
	return gameType;
}

int Game::BlueHome() {
	return statusPanel->BlueHome();
}

int Game::GreenHome() {
	return statusPanel->GreenHome();
}

void Game::ResetMultiplayer() {
	blueGamesWon = greenGamesWon = 0;
	blueGameMaxLems = greenGameMaxLems = min_multiplay_lemmings;
}

/*
 * Checks in/out data to see if re-animation is required
 */
bool Game::IsReanimationRequired(){
	bool itisimafraid = false;
	LemData *p, *p1;

	//loop through all 'in' Data
	p = &arLemInData[0];
	p1 = &arLemOutData[0];
	for(int n = 0; n < max_frame_store; n++){
		if(p->new_state != INVALID_NEW_STATE || p1->new_state != INVALID_NEW_STATE)
			itisimafraid = true;
		p1++;
		p++;
	}

	return itisimafraid;
}
/* 
 * Animates the frame or in the case of being a 'client' gets the latest positions
 * from the server
 */
void Game::AnimateFrame() {
	AnimateFrame(&lemInData, &lemOutData);
	if(!dataframe){
		StoreGameState();
	}
}
/*
 * Animates the frame or in the case of being a 'client' gets the latest positions
 * from the server
 */
void Game::AnimateFrame(LemData* pInData, LemData* pOutData) {

	if (!pause) {
		//animate, moving stuff:
		currentLevel->Animate();

		int tot;
		if(gameType == StatusPanel::SinglePlayer)
			tot = gameData.totalOut;
		else
			tot = gameData.thisTotalOut;

		//ensure status panel shows the right stuff:
		statusPanel->SetGameStats(timeRemaining, tot,
							(gameData.numHome * 100) / currentLevel->GetNumLemmings(),
							(int) currentLevel->GetReleaseRate(),
							currentLevel->Tools(), gameData.minReleaseRate);

		//check if we need to start the game proper:
		if (gameData.ticksSinceGameStart < 35) {
			if (gameData.ticksSinceGameStart == 0) {
				samples->PlaySample(LETSGO);
			}else if (gameData.ticksSinceGameStart > 18) {
				currentLevel->AnimateEntrance();
			}else if (gameData.ticksSinceGameStart == 18){
				samples->PlaySample(DOOR);
			}
			gameData.ticksSinceGameStart++;
		} else {
			//now start the actual game:
			if(sound_enabled){
				if (!effects_only) {
					if (!music_now_on){
						if(Mix_PlayMusic(levelTune, -1) != -1) {
							music_now_on = true;
						}
					}
				} else if (music_now_on) {
					Mix_FadeOutMusic(500);
					music_now_on = false;
				}
			}

			//only count-down if the game is NOT 2 player.l
			if (++fpsCount >= framesPerSecond && (gameType == StatusPanel::SinglePlayer)) {
				timeRemaining--;
				fpsCount = 1;
			}

			if (!nukeAll) {
				if (++gameData.releaseCounter >= (60 - ((int) currentLevel->GetReleaseRate() * 60 / 105))
						&& gameData.numberReleased < currentLevel->GetNumLemmings()) {
					if(!debugMode && GetPercentDone()<100)AddNewLemming();
					gameData.releaseCounter = 0;
				}

				if (blueNuked && greenNuked) {
					gameData.nukeCount = 0;
					samples->PlaySample(OHNO);
					nukeAll = true;
				} else if (pInData->new_state == 8) {
					if (gameType == StatusPanel::Client) {
						blueNuked = true;
					} else {
						greenNuked = true;
					}
				} else if (pOutData->new_state == 8) {
					if (gameType == StatusPanel::Client) {
						greenNuked = true;
					} else {
						blueNuked = true;
					}
				}
			} else gameData.nukeCount++;

			gameData.thisTotalOut = gameData.totalOut = 0;

			Lemming* s;
			for (int n = 0; n < max_num_lemmings; n++) {
				s = ulemmings.lemmings[n];

				DoLemmingAction(pInData, s, n);

				if (DoLemmingAction(pOutData, s, n)) {
					if(!suppress_tool_decrease){
						currentLevel->UseTool((Level::ToolType) pOutData->new_state);
						samples->PlaySample(DOACTION);
					}
				}

				int exit_reached = AnimateLemming(s);
				if (exit_reached != lemming_arrived_home) {
					//lemming's home, save the fact
					if (exit_reached == StatusPanel::Server) {
						//Lem reached a blue home but is he a blue/server?
						if (s->GetPlayerNum() == 1) {
							statusPanel->AddToBlueTotal(StatusPanel::Server);
						} else {
							statusPanel->AddToBlueTotal(StatusPanel::Client);
						}
					} else {
						//Lem reached a green home but is he a green/server?
						if (s->GetPlayerNum() == 1) {
							statusPanel->AddToGreenTotal(StatusPanel::Server);
						} else {
							statusPanel->AddToGreenTotal(StatusPanel::Client);
						}
					}
				}
			}

			if (!gameData.totalledUp && IsGameComplete()) {
				gameData.totalledUp = true;
				if(gameType != StatusPanel::SinglePlayer){
					if (GreenHome() > BlueHome()) {
						greenGamesWon++;
					} else if (GreenHome() < BlueHome()) {
						blueGamesWon++;
					}

					greenGameMaxLems = min_multiplay_lemmings + GreenHome();
					if (greenGameMaxLems > max_num_lemmings / 2)
						greenGameMaxLems = max_num_lemmings / 2;

					blueGameMaxLems = min_multiplay_lemmings + BlueHome();
					if (blueGameMaxLems > max_num_lemmings / 2)
						blueGameMaxLems = max_num_lemmings / 2;
				}
			}
		}
	}
}
