#ifndef GAME_H_
#define GAME_H_

#include "SDL/SDL.h"
#include "SDL/SDL_image.h"
#include "SDL/SDL_net.h"

#include "Lemming.h"
#include "lemmings_graphical_object.h"
#include "lemmings_level.h"
#include <string>
#include <iostream>
#include <vector>
#include "FontRenderer.h"
#include "GraphicsUtility.h"
#include "StatusPanel.h"
#include "LevelLoader.h"
#include "SamplePlayer.h"
#include "SpriteStore.h"
#include "Level.h"

#define IsServerLemming(x) ( ((x)%2) == 0 )

//final + 4 is for the current frame
//#define BUFFER_SIZE max_num_lemmings*(3*4)
#define Y_OFFSET 8

#define INVALID_INDEX 255
#define INVALID_NEW_STATE 255

#define MASK_COLOUR SDL_MapRGB(sprites->player1Sprites->format, 95, 99, 255)
#define BLACK_COLOUR SDL_MapRGB(sprites->player1Sprites->format, 0x00, 0x00, 0x00)
#define BACKGROUND_COLOUR SDL_MapRGB(sprites->player1Sprites->format,0x00,0x00,0x33)

/*
* this is basically where it all happens baby!
 */
class Game
{
	public:
		Game(int, int, int, int, bool, int);
		~Game();

		int GetLevelFromServer();
		bool SetClientLevel(int newLevel);
		void Pause();
		bool IsGameComplete();
		void Init(StatusPanel::GameType);
		bool ConnectToGame(StatusPanel::GameType Sender, std::string IPAddress);
		bool WaitForClientToConnect();
		bool CloseConnection();
		void AnimateFrame();
		bool WasGameWon();
		bool WasGameNuked();
		void Draw(SDL_Surface*);
		void DrawCursor(SDL_Surface*);
		bool RequestForData();
		void HandleKey(int);
		void AddNewLemming();
		void AddNewLemming(int,int);
		bool SetMousePosition(int, int, long, long, long);
		void SetMouseClick(int, int, long);
		int GetPercentDone();
		SDL_Surface* GetLevelPreview();
		int LemmingsSavedPercent();
		int LemmingsNeededPercent();
		int TimeRemaining();
		void LoadLevel(LevelLoader*);
		void Load2PlayerLevel(LevelLoader*);
		void SetMusicOn();
		void SetMusicOff();
		void SetAllSoundOff();
		void ResetMultiplayer();
		int BlueHome();
		int GreenHome();
		StatusPanel::GameType GetGameType();

		SpriteStore* sprites;

		int blueGamesWon, greenGamesWon;
		int blueGameMaxLems, greenGameMaxLems;
		int timeRemaining;
		Level* currentLevel;
		int zoom;
	private:
		struct Offset
		{
			int x;
			int y;
		};

		//TODO: should be able to reduce this even further
		//as max single player lem is actually 80 (I.E. less than
		//256/2=128. So we should be able to use the
		//top 4 bits for 0-80 and the bottom 4 for state
		struct LemData
		{
			byte new_state;//0-8
			byte index;//0-160 (should be 0-80!!!!)
		};

		struct GameData
		{
			int ticksSinceGameStart;
			int ticksSinceNukeClick;
			bool totalledUp;
			int blueOut, greenOut;
			int releasePoint;//the entrance the lemming is released at
			u32 minReleaseRate;
			short nukeCount;
			int releaseCounter;
			u32 numberReleased;
			int totalOut;
			int thisTotalOut;//total out just for this player (client or server)
			u32 numHome;
		};

		struct ImageBlock{
			int x;
			int y;
			SDL_Surface* image;
		};

		//int MASK_COLOUR, BLACK_COLOUR, BACKGROUND_COLOUR;
		static const int data_transfer_size = 2;//TODO: get this down to 1!!
		static const int max_num_lemmings = 160;
		static const int min_multiplay_lemmings = 40;
		static const int lemming_arrived_home = -1;
		Lemming* lemmings_copy[max_num_lemmings];
		union ulemmings{Lemming* lemmings[max_num_lemmings]; byte b[max_num_lemmings*656];}ulemmings;

		void StoreGameState();
		int getDistanceToLemming(Lemming* l, int xp, int yp);
		int AnimateLemming(Lemming*);
		bool DoLemmingAction(LemData*, Lemming*, int);
		void LoadLevel(int, std::string, std::string);
		void DrawActionIcons(SDL_Surface*);
		void DrawLemmings(SDL_Surface*);
		void DoDigAction(Lemming*);
		void DoMinerAction(Lemming*);
		void DoBasherAction(Lemming*);
		void DoExplosion(Lemming*);
		void DoBuildAction(Lemming*);

		bool IsReanimationRequired();
		void AnimateFrame(LemData*, LemData*);

		//private members:
		FontRenderer* fontRenderer;
		GraphicsUtility *utility;
		StatusPanel* statusPanel;
		SamplePlayer* samples;
		LemData lemOutData;
		LemData lemInData;
		Mix_Music *levelTune;
		SDL_Surface* selectedIcon;
		SDL_Rect* screen_size;

		ImageBlock* arRebuildSurfaces;
		int rebuildSurfaceCount;

		LemData* arLemInData;//array of n frame changes
		LemData* arLemOutData;//array of n frame changes
		LemData* pLemInData;//pointer used to traverse (probably not needed)
		LemData* pLemOutData;//pointer used to traverse (probably not needed)
		int dataframe;
		int max_frame_store;//max frame to store!

		GameData gameData;
		GameData gameData_copy;

		TCPsocket sd, csd; // Socket descriptor, Client socket descriptor

		bool blueNuked, greenNuked;
		int fpsCount;
		int screenWidth;
		int screenHeight;
		int framesPerSecond;
		bool effects_only;
		bool music_now_on;
		bool sound_enabled;
		bool suppress_tool_decrease;

		Lemming* selectedSprite;
		StatusPanel::GameType gameType;
		bool connected;
		int mouseX;
		int mouseY;

		int debugMode;
		bool nukeAll;
		bool pause;
};

#endif /*GAME_H_*/
