#include "GraphicsUtility.h"
#include "SDL/SDL_image.h"
#include <iostream>

#define s 2

GraphicsUtility* GraphicsUtility::pinstance = NULL;

GraphicsUtility::GraphicsUtility()
{
	rect.w = rect.h = 1;
}

GraphicsUtility::~GraphicsUtility()
{

}

GraphicsUtility* GraphicsUtility::Instance(){
	if(pinstance == NULL){
		pinstance = new GraphicsUtility();
	}

	return pinstance;
}

SDL_Surface* GraphicsUtility::load_image( std::string filename, Uint32 colourkey )
{ 
	//Temporary storage for the image that's loaded 
	SDL_Surface* loadedImage = NULL; 
	//The optimized image that will be used 
	SDL_Surface* optimizedImage = NULL; 
	//std::cout << "loading: \n" << filename;// << letter << endl;
	loadedImage = IMG_Load( filename.c_str() );
	//If nothing went wrong in loading the image 
	if( loadedImage != NULL ) 
	{ 
		//std::cout << "Loaded: \n" << filename;// << letter << endl;
		//Create an optimized image 
		optimizedImage = SDL_DisplayFormat( loadedImage );
		//if(colourkey != 255)
		SDL_SetColorKey(optimizedImage, SDL_SRCCOLORKEY,SDL_MapRGB(optimizedImage->format,255,0 ,255));
		//Free the old image 
		SDL_FreeSurface( loadedImage ); 
	}
	else
	{
		std::cout << "Failed To Load: \n" << filename;// << letter << endl;	
	}

	//Return the optimized image 
	return optimizedImage;
}

SDL_Surface* GraphicsUtility::load_image( std::string filename )
{
	return load_image(filename,0);
}

void GraphicsUtility::SetPixel(SDL_Surface *surface, int x, int y, Uint32 color)
{
	rect.x = x;
	rect.y = y;
	SDL_FillRect( surface, &rect, color );
}

Uint32 GraphicsUtility::getpixel(SDL_Surface *surface, int x, int y)
{
	if(x >= 0 && y >= 0 && x < surface->w && y < surface->h)
	{
		int bpp = surface->format->BytesPerPixel;
		// Here p is the address to the pixel we want to retrieve 
		Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;
			//printf("p %d", *p);
		switch(bpp) {
		case 1:
			return *p;

		case 2:
			return *(Uint16 *)p;

		case 3:
			if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
				return p[0] << 16 | p[1] << 8 | p[2];
			else
				return p[0] | p[1] << 8 | p[2] << 16;

		case 4:
			return *(Uint32 *)p;

		default:
			return 0;       // shouldn't happen, but avoids warnings 
		}
	}

	return 1;
}

void GraphicsUtility::apply_surface( int xpos, int ypos, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip, Uint32 color )
{ 
	SDL_Rect rect;
	rect.w = 1;
	rect.h = 1;
	rect.x = xpos;
	Uint32 p;
	
	for(int x = clip->x; x < clip->x + clip->w; x++)
	{
		rect.y =+ ypos;
		for(int y = clip->y; y < clip->y + clip->h; y++)
		{
			//copy each pixel..to the actualScreen
			p = getpixel(source, x, y);
			if(p == color )
				SDL_FillRect( destination, &rect, 0);
			rect.y++;
		}
		rect.x++;
	}
}

void GraphicsUtility::apply_surface_zoomed( int xpos, int ypos, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip, int zoom )
{
	SDL_Rect rect;
	rect.w = zoom;
	rect.h = zoom;
	rect.x = xpos;//*zoom;
	Uint32 p;

	for(int x = clip->x; x < clip->x + clip->w; x++)
	{
		rect.y = ypos;//*zoom;
		for(int y = clip->y; y < clip->y + clip->h; y++)
		{
			//copy each pixel..to the actualScreen
			p = getpixel(source, x, y);
			if(p)
			SDL_FillRect( destination, &rect, p);
			rect.y+=zoom;
		}
		rect.x+=zoom;
	}
}

void GraphicsUtility::apply_surface_zoomed( int xpos, int ypos, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip, Uint32 color, int zoom )
{
	SDL_Rect rect;
	rect.w = zoom;
	rect.h = zoom;
	rect.x = xpos;
	Uint32 p;

	for(int x = clip->x; x < clip->x + clip->w; x++)
	{
		rect.y =+ ypos;
		for(int y = clip->y; y < clip->y + clip->h; y++)
		{
			//copy each pixel..to the actualScreen
			p = getpixel(source, x, y);
			if(p == color )
				SDL_FillRect( destination, &rect, 0);
			rect.y+=zoom;
		}
		rect.x+=zoom;
	}
}

void GraphicsUtility::CopyArea(SDL_Surface* src, SDL_Surface* dest, int xs, int ys){
	for(int x = 0; x < dest->clip_rect.w; x++){
		for(int y = 0; y < dest->clip_rect.h; y++){
			SetPixel(dest, x,y, getpixel(src, x+xs, y+ys));
		}
	}
}

/*
 * Stores an area of image from 'keep', at position x/y
 * where
 *
 */
void GraphicsUtility::StoreArea(SDL_Surface* keep, SDL_Surface* mask, SDL_Surface* src, SDL_Rect* clip, int xs, int ys){
	SDL_Rect rect;
	rect.w = 1;
	rect.h = 1;
	rect.x = clip->x;

	SDL_Rect frect;
	frect.w = 1;
	frect.h = 1;
	frect.x = 0;
	frect.y = 0;

	//examine the area at top-left xs/ys, size clip.w/h
	for(int x = xs; x < xs + clip->w; x++)
	{
		rect.y = clip->y;
		frect.y=0;
		for(int y = ys; y < ys + clip->h; y++)
		{
			//if the pixel of the src image (eg. cursor) is not zero, we need to keep it
			if(getpixel(src, rect.x, rect.y) != 0)
			{
				//so, take a pixel from 'keep' image at position
				SDL_FillRect( mask, &frect, getpixel(keep, x, y));
			}
			else SDL_FillRect( mask, &frect, 0);
			rect.y++;
			frect.y++;
		}
		rect.x++;
		frect.x++;
	}
}

void GraphicsUtility::apply_surface_hack( int xpos, int ypos, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip )
{
	SDL_Rect rect;
	rect.w = 1;
	rect.h = 1;
	rect.x = xpos;
	Uint32 p;

	for(int x = clip->x; x < clip->x + clip->w; x++)
	{
		rect.y =+ ypos;
		for(int y = clip->y; y < clip->y + clip->h; y++)
		{
			//copy each pixel..to the actualScreen
			p = getpixel(source, x, y);
			if(p)//!= SDL_MapRGB(source->format, 0,0,0))
				SDL_FillRect( destination, &rect, p);
			rect.y++;
		}
		rect.x++;
	}
}

void GraphicsUtility::apply_surface( int x, int y, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip = NULL )
{ 
	//Holds offsets 
	SDL_Rect offset; 
	//set offsets
	offset.x = x; 
	offset.y = y; 
	SDL_BlitSurface( source, clip, destination, &offset ); 
} 

void GraphicsUtility::apply_surface_zoomed( int xpos, int ypos, SDL_Surface* source, SDL_Surface* destination)
{
	apply_surface_zoomed( xpos, ypos, source, destination, 2, 0);
}

void GraphicsUtility::apply_surface_zoomed( int xpos, int ypos, SDL_Surface* source, SDL_Surface* destination, int zoom  )
{
	apply_surface_zoomed( xpos, ypos, source, destination, zoom, 0);
}

void GraphicsUtility::apply_surface_zoomed( int xpos, int ypos, SDL_Surface* source, SDL_Surface* destination, int zoom, int yoffset  )
{
	if(zoom == 1)
	{
		SDL_BlitSurface( source, NULL, destination, NULL);
	}
	else
	{
		// Now my shit hack to double the pixels (320*200 on a 640*400 res)
		SDL_Rect rect;
		rect.w = rect.h = zoom;
		rect.x = xpos;
		Uint32 p;
		for(int x = 0; x < source->w; x+=1)
		{
			rect.y = ypos;
			for(int y = yoffset; y < source->h; y+=1)
			{
				//copy each pixel..to the actualScreen
				p = getpixel(source,x,y);
				if(p)
					SDL_FillRect( destination, &rect, p);
				rect.y += zoom;
			}
			rect.x += zoom;
		}
	}
}


SDL_Surface* GraphicsUtility::load_image_swap(std::string filename,  Uint32 color1,  Uint32 color2 )
{
	SDL_Surface* final;
	SDL_Surface* temp = load_image( filename);

	//make surface of duplicate dimensions:

	final = SDL_CreateRGBSurface(temp->flags, temp->w, temp->h,
			temp->format->BitsPerPixel,
			temp->format->Rmask, temp->format->Gmask,
			temp->format->Bmask, temp->format->Amask);

	//now go through each pixel swapping the two colours!
	SDL_Rect rect;
	rect.w = rect.h = 1;
	rect.x = 0;
	Uint32 p;

	for(int x = 0; x < temp->w; x++)
	{
		rect.y = 0;

		for(int y = 0; y < temp->h; y++)
		{
			//copy each pixel..to the actualScreen
			p = getpixel(temp, rect.x, rect.y);
			if(p)
			{
				if(p==color1) p=color2;
				else if(p==color2) p=color1;
				SDL_FillRect( final, &rect, p);
			}
			rect.y++;
		}
		rect.x++;
	}

	SDL_FreeSurface(temp);
	return final;
}


void GraphicsUtility::DrawBox(SDL_Surface *screen, SDL_Rect* r, int x, int y){
	DrawBox(screen, x, y-8, r->w, r->h);
}

void GraphicsUtility::DrawBox(SDL_Surface *screen, int x, int y, int w, int h){
	Uint32 c = SDL_MapRGB(screen->format, 200,200,0);
	DrawBox(screen, x, y, w, h, c);
}

void GraphicsUtility::DrawBox(SDL_Surface *screen, int x, int y, int w, int h, Uint32 c)
{
	SDL_Rect overviewRect;
	overviewRect.x = x;
	overviewRect.y = y;
	overviewRect.w = w;
	overviewRect.h = 1;
	SDL_FillRect( screen, &overviewRect, c);

	overviewRect.x = x;
	overviewRect.y = y;
	overviewRect.w = 1;
	overviewRect.h = h;
	SDL_FillRect( screen, &overviewRect, c);

	overviewRect.x = x;
	overviewRect.y = y + h;
	overviewRect.w = w;
	overviewRect.h = 1;
	SDL_FillRect( screen, &overviewRect, c);

	overviewRect.x = x + w;
	overviewRect.y = y;
	overviewRect.w = 1;
	overviewRect.h = h+1;
	SDL_FillRect( screen, &overviewRect, c);
}
