#ifndef UTILITY_H_
#define UTILITY_H_

#include "SDL/SDL.h"
#include "SDL/SDL_image.h"
#include <string>
#define FADE_MAX 8
#define NUM_CHARS 94

class GraphicsUtility
{
	public:
		static GraphicsUtility* Instance();
		~GraphicsUtility();
	
		SDL_Surface* load_image( std::string filename );
		SDL_Surface* load_image( std::string filename, Uint32 color );
		SDL_Surface* load_image_swap(std::string filename,  Uint32 color1,  Uint32 color2 );
		Uint32 getpixel(SDL_Surface *surface, int x, int y);
		void SetPixel(SDL_Surface *surface, int x, int y, Uint32 color);

		void StoreArea(SDL_Surface* keep, SDL_Surface* mask, SDL_Surface* src, SDL_Rect* clip, int xs, int ys);
		void CopyArea(SDL_Surface* src, SDL_Surface* dest, int xs, int ys);

		void apply_surface_hack( int x, int y, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip );
		void apply_surface( int x, int y, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip );
		void apply_surface( int x, int y, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip, Uint32 color );

		void apply_surface_zoomed( int x, int y, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip, Uint32 color, int zoom );
		void apply_surface_zoomed( int x, int y, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip, int zoom );

		void apply_surface_zoomed( int x, int y, SDL_Surface* source, SDL_Surface* destination, int zoom, int yoffset  );
		void apply_surface_zoomed( int x, int y, SDL_Surface* source, SDL_Surface* destination, int zoom);
		void apply_surface_zoomed( int x, int y, SDL_Surface* source, SDL_Surface* destination);

		void DrawBox(SDL_Surface *screen, int x, int y, int w, int h, Uint32 c);
		void DrawBox(SDL_Surface *screen, int x, int y, int w, int h);
		void DrawBox(SDL_Surface *screen, SDL_Rect* r, int x, int y);

	protected:
		GraphicsUtility();

	private:
		static GraphicsUtility* pinstance;
		int s;
		SDL_Rect rect;//used for drawing the one pixel ting.
};

#endif
