/***********************************************************************
 * This is a Lemming, dunno why I didn't call it Lemming.cpp really... 
 * 
 * *********************************************************************/
#include "Lemming.h"

Vector2D* Lemming::gravity = new Vector2D();
short Lemming::fps = 20;
int Lemming::NoCanDo =  BLOCKER|FALLING|NUKE|SPLATTED|DROWNER|BURNER;
int explodeScale=100;//arrrgh, it's geting messy agina!
GraphicsUtility* Lemming::util = GraphicsUtility::Instance();
int Lemming::zoom = 2;

void Lemming::ChangeDirection()
{
	//it was solid all the way up so turn around:
	if((state & GOING_LEFT) == GOING_LEFT)
	{
		state ^= GOING_LEFT;
		state |= GOING_RIGHT;
	}
	else
	{
		state ^= GOING_RIGHT;
		state |= GOING_LEFT;
	}	
}

Lemming::Lemming(int SpriteWidth, int SpriteHeight, int startX, int startY, int newZoom)
{	spriteW = SpriteWidth;
	spriteH = SpriteHeight;
	position = new Vector2D();
	position->SetX(startX);
	position->SetY(startY);
	playerNum = 1;
	SetState(DEAD);
	frame=explosionFrames=0;
	nukeCount = -2;
	//stepping = 0;
	gravity->SetX(0);
	gravity->SetY(20);
	pingponganim=false;
	animInc=1;
	zoom=newZoom;
}

Lemming::~Lemming()
{
	delete(position);
}

/*
 * This clears a lemming so he can turn back into a walker
 */
void Lemming::ClearLemming()
{
	if(state & FALLING) state ^= FALLING;
	if(state & DROWNER) state ^= DROWNER;
	if(state & WALKING) state ^= WALKING;
	if(state & BUILDER) state ^= BUILDER;
	if(state & BASHER) state ^= BASHER;
	if(state & DIGGER) state ^= DIGGER;
	if(state & BLOCKER) state ^= BLOCKER;
	if(state & MINER) state ^= MINER;
	if(state & DONE_BUILDING) state ^= DONE_BUILDING;
	if(state & EXPLODING) state ^= EXPLODING;
}

void Lemming::SetAlive(short x, short y)
{
	state = GOING_RIGHT;
	SetState(WALKING);
	SetState(FALLING);
	explosionFrames=0;
	position->SetX(x);
	position->SetY(y);
	inThisLemming_index = -1;
}

/*
 * This checks if this lemming is blocked by the given lemming
 * if he is then set a flag to say he's in a block
 * but keep walking.
 * If he is not then if flag is on
 */
void Lemming::CheckForBlocker(Lemming* sprite, int index)
{
	short cpX, cpY;
	//first is the given sprite a blocker and this is not a blocker
	if(sprite->GetState() & BLOCKER && !(GetState() & BLOCKER))
	{
		//make sure our lemming is not a blocker, that would be silly:

		cpY = position->GetY() + spriteH - 2;
		cpX = position->GetX();

		if(cpX >= sprite->GetX() - 4*zoom && cpX <= sprite->GetX() + 4*zoom &&
				cpY >= sprite->GetY() && cpY <= sprite->GetY() + GetHeight() + 4*zoom)
		{
			//stop whatever he's doing:
			if(state & BASHER){ state ^= BASHER; SetState(WALKING);}
			if(state & MINER){ state ^= MINER; SetState(WALKING);}
			if(state & DIGGER){ state ^= DIGGER; SetState(WALKING);}
			if(state & BASHER){ state ^= BASHER; SetState(WALKING);}

			//if 'inside' flag is off
			//then turn around,
			//if 'inside flag is on
			//then not keep walking
			//if(inThisLemming == NULL)
			if(inThisLemming_index == -1)
			{
				//only change direction if w
				if(cpX > sprite->GetX() && (state & GOING_LEFT))
					ChangeDirection();
				else if(cpX < sprite->GetX() && (state & GOING_RIGHT))
					ChangeDirection();

				//inThisLemming = sprite;
				inThisLemming_index = index;
			}
		}
		else
		{
			//was he in THIS lemming
			//if(inThisLemming == sprite)
			if(inThisLemming_index == index)
			{
				//he WAS, now he's not so good
				//inThisLemming = NULL;
				inThisLemming_index = -1;
			}
		}
	}
}

void Lemming::SetBurning()
{
	SetState(BURNER);
	if(state & NUKE) state ^= NUKE;
	nukeCount=-2;
}

void Lemming::SetDrowning()
{
	SetState(DROWNER);
	if(state & NUKE) state ^= NUKE;
	nukeCount = -2;
}

void Lemming::SetGoingHome()
{
	SetState(GOING_HOME);	
	//if(state & GOING_RIGHT)
	//	position->SetX(position->GetX() - 1);
	//else
	//	position->SetX(position->GetX() + 1);
	if(state & NUKE) state ^= NUKE;
	if(state & EXPLODING) state ^= EXPLODING;
	nukeCount = -2;
}

void Lemming::SetDead()
{
	SetState(DEAD);
}

void Lemming::SetToWalker()
{	
	SetState(WALKING);
}

bool Lemming::SetToBlocker()
{
	bool ret=false;
	if( !(state == NUKE) &&
		!(state & FALLING) &&
		!(state & SPLATTED) &&
		!(state & BURNER) &&
		!(state & GOING_HOME) &&
		!(state & NOW_CLIMBING) &&
		!(state & STOPPED_CLIMBING) )
	{
		if(!(state & BLOCKER))
		{
			printf("set to blocker\n");
			SetState(BLOCKER);
			ret =true;
		}
	}
	return ret;
}

bool Lemming::SetToNuke()
{
	bool ret=false;
	if(!(state & NUKE) &&
	   !(state & SPLATTED) &&
	    (state != DEAD) &&
	   !(state & BURNER) &&
	   !(state & GOING_HOME))
	{
		SetState(NUKE);
		ret = true;
	}
	return ret;
}

bool Lemming::SetToDigger()
{
	bool ret=false;
	if( !(state & BLOCKER) &&
		!(state & FALLING) &&
		!(state & NUKE) &&
		!(state & SPLATTED) &&
		!(state & BURNER) &&
		!(state & GOING_HOME) &&
		!(state & NOW_CLIMBING) &&
		!(state & STOPPED_CLIMBING) )
	{
		if(!(state & DIGGER))
		{
			SetState(DIGGER);
			ret = true;
		}
	}
	return ret;
}

bool Lemming::SetToMiner()
{
	bool ret=false;
	if( !(state & BLOCKER) &&
		!(state & FALLING) &&
		!(state & NUKE) &&
		!(state & SPLATTED) &&
		!(state & BURNER) &&
		!(state & GOING_HOME) &&
		!(state & NOW_CLIMBING) &&
		!(state & STOPPED_CLIMBING) )
	{
		if(!(state & MINER))
		{
			SetState(MINER);
			return true;
		}
	}
	return ret;
}

bool Lemming::SetToBasher()
{
	bool ret=false;
	if( !(state & BLOCKER) &&
		!(state & FALLING) &&
		!(state & NUKE) &&
		!(state & SPLATTED) &&
		!(state & BURNER) &&
		!(state & GOING_HOME) &&
		!(state & NOW_CLIMBING) &&
		!(state & STOPPED_CLIMBING) )
	{
		if(!(state & BASHER))
		{
			SetState(BASHER);
			ret = true;
		}
	}
	return ret;
}

bool Lemming::SetToFloater()
{
	bool ret=false;
	if( !(state & BLOCKER) && !(state & NUKE) && !(state & SPLATTED) && !(state & BURNER) && !(state & GOING_HOME))
	{
		if(!(state & FLOATER))
		{
			SetState(FLOATER);
			ret = true;
		}
	}
	return ret;
}

bool Lemming::SetToClimber()
{
	bool ret=false;
	if( !(state & BLOCKER) &&
		!(state & NUKE) &&
		!(state & SPLATTED) &&
		!(state & BURNER) &&
		!(state & GOING_HOME) &&
		!(state & STOPPED_CLIMBING) )
	{
		if(!(state & CLIMBER))
		{
			SetState(CLIMBER);
			ret = true;
		}
	}
	return ret;
}

bool Lemming::SetToBuilder()
{
	bool ret=false;
	if(!(state & NoCanDo) && !(state & NOW_CLIMBING) )
	{
		if(!(state & BUILDER))
		{
			SetState(BUILDER);
			ret = true;
		}
	}
	return ret;
}

bool Lemming::GetAliveState()
{
	return (state != DEAD);
}

int Lemming::GetState()
{
	return state;	
}

void Lemming::SetState(int newState)
{
	pingponganim=false;
	animInc=1;
	if(newState == DEAD)
	{
		state = DEAD;
	}
	else if(newState & WALKING)
	{
		if(!(state & WALKING))
		{
			ClearLemming();
			state |= WALKING;
			frame = fallDistance = 0;
			if(!(state & NUKE)) nukeCount = -2;
			frameMax = 7;
		}
	}
	else if(newState & DIGGER)
	{
		if(!(state & DIGGER))
		{
			ClearLemming();
			state |= DIGGER;
			frame = 0;
			frameMax = 15;
		}
	}
	else if(newState & BUILDER)
	{
		if(!(state & BUILDER))
		{
			ClearLemming();
			state |= BUILDER;
			frameMax = 15;
			frame = blockBuiltCount = 0;
		}
	}
	else if(newState & BLOCKER)
	{
		if(!(state & BLOCKER))
		{
			ClearLemming();
			state |= BLOCKER;
			frameMax = 15;
			frame = 0;
		}
	}
	else if(newState == DEAD)
	{
		frameMax = frame = 0;
		state = DEAD;
		nukeCount = -2;
	}
	else if(newState & BASHER)
	{
		if( !(state & BASHER) )
		{
			ClearLemming();
			state |= BASHER;
			frame = 0;
			frameMax = 31;
		}
	}
	else if(newState & MINER)
	{
		if(!(state & MINER))
		{
			ClearLemming();
			state |= MINER;
			frame = 0;
			frameMax = 23;
		}
	}
	else if(newState == SPLATTED)
	{
		if(!(state & SPLATTED))
		{
			ClearLemming();
			state |= SPLATTED;
			frame = 0;
			frameMax = 16;
		}
	}
	else if(newState & FALLING)
	{
		if(!(state & FALLING))
		{
			ClearLemming();
			state |= FALLING;
			fallDistance = frame = 0;
			frameMax = 3;
		}
	} 
	else if(newState & GOING_HOME)
	{
		if(!(state & GOING_HOME))
		{
			ClearLemming();
			state |= GOING_HOME;
			frame = 0;
			frameMax = 7;
		}
	}
	else if(newState & DROWNER)
	{
		if(!(state & DROWNER))
		{
			ClearLemming();
			state |= DROWNER;
			frame = 0;
			frameMax = 16;
		}
	}
	else if(newState & BURNER)
		{
			if(!(state & BURNER))
			{
				ClearLemming();
				state |= BURNER;
				frame = 0;
				frameMax = 16;
			}
		}
	else if(newState & NUKE)
	{
		if(!(state & NUKE))
		{
			state |= NUKE;
			nukeCount = Lemming::fps*5;	
		}	
	}
	else if(newState & DONE_BUILDING)
	{
		if(!(state & DONE_BUILDING))
		{
			ClearLemming();
			state |= DONE_BUILDING;
			frame = 0;
			frameMax = 7;
		}	
	}
	else if(newState & FLOATER)
	{
		state |= FLOATER;
	}
	else if(newState & CLIMBER)
	{
		state |= CLIMBER;
	}
}

int Lemming::GetRawNukeCount(){
	return nukeCount;
}

short Lemming::CountingDown()
{
	if(nukeCount != -2)
		return nukeCount/fps;
	else 
		return nukeCount;
}

short Lemming::GetFrame()
{
	return frame;
}

int Lemming::GetWidth()
{
	return 	spriteW;
}

int Lemming::GetHeight()
{
	return 	spriteH;
}

void Lemming::AnimateFrame()
{
	frame += animInc;

	if(pingponganim)
	{
		if(frame > frameMax || frame < 0)
		{
			animInc = -animInc;
			if(frame > frameMax)
				frame = frameMax;
			else
				frame = 0;
		}
	}
	else
	{
		if(frame > frameMax)
			frame = 0;
	}
}

bool Lemming::GetBuilderRunOut()
{
	return ((state & BUILDER) && frame == 9 && blockBuiltCount > MAX_BLOCK_BUILT-3 );
}

/*
 * Determines what state the lemming is in and then moves
 * on in the appropriate way.
 */
void Lemming::Move(SDL_Surface* background)
{
	//check nuke first and tick his counter on
	if(state & NUKE)
	{
		if(nukeCount > 0)
		{
			nukeCount--;
		}
		else if(nukeCount == 0)
		{
			state = NUKE;//just set him to nuke now
			frame = 0;
			frameMax = 16;
			nukeCount = -1;
		}
		else if(nukeCount == -1)
		{
			Nuke(background);
		}
	}

	if(state & EXPLODING)
	{
		Exploding();
	}
	else if(state & WALKING)
	{
		WalkerMove(background);
	}
	else if(state & DIGGER)
	{
		DigDown(background);
	}
	else if(state & BUILDER)
	{
		Build(background);
	}
	else if(state & BLOCKER)
	{
		if(!CheckFloor(0, zoom,background))
		{
			state ^= BLOCKER;
			SetState(WALKING);
		}
	}
	else if(state & FALLING)
	{
		Falling(background);
	}
	else if(state & BASHER)
	{
		Bash(background);
	}
	else if(state & SPLATTED)
	{
		Splatter();
	}
	else if(state & DONE_BUILDING)
	{
		if(frame == 7)
		{
			SetToWalker();
		}
	}
	else if(state & NOW_CLIMBING)
	{
		Climb(background);
	}
	else if(state & STOPPED_CLIMBING)
	{
		if(frame == 7)
		{
			state ^= STOPPED_CLIMBING;
			SetState(WALKING);
			position->SetY(position->GetY() - (3*zoom));
			if(state & GOING_LEFT)
				position->SetX(position->GetX() - (2*zoom));
			else
				position->SetX(position->GetX() + (2*zoom));
		}
	}
	else if(state & GOING_HOME)
	{
		if(frame >= 7)
		{
			//SetDead();
			state = ARRIVED_HOME;
		}
	}
	else if(state & DROWNER)
	{
		if(frame >= 16)
		{
			SetDead();
		}
	}
	else if(state & BURNER)
		{
			if(frame >= 16)
			{
				SetDead();
			}
		}
	else if(state & MINER)
	{
		Mining(background);
	}
}

void Lemming::Splatter()
{
	if(frame == 15) state = DEAD;
}

/*
*
*/
void Lemming::Mining(SDL_Surface* background)
{
	if(frame == 0)
	{
		position->SetY(position->GetY() + zoom);
	}
	else if(frame == 4)
	{
		position->SetX(position->GetX() + ((state & GOING_RIGHT) ? zoom : -zoom));
	}
	else if(frame == 15)
	{
		position->SetX(position->GetX() + ((state & GOING_RIGHT) ? 2*zoom : -2*zoom));

		if( !CheckFloor(2*zoom, 2*zoom, background))
		{
			position->SetY(position->GetY()+zoom);
			state ^= MINER;
			SetState(WALKING);
		}
	}
	else if(frame == 2)
		position->SetX(position->GetX() + ((state & GOING_RIGHT) ? -zoom : zoom));
}

/*
 * This function is bloody horrible...very bad
 */
void Lemming::Bash(SDL_Surface* background)
{
	int cpX, cpY;

	//god awful hack
	if(frame == 11 ||frame == 12 || frame == 13 || frame == 14
		|| frame == 27 ||frame == 28 ||frame == 29 || frame == 30 )
	{
		int newX = position->GetX() + ((state & GOING_RIGHT) ? zoom : -zoom);
		position->SetX(newX);
	//}

	//if(frame == 0){
		cpY = position->GetY() + spriteH/2;
		bool found = false;
		//now check along a line coming from the Lemmings middle point (yunno, like that bit in Donnie Darko?)
		for(int n = 0; n < 8*zoom; n += zoom)
		{
			cpX = position->GetX() + ((state & GOING_RIGHT) ? n : -n);

			int newX = position->GetX() + ((state & GOING_RIGHT) ? zoom : -zoom);
			int newY = position->GetY() + spriteH + zoom;

			if(TestPixel(background, cpX, cpY) && TestPixel(background, newX, newY))
			{
				found = true;
				break;
			}
		}

		if(!found)
		{
			state ^= BASHER;
			SetState(WALKING);
		}
	}
}

bool Lemming::FallingFarEnoughToOpenBrolly()
{
	return (fallDistance > (MAX_FALL_BEFORE_BROLLY+1));
}

void Lemming::Falling(SDL_Surface* background)
{
	if((state & FLOATER))
	{
		if( fallDistance >= (MAX_FALL_BEFORE_BROLLY+1))
		{
			//first open the brolly
			if( !(state & OPENING_BROLLY) )
			{
				if(fallDistance == (MAX_FALL_BEFORE_BROLLY+1))
				{
					state |= OPENING_BROLLY;
					frame = 0;
					frameMax = 3;
					pingponganim = false;
				}
			}
			else
			{
				if(frame == frameMax)
				{
					position->SetY(position->GetY() - zoom);
					state ^= OPENING_BROLLY;
					frame = 0;
					frameMax = 7;
					pingponganim = true;
					animInc = 1;
				}
			}
		
			position->SetY(position->GetY() + zoom);
			fallDistance++;

			if(TestPixel(background, position->GetX() + (2*zoom), position->GetY() + spriteH) != 0)
			{
				state ^= FALLING;
				SetState(WALKING);
			}
		}
		else
		{
			for(int n = 1; n < 4; n++)
			{
				position->SetY(position->GetY() + zoom);
				fallDistance++;
				if(CheckFloor(0, 0, background))
				{
					position->SetY(position->GetY() - zoom);
					state ^= FALLING;
					SetState(WALKING);
					break;
				}
			}
		}
	}
	else
	{
		for(int n = 1; n < 4; n++)
		{
			position->SetY(position->GetY() + zoom);
			fallDistance++;

			if(CheckFloor(0, 0, background))
			{
				if(fallDistance > (MAX_FALL))
				{
					SetState(SPLATTED);
				}
				else
				{
					position->SetY(position->GetY() - zoom);
					state ^= FALLING;
					SetState(WALKING);
				}
				break;
			}
		}
	}
}

/*
 * This return a number indicating if the lemming has mined a portion 
 * of the screen
 */
int Lemming::Mined()
{
	//ensure he's a miner
	if(state & MINER)
	{
		//yep, he sure is!
		//what frame is he on
		if(frame == 0 || frame == 1 ||frame == 2 ||frame == 3)
		{
			return 1;
		}	
	}
	
	return 0;
}

/*
 * Candidate for complete implementation in a separate Graphics API
 * independent LemmingDrawer interface...
 * Also needs scaling up for a smoother, more cinematic type effect.
 */
int Lemming::DrawExplosion(SDL_Surface* screen, SDL_Rect* offset)
{
	SDL_Rect rect;
	rect.w = rect.h = zoom;
	Point* p;
	for(int n = 0; n < EXPLOSION_POINTS; n++)
	{
		p = &points[n];
		if(p->life)
		{
			rect.x = ((p->pos.GetX())/explodeScale) - offset->x;
			rect.y = ((p->pos.GetY())/explodeScale) - offset->y;
			if(rect.x >= 0 && rect.x <= offset->w && rect.y >= 0 && rect.y <= offset->h)
				SDL_FillRect( screen, &rect, p->color );
			else p->life=0;//out of screen, so kill point
		}
	}
	return explosionFrames;
}

bool Lemming::ShallIDrawExplosion()
{
	return explosionFrames == 1;
}

/*
 * Candidate for complete implementation in a separate Graphics API
 * independent LemmingDrawer interface...
 * Also needs scaling up for a smoother, more cinematic type effect.
 */
void Lemming::Exploding()
{
	SDL_Rect rect;
	rect.w = 1; rect.h = 1;
	Point* p;

	for(int n = 0; n < EXPLOSION_POINTS; n++)
	{
		p = &points[n];
		p->pos.Add(&p->vel);
		p->vel.Add(Lemming::gravity);
	}

	if(++explosionFrames > 300)
	{
		frame = explosionFrames = 0;
		SetState(DEAD);
	}
}

void Lemming::Nuke(SDL_Surface* background)
{
	int vel=350;
	if(frame == 16)
	{
		srand(6031769);//all explosions were the same on the Amiga, lets do the same here!
		//now create the array of Points, randomly around the lemming
		//TODO: Ideally this would be the actually pixels of the lemming
		Point* p;
		for(int n = 0; n < EXPLOSION_POINTS; n++)
		{
			p = &points[n];
			p->pos.SetX( (position->GetX() + (rand() % 5) - 2)*explodeScale );
			p->pos.SetY( (position->GetY() + (rand() % 8)+8)*explodeScale );
			
			p->vel.SetX(0); p->vel.SetY(0);
			while(!p->vel.GetX()) p->vel.SetX( ((rand() % vel)-vel/2)*zoom );
			while(!p->vel.GetY()) p->vel.SetY( -( (rand() % vel*2))*zoom );
			p->life = 1500 + (rand() % 10);
			p->color = SDL_MapRGB(background->format,rand()%256,rand()%256,rand()%256);
		}
		
		state = EXPLODING;
		explosionFrames = 0;
		frame = 17; //make sure no
		nukeCount=-3;
	}
}


void Lemming::Build(SDL_Surface* background)
{
	if(frame == 0){
		/*int xx,yy;
		if(state & GOING_LEFT)
		{
			xx = position->GetX() - 1*zoom;
		}
		else
		{
			xx = position->GetX() + 1*zoom;
		}

		//up a pixel
		yy = position->GetY() - zoom;

		if(!TestPixel(background, xx, yy))
		{
			blockBuiltCount = 0;
			state ^= BUILDER;
			SetState(WALKING);
			ChangeDirection();
		}*/
	}
	else if(frame == 15)
	{
		int xx,yy;
		if(state & GOING_LEFT)
		{
			xx = position->GetX() - 4*zoom;
		}
		else
		{
			xx = position->GetX() + 4*zoom;
		}

		//up a pixel
		yy = position->GetY() - zoom*2;

		if(TestPixel(background, xx, yy))
		{
			blockBuiltCount = 0;
			state ^= BUILDER;
			SetState(WALKING);
			ChangeDirection();
		}
		else{
			if(state & GOING_LEFT)
			{
				position->SetX(position->GetX() - 2*zoom);
			}
			else
			{
				position->SetX(position->GetX() + 2*zoom);
			}

			//up a pixel
			position->SetY(position->GetY() - zoom);

			if(blockBuiltCount == MAX_BLOCK_BUILT)
			{
				blockBuiltCount = 0;
				SetState(DONE_BUILDING);
			}
			else if(CheckHeadHit(background,  BUILDER))
			{
				blockBuiltCount = 0;
			}
			else if(CheckNoBlockAhead(background))
			{
				blockBuiltCount = 0;
				state ^= BUILDER;
				SetState(WALKING);
				ChangeDirection();
			}
		}
		//bit of a hack - frame isn't being reset at the right time?
		//This will probably fook up the network game...
		frame = 0;
	}
	else
	{
		if(frame == 9)
		{
			/*SDL_Rect block;
			block.w = spriteW;
			block.h = zoom;
	
			block.y = position->GetY() + spriteH;

			if(state & GOING_LEFT)
				block.x = position->GetX() - (5*zoom);
			else
				block.x = position->GetX() + (1*zoom);

			//draw the actual block
			SDL_FillRect( background, &block, SDL_MapRGB( background->format, 0xFF, 0xFF, 0xFF ) );
*/
			blockBuiltCount++;
		}
	}
}

bool Lemming::ShallIBuildBlock(){
	return frame == 9;
}

/*
 * Dig straight down
 */
void Lemming::DigDown(SDL_Surface* background)
{
	SDL_Rect block;
	block.w = 9;
	block.h = 4;
	block.x = position->GetX() - (4*zoom);
	block.y = position->GetY() + (8*zoom);

	if(CheckFloor(0, zoom, background) || CheckFloor(-(4*zoom), zoom, background) || CheckFloor((4*zoom), zoom, background) || CheckFloor((8*zoom), zoom, background))
	{
		//if(actionCount == 8 || actionCount == 16)
		if(GetFrame() == 0 || GetFrame() == 8 || GetFrame()==15)
		{
			position->SetY(position->GetY() + zoom);
		}
	}
	else
	{
		//take a chop anyway (as we don't know what frame it was on..
		position->SetY(position->GetY() + zoom);

		//change back to walker
		state ^= DIGGER;
		SetToWalker();
	}
}

void Lemming::Climb(SDL_Surface* background)
{
	Uint32 p;
	int cpX, cpY;
	
	//move up
	position->SetY(position->GetY() - zoom);
		
	if(state & GOING_RIGHT)
	{
		cpX = position->GetX() + zoom;
	}
	else
	{
		cpX = position->GetX() - zoom;
	}
		
	cpY = position->GetY() + (2*zoom);

	p = TestPixel(background, cpX, cpY);
	
	//there's something there
	if(!p)
	{
		position->SetY(position->GetY() - (4*zoom));
		position->SetX( position->GetX() + ((state&GOING_RIGHT)?-zoom:0) );
		//stop being a climber
		state ^= NOW_CLIMBING;
		state |= STOPPED_CLIMBING;
		frame=0;
	}
	else CheckHeadHit(background, NOW_CLIMBING);
}

bool Lemming::CheckHeadHit(SDL_Surface* background, int type)
{
	bool hit = false;
	//now check right above his head
	int cpX = position->GetX();
	int	cpY = position->GetY();
	if(TestPixel(background, cpX, cpY))
	{
		state ^= type;
		SetState(WALKING);
		ChangeDirection();
		hit = true;
	}
	return hit;
}

/*
 *  Pass background and offset. Offset is the amount past the sprite to test
 *  ONLY USED IN BUILDER FUNCTION
 */
bool Lemming::CheckNoBlockAhead(SDL_Surface* background)
{
	Uint32 p;
	bool itsFree = false;
	
	//gonn clean this up someday
	if( CheckFloor(((state & GOING_RIGHT) ? zoom : -zoom), 0, background) ) //check one pixel ahead
	{
		//there's something there, check how much we need to step up
		
		int stepHeight = 0;
		bool bStopChecking = false;
		//now see how high the step is:
		for(int n=1; n < MAX_STEP_UP*zoom; n+=zoom)
		{
			//now check 1 pixel ahead and n pixels
			p = CheckFloor(((state & GOING_RIGHT) ? zoom : -zoom), -n, background);
			
			if(!p && !bStopChecking)
			{
				bStopChecking = true;
				stepHeight = n;
				break;
			}
		}
		
		if(stepHeight == 0 || stepHeight == (MAX_STEP_UP*zoom)-1)
		{
			if(state & CLIMBER && !(state & BUILDER))
			{
				state ^= WALKING; 
				state |= NOW_CLIMBING;
				frame=0;
			}
			else
				ChangeDirection();
		}
		else 
		{
			if(state & NOW_CLIMBING && !(state & BUILDER))
			{
				//stop climbing
				state ^= NOW_CLIMBING;
				state |= STOPPED_CLIMBING;
				frame=0;
			}
			else
			{
				position->SetY(position->GetY() - stepHeight);
			}
		}
		
		itsFree = true;
	}
	
	return itsFree;
}

/*
 * This checks if there is floor directly below the lemming
 * Returns true if there is and false otherwise
 */
bool Lemming::CheckFloor(int xo, int yOffset, SDL_Surface* background)
{
	//Get the position of the pixel we're checking
	int cpY = position->GetY() + spriteH + yOffset;
	return (TestPixel(background, position->GetX() + xo, cpY) != 0);
}


/*
 * Continue walking in whatever direction the lemming is going
 * unless he falls off a cliff or hit a wall.
 */
void Lemming::WalkerMove(SDL_Surface* background)
{
	bool doneStepping;
    
    //get the next new X point:
	int newX = position->GetX() + ((state & GOING_RIGHT) ? zoom : -zoom);
	int newY = position->GetY() + spriteH;

	//next, check of that point is floor
	if(TestPixel(background, newX, newY))//there is a pixel in the new spot
	{
		//so, next we know we need to step up 1 pixel
		newY -= zoom;
		position->SetY(position->GetY() - zoom);
		//but is there a pixel above that pixel - this would mean a step up
		doneStepping=false;
		for(int stepUp = STEP_AMOUNT; !doneStepping && stepUp < 6*zoom; stepUp+=zoom)
		{
			if(!TestPixel(background, newX, newY-stepUp))
			{
		      position->SetX(newX);
	          position->SetY(position->GetY()-(stepUp-zoom));
			  doneStepping = true;
			}
		}

		if(!doneStepping)
		{
		  //no stepping at all, so first move back down
		  if(state & CLIMBER)
		  {
			  position->SetY(position->GetY()+zoom);
			  state ^= WALKING;
			  state = state | NOW_CLIMBING;
			  frame=0;
		  }
		  else
		  {
			  position->SetY(position->GetY()+zoom);
			  ChangeDirection();
		  }
		}
		else
		{

		}
	}
	else//there is no pixel there, we must go down now whatever happens
	{
		//position->SetY(position->GetY()-1); WHY DONT WE NEED THIS?
		//but how far
		int stepDown=0;
		doneStepping = false;
		for(stepDown = zoom; !doneStepping && stepDown < 6*zoom; stepDown+=zoom)
		{
			if(TestPixel(background, newX, newY+stepDown))
			{
			  //we have a pixel to land on, stick lemmy there
			  position->SetX(newX);
			  position->SetY(position->GetY()+(stepDown-zoom));
			  doneStepping = true;
			}
		}

		if(!doneStepping)
	    {
		  if(stepDown == 6*zoom)//should we go to falling mode?
		  {
		  	SetState(FALLING);
		  	position->SetX(newX);
		  }
	    }
	}
}

bool Lemming::IsPointWithin(int x,int y)
{
	return (x >= position->GetX() - (8*zoom) && x <= position->GetX() + (10*zoom) &&
		    y >= position->GetY() - (4*zoom) && y <= position->GetY() + GetHeight() + (8*zoom));
}

int Lemming::getRadius()
{
	return spriteW/2;	
}

int Lemming::GetX()
{
	return position->GetX();
}

int Lemming::GetY()
{
	return position->GetY();
}

void Lemming::SetX(int x)
{
	position->SetX(x);	
}

void Lemming::SetY(int y)
{
	position->SetY(y);	
}

int Lemming::GetPlayerNum(){
	return playerNum;
}

void Lemming::SetPlayerNum(int value){
	playerNum = value;
}

bool Lemming::TestPixel(SDL_Surface* background, int x, int y){
	//return util->getpixel(background, x,y) != SDL_MapRGB(background->format,0x00,0x00,0x33);
	return util->getpixel(background, x,y);
}

short Lemming::GetAnimInc(){
	return animInc;
}

short Lemming::GetFrameMax(){
	return frameMax;
}

short Lemming::GetBlockBuiltCount(){
	return blockBuiltCount;
}

short Lemming::GetFallDistance(){
	return fallDistance;
}

short Lemming::GetExplosionFrame(){
	return explosionFrames;
}

int Lemming::GetInThisLemmingIndex(){
	return inThisLemming_index;
}

bool Lemming::GetPingPongAnimState(){
	return pingponganim;
}

/*
 * Make this Lemmign equal to the one passed in
 */
void Lemming::MakeEqualTo(Lemming* lemming){
	//Member variables

	//points[EXPLOSION_POINTS];//explosion
	SetX(lemming->GetX());
	SetY(lemming->GetY());
	pingponganim = lemming->GetPingPongAnimState();
	playerNum = lemming->GetPlayerNum();
	animInc = lemming->GetAnimInc();
	//spriteW = lemming->GetWidth();
	//spriteH = lemming->GetHeight();
	frame = lemming->GetFrame();
	state = lemming->GetState();
	frameMax = lemming->GetFrameMax();
	blockBuiltCount = lemming->GetBlockBuiltCount();
	nukeCount = lemming->GetRawNukeCount();
	fallDistance = lemming->GetFallDistance();
	explosionFrames = lemming->GetExplosionFrame();
	inThisLemming_index = lemming->GetInThisLemmingIndex();
}
