#ifndef SPRITE_H_
#define SPRITE_H_

#ifdef WIN32
 #include "SDL/SDL.h"
#else 
 #include "SDL/SDL.h"
#endif

#define DEAD 0x00
#define GOING_LEFT 0x01
#define GOING_RIGHT 0x02
#define WALKING 0x04
#define FALLING 0x08
#define BUILDER 0x10
#define DIGGER 0x20
#define CLIMBER 0x40
#define FLOATER 0x80
#define NUKE 0x100
#define BLOCKER 0x200
#define SPLATTED 0x400
#define GOING_HOME 0x800
#define DONE_BUILDING 0x1000
#define BASHER 0x2000
#define MINER 0x4000
#define EXPLODING 0x8000
#define OPENING_BROLLY 0x10000
#define NOW_CLIMBING 0x20000
#define STOPPED_CLIMBING 0x40000
#define DROWNER 0x80000
#define BURNER 0x100000
#define ARRIVED_HOME 0x200000

#define STEP_AMOUNT 2
#define MAX_STEP_UP 8
#define MAX_FALL 60
#define MAX_FALL_BEFORE_BROLLY 32

#define MAX_EXPLOSION_FRAMES 50
#define EXPLOSION_POINTS 25

#define MAX_BLOCK_BUILT 12

#include "Vector2D.h"
#include "GraphicsUtility.h"

class Lemming
{
public:
	//Functions
	Lemming(int, int, int, int, int);
	~Lemming();
	void CheckForBlocker(Lemming* sprite, int index);
	void AnimateFrame();
	void Move(SDL_Surface*);
	short GetFrame();
	short GetFrameMax();
	short GetAnimInc();
	short GetBlockBuiltCount();
	short GetFallDistance();
	short GetExplosionFrame();
	int GetInThisLemmingIndex();
	bool GetPingPongAnimState();
	int GetX();
	int GetY();
	void SetX(int);
	void SetY(int);
	int GetWidth();
	int GetHeight();
	int GetState();
	int GetRawNukeCount();
	int GetPlayerNum();
	void SetPlayerNum(int);
	bool GetAliveState();
	bool IsPointWithin(int x,int y);
	void SetAlive(short,short);
	void SetDead();
	void SetState(int);
	void SetToWalker();
	bool SetToDigger();
	bool SetToBuilder();
	bool SetToBlocker();
	bool SetToNuke();
	bool SetToMiner();
	bool SetToBasher();
	bool SetToFloater();
	bool SetToClimber();
	void SetGoingHome();
	void SetDrowning();
	void SetBurning();
	bool GetBuilderRunOut();
	void Build(SDL_Surface*);
	void Bash(SDL_Surface*);
	void Exploding();
	bool ShallIDrawExplosion();
	bool ShallIBuildBlock();
	int DrawExplosion(SDL_Surface*, SDL_Rect*);
	int Mined();
	short CountingDown();
	bool FallingFarEnoughToOpenBrolly();
	void ChangeDirection();
	void MakeEqualTo(Lemming* lemming);

	static short fps;
	static int zoom;

protected:

private:
	//static members
	static Vector2D* gravity; //gravity is the same for all lemmings!
	static int NoCanDo;
	static GraphicsUtility* util;

	//This structure is used for explosions
	struct Point
	{
		Vector2D pos;
		Vector2D vel;
		short life;
		Uint32 color;
	};

	//Member variables
	Vector2D* position;
	bool pingponganim;
	int playerNum;
	int animInc;
	int spriteW, spriteH, frame;
	int state;
	short frameMax;
	short blockBuiltCount;
	short nukeCount;
	short fallDistance;
	short explosionFrames;
	int inThisLemming_index;
	
	Point points[EXPLOSION_POINTS];//explosion

	//Functions
	int getRadius();

	void WalkerMove(SDL_Surface*);
	void DigDown(SDL_Surface*);
	void Nuke(SDL_Surface*);
	void Falling(SDL_Surface*);
	void Climb(SDL_Surface*);
	void Splatter();
	void Mining(SDL_Surface* background);
	bool CheckFloor(int xo, int yOffset, SDL_Surface* background);
	bool CheckNoBlockAhead(SDL_Surface*);
	bool CheckHeadHit(SDL_Surface* background, int type);
	void ClearLemming();
	bool TestPixel(SDL_Surface* background, int x, int y);
};
#endif
