/*
 * Level.h
 *
 *  Created on: 24 Jan 2010
 *      Author: mat
 */

#ifndef LEVEL_H_
#define LEVEL_H_
#include <string>
#include "LevelLoader.h"
#include "lemmings_graphical_object.h"
#include "lemmings_level.h"
#include "GraphicsUtility.h"

#define MAIN_MEMORY_CHUNK_SIZE (4*1024*1024)
#define DSX_COLOUR_BLUE_PART  (31 << 10)
#define DSX_COLOUR_GREEN_PART (31 <<  5)
#define DSX_COLOUR_RED_PART   (31 <<  0)

class Level {
public:
	enum ToolType{
		CLIMBER_TOOL = 0,
		FLOATER_TOOL,
		NUKE_TOOL,
		BLOCKER_TOOL,
		BUILDER_TOOL,
		BASHER_TOOL,
		MINER_TOOL,
		DIGGER_TOOL
	};
	Level(int ScreenWidth, int ScreenHeight);
	virtual ~Level();
	void  LoadLevel(std::string* filename);
	void  DrawExitsEntrancesWater(SDL_Surface*, SDL_Surface* b);
	void  DrawDebugStuff(SDL_Surface*b);

	void  RedrawMetalAreas();
	void  SetViewPort(SDL_Rect* rect);
	void  SetReleaseRate(int rate);
	void  UseTool(ToolType);
	void ReturnTool(ToolType type);
	bool  ToolAvailable(ToolType);
	bool  IsPointMetalArea(int, int);
	bool IsPointExpandedMetalArea(int x, int y);
	bool  IsPointOneWayArea(int, int, uint32);//1 for right, 0 for left
	bool  IsPointInTrap(int, int);
	bool  IsPointInHazard(int, int);
	bool  IsPointInWater(int, int);
	int   IsPointInHome(int, int);
	int   GetEntranceX(int);
	int   GetEntranceY(int);
	int   GetBackgroundWidth();
	int   GetReleaseRate();
	int   GetTimeInMinutes();
	uint32   GetLemmingsToBeSaved();
	uint32   GetNumLemmings();
	int   GetCamStartX();
	char* GetLevelName();
	char* GetRatingDescription();
	void  RenderAllOneWayIndicators(SDL_Surface* screen);

	SDL_Surface* GetLevelPreview();
	SDL_Surface* GetBackground();
	std::vector<int>* Tools();
	void Animate();
	void AnimateEntrance();
	bool debug;
	int zoom;

	bool IsBlueHome(int index);
	Uint32 blue_home;
	Uint32 green_home;
private:
	struct AnimFrame{
		int frame;
		int inc;
		int max;
	};
	std::vector<AnimFrame*> unintFrames;

	int MAX_WATER_FRAME;
	int MAX_UNINTERACTIVE_FRAME;
	int MAX_HAZARD_FRAME;
	long file_size(const char* fileName);

	void RenderLevelOneWayAreaIndicator(SDL_Surface* screen, int x1, int y1,int x2, int y2, int d, int c);
	void LoadGraphicalObjects();

	void CreateThumbnail();

	int GetDistanceBetweenPoints(int x1,int y1, int x2, int y2);
	void CalculateTwoPLayerHomes();


	void DrawWater(SDL_Surface* screen, uint32 zorder);
	void DrawExits(SDL_Surface* screen);
	void DrawEntrances(SDL_Surface* screen);
	void DrawTraps(SDL_Surface* screen);
	void DrawHazards(SDL_Surface* screen);
	void DrawUninteractives(SDL_Surface* screen);

	void RenderBackgroundAndThumbnail();
	void RenderBackgroundDataToSurface(SDL_Surface* screen);

	void DSX_DrawWaterArea(SDL_Surface*, LEMMINGS_GRAPHICAL_OBJECT_HEADER*, DSX_SPRITE*, int, int, int, int);
	void DSX_DrawSpriteStrip(SDL_Surface*, DSX_SPRITE*, int, int, int, const u16*);
	void DSX_DrawSpriteFrame(SDL_Surface*, LEMMINGS_GRAPHICAL_OBJECT_HEADER*, DSX_SPRITE*, int, bool, int, int, u16 *palette_to_use);
	void DSX_GreedyGatherObjectCategory(std::vector<LEMMINGS_GRAPHICAL_OBJECT_HEADER *>*, std::vector<DSX_SPRITE *>*, int*, const char*, const char*, u16* );

	int screenWidth, screenHeight;
	int waterFrame;
	int oneWayIndicaterFrame;
	int uninteractiveFrame;
	int hazardFrame;
	int trapFrame;
	int dooranimframe;
	SDL_Rect* viewport;
	GraphicsUtility *utility;
	SDL_Surface* background;
	SDL_Surface* levelPreview;
	std::vector<int> tools;

	LEMMINGS_LEVEL_LDS_FILE_V7 *levelStruct;
	std::vector<int> trapAnimPoints;
	int no_standard_waters;
	int no_custom_waters;
	int no_standard_hazards;
	int no_custom_hazards;
	int no_standard_traps;
	int no_custom_traps;
	int no_standard_exits;
	int no_custom_exits;
	int no_standard_entrances;
	int no_custom_entrances;
	int no_standard_uninteractives;
	int no_custom_uninteractives;

	// The raw data for the level.
	u8 level_data[LEVEL_X_SIZE][LEVEL_Y_SIZE];

	std::vector<LEMMINGS_GRAPHICAL_OBJECT_HEADER *> standard_exit_graphical_objects;
	std::vector<LEMMINGS_GRAPHICAL_OBJECT_HEADER *> custom_exit_graphical_objects;

	std::vector<LEMMINGS_GRAPHICAL_OBJECT_HEADER *> standard_entrance_graphical_objects;
	std::vector<LEMMINGS_GRAPHICAL_OBJECT_HEADER *> custom_entrance_graphical_objects;

	std::vector<LEMMINGS_GRAPHICAL_OBJECT_HEADER *> standard_hazard_graphical_objects;
	std::vector<LEMMINGS_GRAPHICAL_OBJECT_HEADER *> custom_hazard_graphical_objects;

	std::vector<LEMMINGS_GRAPHICAL_OBJECT_HEADER *> standard_trap_graphical_objects;
	std::vector<LEMMINGS_GRAPHICAL_OBJECT_HEADER *> custom_trap_graphical_objects;

	std::vector<LEMMINGS_GRAPHICAL_OBJECT_HEADER *> standard_water_graphical_objects;
	std::vector<LEMMINGS_GRAPHICAL_OBJECT_HEADER *> custom_water_graphical_objects;

	std::vector<LEMMINGS_GRAPHICAL_OBJECT_HEADER *> standard_uninteractive_graphical_objects;
	std::vector<LEMMINGS_GRAPHICAL_OBJECT_HEADER *> custom_uninteractive_graphical_objects;

	std::vector<DSX_SPRITE *> standard_entrance_graphical_object_sprites;
	std::vector<DSX_SPRITE *> custom_entrance_graphical_object_sprites;

	std::vector<DSX_SPRITE *> standard_hazard_graphical_object_sprites;
	std::vector<DSX_SPRITE *> custom_hazard_graphical_object_sprites;

	std::vector<DSX_SPRITE *> standard_trap_graphical_object_sprites;
	std::vector<DSX_SPRITE *> custom_trap_graphical_object_sprites;

	std::vector<DSX_SPRITE *> standard_water_graphical_object_sprites;
	std::vector<DSX_SPRITE *> custom_water_graphical_object_sprites;

	std::vector<DSX_SPRITE *> standard_uninteractive_graphical_object_sprites;
	std::vector<DSX_SPRITE *> custom_uninteractive_graphical_object_sprites;

	std::vector<DSX_SPRITE *> standard_exit_graphical_object_sprites;
	std::vector<DSX_SPRITE *> custom_exit_graphical_object_sprites;

};

#endif /* LEVEL_H_ */
