/*
 * DesignerScreen.cpp
 *
 *  Created on: 22 Jan 2010
 *      Author: mat
 */

#include "DesignerScreen.h"
#include <dirent.h>
#include <cstdio>
#include <iostream>
#include <algorithm>

DesignerScreen::DesignerScreen(MenuItem* daddy) : MenuItem(daddy){
	drawhand=false;
	tiles = new vector<Tile*>;
	currentTile = NULL;
	images = NULL;
	//LoadTheme("data/windows_lemmings_terrain_images/Brick/");
	LoadTheme("data/windows_lemmings_terrain_images/Soil/");
	currentTile = new Tile(40,40,0);
}

DesignerScreen::~DesignerScreen() {
	if(tiles!=NULL)
		delete(tiles);
	if(images!=NULL)
		delete(images);
}

bool DesignerScreen::LoadTheme(const char *path){
	GetFilenames(path, &files);
	//clear out images
	if(images != NULL){
		for(int n=0; n < (int)images->size(); n++){
			delete(images->at(n));
		}
		delete(images); images = NULL;
	}

	images = new std::vector<SDL_Surface*>;

	for(int n=0; n < (int)files.size(); n++){
		images->push_back(utility->load_image(files.at(n).c_str()));
	}

	return true;
}

void DesignerScreen::flush(std::vector<std::string>* temp){
	delete(temp);
}

void DesignerScreen::DrawSelf(SDL_Surface* screen){
	SDL_FillRect(screen, &screen->clip_rect, SDL_MapRGB(screen->format, 0x00,
				0x00, 0x00));

	//just go through each Tile and draw it, except the current one that
	//moves with the mouse

	for(int n=0;n<(int)tiles->size();n++){
		utility->apply_surface(tiles->at(n)->x,tiles->at(n)->y, images->at(tiles->at(n)->imageIndex), screen, NULL);
	}

	utility->apply_surface(mouse_x,mouse_y, images->at(currentTile->imageIndex), screen, NULL);
}
//MenuItem* DesignerScreen::SendEscape(){}

void DesignerScreen::HandleMouse(int x,int y ,long l ,long r){
	if(leftclick)
	{
		currentTile->x=mouse_x;
		currentTile->y=mouse_y;
		tiles->push_back(currentTile);
		currentTile = new Tile(mouse_x, mouse_y, currentTile->imageIndex);
	}
}

void DesignerScreen::HandleKey(int k ){
	if(k == SDLK_d){

	}
	else if(k == SDLK_a){
		if(currentTile->imageIndex>0)
			currentTile->imageIndex--;
	}
	else if(k == SDLK_q){
		if(currentTile->imageIndex < images->size());
			currentTile->imageIndex++;
	}
}

void DesignerScreen::Init()
{
//	SDL_ShowCursor(true);
}


void DesignerScreen::GetFilenames(const char *path, std::vector<string>* temp)
{
	//std::vector<std::string>* temp = new std::vector<std::string>;
	string str = string(path);
	//first off, we need to create a pointer to a directory
printf("heres okay 1\n");
    DIR *pdir = NULL; // remember, it's good practice to initialise a pointer to NULL!

    pdir = opendir (path); // "." will refer to the current directory
    printf("heres okay 2\n");
    struct dirent *pent = NULL;

    if (pdir == NULL) // if pdir wasn't initialised correctly
    { // print an error message and exit the program
        printf ("\nERROR! pdir could not be initialised correctly %s\n", path);
        return ; // exit the function
    }
    printf("heres okay 2\n");
    int n=0;
    while ((pent = readdir (pdir))) // while there is still something in the directory to list
    {
        if (pent == NULL) // if pent has not been initialised correctly
        { // print an error message, and exit the program
            printf ("\nERROR! pent could not be initialised correctly %s\n", path);
            return ; // exit the function
        }
        str = path;
        str = str + pent->d_name;
        //printf("heres okay 3 %s\n", str.c_str());
        if(n++ >= 0)
        {
        	if(string(pent->d_name).length() > 3)
        	{
        		temp->push_back(string(str));
        		//printf("files: %s", temp->at(n).c_str());

        	}
        }
    }
//	sort (levels.begin(), levels.end());
    // finally, let's close the directory
    closedir (pdir);

   // levelPositions.push_back(levels.size());
   // return temp;
}
