#include "LevelLoader.h"
//#include <vector>
#include <string>
# include <dirent.h>
#include <cstdio>
#include <iostream>
#include <algorithm>

LevelLoader::LevelLoader()
{
	currentLevel=0;
	levelSet=Fun;
	max_songs=30;
	songs.push_back(string("data/music/standard_ingame/cancan.mod"));
	songs.push_back(string("data/music/standard_ingame/lemming1.mod"));
	songs.push_back(string("data/music/standard_ingame/tim2.mod"));
	songs.push_back(string("data/music/standard_ingame/lemming2.mod"));
	songs.push_back(string("data/music/standard_ingame/tim8.mod"));
	songs.push_back(string("data/music/standard_ingame/tim3.mod"));
	songs.push_back(string("data/music/standard_ingame/tim5.mod"));
	songs.push_back(string("data/music/standard_ingame/doggie.mod"));
	songs.push_back(string("data/music/standard_ingame/tim6.mod"));
	songs.push_back(string("data/music/standard_ingame/lemming3.mod"));
	songs.push_back(string("data/music/standard_ingame/tim7.mod"));
	songs.push_back(string("data/music/standard_ingame/tim9.mod"));
	songs.push_back(string("data/music/standard_ingame/tim2.mod"));
	songs.push_back(string("data/music/standard_ingame/tim10.mod"));
	songs.push_back(string("data/music/standard_ingame/tim4.mod"));//level 15]
	songs.push_back(string("data/music/standard_ingame/tenlemmings.mod"));//level 16
	songs.push_back(string("data/music/standard_ingame/mountain.mod"));

	songs.push_back(string("data/music/standard_ingame/cancan.mod"));
	songs.push_back(string("data/music/standard_ingame/lemming1.mod"));
	songs.push_back(string("data/music/standard_ingame/tim2.mod"));
	songs.push_back(string("data/music/standard_ingame/lemming2.mod"));
	songs.push_back(string("data/music/standard_ingame/beasti.mod"));
	//songs.push_back(string("music/standard_ingame/LemEngine_Beast.mp3"));
	songs.push_back(string("data/music/standard_ingame/track_18.mod"));
	songs.push_back(string("data/music/standard_ingame/tim3.mod"));
	songs.push_back(string("data/music/standard_ingame/tim5.mod"));
	songs.push_back(string("data/music/standard_ingame/doggie.mod"));
	songs.push_back(string("data/music/standard_ingame/tim6.mod"));
	songs.push_back(string("data/music/standard_ingame/lemming3.mod"));
	songs.push_back(string("data/music/standard_ingame/tim7.mod"));
	songs.push_back(string("data/music/standard_ingame/tim9.mod"));
	songs.push_back(string("data/music/standard_ingame/tim1.mod"));

	setupDone = false;
}

LevelLoader::~LevelLoader()
{

}

string LevelLoader::GetSong()
{
	if(currentLevel>=0)
	{
		return songs.at(currentLevel % (max_songs-1));
	}
	else
	{
		//this will never happen once I've removed the debug stuff
		//printf("getting song: %d", (max_songs + currentLevel));
		return songs.at(max_songs + currentLevel);
	}
}

string* LevelLoader::GetTwoPlayerLevel(int n)
{
	return &twoPlayerLevels.at(currentLevel);
}

string* LevelLoader::GetLevel()
{
	printf("(LevelLoader) getting level at %d\n", currentLevel);
	int maxlevel = 255;
	int n = currentLevel;

	if(n >= 0 && n < maxlevel )
	{
		n = n;//?!
	}
	else if(n < 0)
	{
		printf("n is %d\n", n);
		n = maxlevel - ((n*-1));
		printf("n is smaller than 0 trying to load: %d\n", n);
	}
	else if(n >= maxlevel )
	{
		n = n % maxlevel ;
		printf("n is smaller than 0 trying to load: %d\n", n);
	}

	return &levels.at(levelPositions.at((int)levelSet)+n);
}

std::string LevelLoader::GetLevelSetName(){
	return levelSetNames.at((int)levelSet);
}

void LevelLoader::Setup()
{
	if(!setupDone){
		count = 0;
		levelPositions.push_back(0);
		LoadSet("data/levels/1player/standard/Lems A - Fun/", "Fun");
		LoadSet("data/levels/1player/standard/Lems B - Tricky/", "Tricky");
		LoadSet("data/levels/1player/standard/Lems C - Taxing/", "Taxing");
		LoadSet("data/levels/1player/standard/Lems D - Mayhem/", "Mayhem");
		LoadSet("data/levels/1player/standard/Oh No A - Tame/", "Tame");
		LoadSet("data/levels/1player/standard/Oh No B - Crazy/", "Crazy");
		LoadSet("data/levels/1player/standard/Oh No D - Wicked/", "Wicked");
		LoadSet("data/levels/1player/standard/Oh No E - Havoc/", "Havoc");
		LoadSet("data/levels/1player/standard/Xmas 1991/", "Xmas 91");
		LoadSet("data/levels/1player/standard/Xmas 1992/", "Xmas 92");
		LoadSet("data/levels/1player/standard/Xmas A - Frost/", "Frost");
		LoadSet("data/levels/1player/standard/Xmas B - Hail/", "Hail");
		LoadSet("data/levels/1player/standard/Xmas C - Flurry/", "Flurry");
		LoadSet("data/levels/1player/standard/Xmas D - Blizzard/", "Blizzard");

		LoadTwoPlayerLevels("data/levels/2player/");
		sort(twoPlayerLevels.begin(), twoPlayerLevels.end());

		//wrong exits
		//level 1 fine
		//SetHack(0, )
		//level 2 swapped (flags okay)
		//level 3 fine
		//level 4 flags okay, entrance wrong
		//level 5 fine
		//level 6 fine
		//level 7 fine
		//level 8 flags swapped, start direction wrong
		//level 9 swapped
		//level 10 swapped, start direction wrong
		//level 11 swapped
		//level 12 swapped
		//level 13 swapped (FLAGS DEFINATLY)
		//level 14 FLAGS AND EXITS NEED SWapping
		//LEVEL 15 fine
		//level 16 okay
		//level 17 okay
		//level 18 entrances swapped. exits swapped
		//level 19 entrances swapped, exits swapped
		//level 20 fine!

		//twoPlayerHack[0].


		SetHack(0,  false, false, false, 1, 0);
		SetHack(1,  false, false, false, 1, 0);
		SetHack(2,  false, false, false, 1, 0);
		SetHack(3,  false, false, false, 1, 0);
		SetHack(4,  false, false, false, 1, 0);
		SetHack(5,  false, false, false, 1, 0);
		SetHack(6,  false, false, false, 1, 0);
		SetHack(7,  false, false, false, 1, 0);
		SetHack(8,  false, false, false, 1, 0);
		SetHack(9,  false, false, false, 1, 0);
		SetHack(10, false, false, false, 1, 0);
		SetHack(12, false, false, false, 1, 0);
		SetHack(13, false, false, false, 1, 0);
		SetHack(14, false, false, false, 1, 0);
		SetHack(14, false, false, false, 1, 0);
		SetHack(15, false, false, false, 1, 0);
		SetHack(16, false, false, false, 1, 0);
		SetHack(17, false, false, false, 1, 0);
		SetHack(18, false, false, false, 1, 0);
		SetHack(19, false, false, false, 1, 0);
		SetHack(20, false, false, false, 1, 0);


		setupDone = true;
	}
}



/*
 *  bool entrances_swapped;
	bool flags_swapped;
	bool exits_swapped;
	int green_heading_right;
	int blue_heading_right;
 */
void LevelLoader::SetHack(int n, bool entrances,bool flags,bool exits, int green_right, int blue_right){
	twoPlayerHack[n].entrances_swapped = entrances;
	twoPlayerHack[n].flags_swapped = flags;
	twoPlayerHack[n].exits_swapped = exits;
	twoPlayerHack[n].blue_heading_right = blue_right;
	twoPlayerHack[n].green_heading_right = green_right;

}

void LevelLoader::LoadSet(const char *path, const char *name)
{
	string str = string(path);
	//first off, we need to create a pointer to a directory
	vector<string> temp;

    DIR *pdir = NULL; // remember, it's good practice to initialise a pointer to NULL!
    pdir = opendir (path); // "." will refer to the current directory

    struct dirent *pent = NULL;

    if (pdir == NULL) // if pdir wasn't initialised correctly
    { // print an error message and exit the program
        printf ("\nERROR! level directory could not be initialised correctly %s\n", path);
        return; // exit the function
    }

    while ((pent = readdir (pdir))) // while there is still something in the directory to list
    {
        if (pent == NULL) // if pent has not been initialised correctly
        { // print an error message, and exit the program
            printf ("\nERROR! pent could not be initialised correctly %s\n", path);
            return; // exit the function
        }
        str = path;
        str = str + pent->d_name;

        if(string(pent->d_name).length() > 3)
		{
        	temp.push_back(string(str));
        	count++;
        }
    }
    closedir (pdir);

    sort(temp.begin(), temp.end());

    for(int i = 0; i < (int)temp.size(); i++)
    	levels.push_back(temp.at(i));

    levelPositions.push_back(levels.size());
    levelSetNames.push_back(string(name));
}


void LevelLoader::LoadTwoPlayerLevels(const char *path)
{
	string str = string(path);
	//first off, we need to create a pointer to a directory

    DIR *pdir = NULL; // remember, it's good practice to initialise a pointer to NULL!

    pdir = opendir (path); // "." will refer to the current directory

    struct dirent *pent = NULL;

    if (pdir == NULL) // if pdir wasn't initialised correctly
    { // print an error message and exit the program
        printf ("\nERROR! pdir could not be initialised correctly");
        return; // exit the function
    }
    int n=0;
    while ((pent = readdir (pdir))) // while there is still something in the directory to list
    {
        if (pent == NULL) // if pent has not been initialised correctly
        { // print an error message, currentLevel--;and exit the program
            printf ("\nERROR! pent could not be initialised correctly");
            return; // exit the function
        }
        str = path;
        str = str + pent->d_name;

        if(n++ >= 0)
        {
        	if(string(pent->d_name).length() > 3)
        	{
        	twoPlayerLevels.push_back(string(str));
        	count++;
        	}
        }
    }
    // sort (levels.begin(), levels.end());
    // finally, let's close the directory
    closedir (pdir);
}

int LevelLoader::LevelCount()
{
	return 30;
}

void LevelLoader::SetLevel(int n){
	//currentLevel = levelPositions.at(levelSet)+n;
	currentLevel=n;
	printf("setting level %d\n", currentLevel);
}

int LevelLoader::SetLevelSet(int newLevel)
{
	if(newLevel>=0)
	{
		levelSet = (LevelSet)newLevel;
		//printf("set levelSet: %d\n",levelSet);
	}
	return 0;
}

void LevelLoader::NextLevel()
{
	currentLevel++;
}

void LevelLoader::IncLevel(int n){
	if(n>0 && currentLevel<256-n)
		currentLevel +=n;
	else if(n<0 && currentLevel>n)
		currentLevel +=n;
}

void LevelLoader::PreviousLevel()
{
	if(currentLevel>0)
		currentLevel--;
}

void LevelLoader::NextTwoPlayerLevel()
{
	currentLevel++;
	if(currentLevel >= (int)twoPlayerLevels.size())
		currentLevel = 0;
}

void LevelLoader::PreviousTwoPlayerLevel()
{
	currentLevel--;
	if(currentLevel < 0)
		currentLevel = twoPlayerLevels.size()-1;
}



