#ifndef LEVELLOADER_
#define LEVELLOADER_

#include "SDL/SDL.h"

#include "GraphicsUtility.h"
#include <vector>
#include <string>
using namespace std;

/*
 *
 */
class LevelLoader
{
public:
    enum LevelSet
    {
    	Fun = 0,
    	Tricky,
    	Taxing,
    	Mayhem,
    	Tame,
    	Crazy,
    	Wild,
    	Wicked,
    	Havoc,
    	Xmas1991,
    	Xmas1992,
    	XmasFrost,
    	XmasHail,
    	XmasFlurry,
    	XmasBlizzard,
    	MaxLevel
    };

    struct TwoPlayerLevelHack{
    	bool entrances_swapped;
    	bool flags_swapped;
    	bool exits_swapped;
    	int green_heading_right;
    	int blue_heading_right;
    };

    TwoPlayerLevelHack twoPlayerHack[30];

    void SetHack(int n, bool entrances,bool flags,bool exits, int green_right, int blue_right);
	string* GetLevel();
	string* GetTwoPlayerLevel(int);
	void Setup();
	LevelLoader();
	~LevelLoader();
	int LevelCount();
	void NextLevel();
	void NextTwoPlayerLevel();
	void PreviousLevel();
	void PreviousTwoPlayerLevel();
	void IncLevel(int);
	void SetLevel(int);
	int SetLevelSet(int);
	string GetSong();
	string GetLevelSetName();
	int currentLevel;
private:
	vector<string> levels;
	vector<string> twoPlayerLevels;
	vector<string> songs;
	vector<string> levelSetNames;
	void LoadSet(const char *path, const char *name);
	void LoadTwoPlayerLevels(const char *path);
	LevelSet levelSet;
	vector<int> levelPositions;
	int max_songs;
	int count;
	bool setupDone;
};
#endif
