#include "MainForm.h"
#include "Timer.h"
#include <iostream>
#include <string.h>

#include "SDL/SDL.h"
#include "SDL/SDL_mixer.h"

#include <sys/time.h>
#include <time.h>
#include <unistd.h>

#ifdef PLATFORM_PANDORA
// See lines 80ff for more info
static SDL_Cursor *hiddenCursor;
#endif

MainForm::MainForm(int new_width, int new_height, bool fullscreen, bool Sound_enabled, int Buffer)
{
	game_type = NULL;
	sound_enabled = Sound_enabled;
	gameMenu = NULL;
	//Init(new_width, new_height, fullscreen, Buffer);
}

MainForm::~MainForm()
{

}

/*
 * This initiliases the form!
 */
bool MainForm::Init(int new_width, int new_height, bool Fullscreen, int Buffer)
{
	SCREEN_BPP = 32;
	width = new_width;
	height =  new_height;
	fullscreen = Fullscreen;
	levelNumber = 0;

	printf("Initilising MainForm now\n");

	//Initialise all SDL subsystems*
	if( SDL_Init( SDL_INIT_VIDEO | SDL_INIT_TIMER ) == -1 )
    {
		printf("SDL failed to initilise :-(\n");
		return false;
    }

	screen = SDL_SetVideoMode( width, height, SCREEN_BPP, SDL_HWSURFACE |
														  (fullscreen ? SDL_FULLSCREEN : 0) |
														  SDL_DOUBLEBUF );

	if(sound_enabled){
		SDL_Init( SDL_INIT_AUDIO );
		printf("enabling sound\n");
		//We're going to be requesting certain things from our audio
		//device, so we set them up beforehand
		int audio_rate = 44100;
		Uint16 audio_format = AUDIO_S16; // 16-bit stereo
		int audio_channels = 2;
		int audio_buffers = 1024;
		// This is where we open up our audio device.  Mix_OpenAudio takes
		// as its parameters the audio format we'd /like/ to have.
		if(Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers))
		{
			printf("Unable to open audio!\n");
			sound_enabled = false;
		}
		else{
			Mix_VolumeMusic(50);
			Mix_Volume(1,50);
		}
	}
	else printf("not initing sound\n");

    #ifdef PLATFORM_PANDORA
    /* On the OpenPandora we need to work around an SDL assumption that
       returns relative mouse coordinates when you get to the screen
       edges using the touchscreen and a custom surface for the cursor.
       The workaround is to set a blank SDL cursor and NOT disable it
       (Hackish I know).

       The root issues lies in the Windows Manager GRAB code in SDL.
       That is why the issue is not seen on framebuffer devices like the
       GP2X (there is no X window manager ;) ).

       Fix by DjWillis
       http://blogs.distant-earth.com/wp/?p=293
    */
    uint8_t hiddenCursorData = 0;
    hiddenCursor = SDL_CreateCursor(&hiddenCursorData, &hiddenCursorData, 8, 1, 0, 0);
    SDL_ShowCursor(SDL_ENABLE);
    SDL_SetCursor(hiddenCursor);
    #else
	SDL_ShowCursor(false);
	#endif

    //If there was an error in setting up the screen
    if( screen == NULL )
    {
    	printf("looks like there was an error setting up the screen.\n");
    	return false;
    }

    //Set the window caption
    SDL_WM_SetCaption( "Lemmings SDL", NULL );
	printf("initilising menu\n");
    gameMenu = new TitleScreenMenu(NULL, new_width, new_height, sound_enabled, Buffer);
    if(gameMenu != NULL)
    	printf("menu has been initilised\n");
    return true;
}


bool MainForm::MainLoop()
{
	int updateFPS = 1000 / 25;
	Timer fps;
	//Uint32 currentFPS = 0;
	exitProgram = pause = false;

	SDL_Rect rect;
	rect.x = rect.y = 0;
	rect.w = width;
	rect.h = height;
	long diff = 0;
	int x, y;
	fps.start();
	printf("I'm really going to start mainloop now\n");
	if(gameMenu == NULL)
		printf("strange, gameMennu is NULL?\n");
	while(!exitProgram)
	{
		handle_sdl_events();
		Uint8 buttons = SDL_GetMouseState(&x, &y);

		if(x > width) SDL_WarpMouse(width, y);
		if(y > height) SDL_WarpMouse(x, height);

		gameMenu = gameMenu->SetMouse(x, y, (buttons & SDL_BUTTON(1)), (buttons & SDL_BUTTON(3)));
		gameMenu->Draw(screen);

		SDL_Flip(screen);
		//if ticks passed is LESS than our intended frame-rate then pause for a few ms
		diff = updateFPS - fps.get_ticks();
		fps.start();
		if( diff > 0 )
		{
			SDL_Delay( diff );
		}

	}
	printf("we're out of the loop now\n");

	delete(gameMenu);

	// This is the cleaning up part
	if(sound_enabled){
		printf("trying to close audio\n");
		Mix_CloseAudio();
	}
	else printf("Not closing audio\n");

    #ifdef PLATFORM_PANDORA
    SDL_FreeCursor(hiddenCursor);
    #endif

	SDL_Quit();
	return true;
}

/*
 * Horribly dull function dealing with keypresses and
 * mouse twitches and other such bullshit.
 */
void MainForm::handle_sdl_events()
{
	upPressed = downPressed = leftPressed = rightPressed = escapePressed = nextLevel = false;
	spacePressed = enterPressed = mPressed = false;

	//While there's events to handle
    while( SDL_PollEvent( &event ) == 1)
    {
       //If the user has Xed out the window
       if( event.type == SDL_QUIT )
       {
         exitProgram = true;
       }

       if( event.type == SDL_KEYDOWN )
       {
            MenuItem *test;
            gameMenu->SetKey(event.key.keysym.sym);
	       	//Set the proper message surface
	       	switch( event.key.keysym.sym )
	       	{
				case SDLK_UP:
	            	upPressed = true;
				break;

				case SDLK_DOWN:
					downPressed = true;
				break;

				case SDLK_LEFT:
					leftPressed = true;
				break;

				case SDLK_RIGHT:
					rightPressed = true;

				break;
	       		case SDLK_1:
	       			onePressed = true;
	       		case SDLK_2:
	       			twoPressed = true;
	       		break;

	       		case SDLK_ESCAPE:
	       			escapePressed = true;
                    test = gameMenu->SendEscape();
                    if (test) {
                        gameMenu = test;
                    } else {
                        exitProgram = true;
                    }
	       		break;

	       		case SDLK_x:
	       			//exitProgram = true;
	       		break;

	       		case SDLK_p:
	       		//	game->Pause();
	       		break;

				case SDLK_m:
					mPressed = true;
				break;

				case SDLK_F11:
	       		case SDLK_f:
	       			fullscreen = !fullscreen;
	       			screen = SDL_SetVideoMode( width, height, SCREEN_BPP, SDL_HWSURFACE | (fullscreen ? SDL_FULLSCREEN : 0) | SDL_DOUBLEBUF );
	       			SDL_WarpMouse(width/4, height/4);
	       		break;

				case SDLK_SPACE:
					spacePressed = true;
					break;

	       		case SDLK_RETURN:
					enterPressed = true;
					break;

				default:

	       		break;
	       	}
       }
    }
}

//Unused
int MainForm::my_thread( )
{
	Timer fps;

	//While the program is not over
	int n = 10000;
	while( --n )
	{
		//Start the frame timer
		fps.start();

	//	game->RequestForData();

		if( fps.get_ticks() < 1000 / 20 )
		{
			//SDL_Delay( ( 1000 / 20 ) - fps.get_ticks() );
		}
	}

	return 0;
}

//unused
void MainForm::runThread()
{
    SDL_CreateThread(&StaticThreadProcMy_thread,this);
}
