#ifndef MAINFORM_H_
#define MAINFORM_H_
#include "SDL/SDL.h"
#include "SDL/SDL_thread.h"
#include <vector>
#include "menuSystem/TitleScreenMenu.h"

using namespace std;

#define FRAMES_PER_SECOND 20

class MainForm
{
public:
	enum Game_Type
	{
		Server,
		Client	
	};
    MainForm(int, int, bool, bool, int);
	~MainForm();

	bool MainLoop();
	bool Init(int, int, bool, int);
private:
	bool sound_enabled;
	bool sendLButton;
	bool upPressed, downPressed, leftPressed, rightPressed, escapePressed;
	bool onePressed, twoPressed;
	bool spacePressed, enterPressed;
	bool mPressed;
	bool pause;
	int levelNumber;
	bool exitProgram;
	bool nextLevel;
	bool fullscreen;
	//Screen attributes
	int SCREEN_BPP;
	int updateFPS;
	const char* game_type;
	//The surfaces
	SDL_Surface *screen;
	//The event structure
	SDL_Event event;
	bool leftButtonDown, rightButtonDown;
	MenuItem* gameMenu;
	int width, height;

	void handle_sdl_events();

	int my_thread( );
	void runThread();
	static int StaticThreadProcMy_thread(void* pParam)
	{
    	return ((MainForm*)pParam)->my_thread();
	}
};

#endif /*MAINFORM_H_*/ 
