#include "SamplePlayer.h"
/*
 * SamplePlayer.cpp
 *
 *  Created on: 21 Oct 2009
 *      Author: math
 */

SamplePlayer::SamplePlayer(bool Sound_enabled)
{
	sound_enabled = Sound_enabled;
	if(sound_enabled)
	{
		samples[DOACTION] = Mix_LoadWAV("data/sfx/MousePre.wav");
		samples[CHANGEOP] = Mix_LoadWAV("data/sfx/ChangeOp.wav");
		samples[BOING] = Mix_LoadWAV("data/sfx/Boing.wav");
		samples[SPLAT] = Mix_LoadWAV("data/sfx/Splat.wav");
		samples[OHNO] = Mix_LoadWAV("data/sfx/OhNo.wav");
		samples[TING] = Mix_LoadWAV("data/sfx/Ting.wav");
		samples[EXPLODE] = Mix_LoadWAV("data/sfx/Explode.wav");
		samples[LETSGO] = Mix_LoadWAV("data/sfx/LetsGo.wav");

		samples[SPLASH] = Mix_LoadWAV("data/sfx/Splash.wav");
		samples[DOOR] = Mix_LoadWAV("data/sfx/Door.wav");
		samples[DIE] = Mix_LoadWAV("data/sfx/Die.wav");
		samples[CHINK] = Mix_LoadWAV("data/sfx/Chink.wav");
		samples[FIRE] = Mix_LoadWAV("data/sfx/Fire.wav");
	}
}

SamplePlayer::~SamplePlayer()
{
	//do I need to free the loaded samples
	for(int n=0;n<MAX_SAMPLES;n++)
		Mix_FreeChunk(samples[n]);
}
bool oldSoundSet;
void SamplePlayer::DisableSamples(){
	oldSoundSet = sound_enabled;
	sound_enabled = false;
}

void SamplePlayer::EnableSamples(){
	sound_enabled = oldSoundSet;
}

void SamplePlayer::PlaySample(Sample sample)
{
	if(sound_enabled)
	{
		//printf("playig smaple\n");
		Mix_PlayChannel(1, samples[sample], 0);
	}
}
