/*
 * SpriteStore.cpp
 *
 *  Created on: 23 Jan 2010
 *      Author: mat
 */

#include "SpriteStore.h"
#include <sstream>

SpriteStore::SpriteStore() {
	utility = GraphicsUtility::Instance();// new GraphicsUtility();
	spriteDebugY = 0;
	SetAnimations("data/graphics/sprites.png");
	cursors = utility->load_image("data/graphics/cursors.png");
	SDL_SetColorKey(cursors, SDL_SRCCOLORKEY,SDL_MapRGB(cursors->format,255,0 ,255));

	//cursorsAreaStore = SDL_CreateRGBSurface(cursors->flags, cursors->w,
	//			cursors->h, cursors->format->BitsPerPixel,
	//			cursors->format->Rmask, cursors->format->Gmask,
	//			cursors->format->Bmask, cursors->format->Amask);

	//SDL_SetColorKey(cursorsAreaStore , SDL_SRCCOLORKEY, 0);

	fonts = FontRenderer::Instance();
	testAnim=0;
}

SpriteStore::~SpriteStore() {
//	delete(utility);
	delete(cursors);
	delete(fonts);
}

/*
 * Stores the's area of 'keepybit' based on the given sprite area at position x,y
 * on 'keepybit'.
 * keepybit - game-screen or background
 * clip - area of Cursor to use as the 'mask' area (the bit's under which we want to keep)
 *        i.e. crosshair or selected 'box'
 * x,y - the top-left of the area of the background we want to start storing
 */
//void SpriteStore::StoreCursor(SDL_Surface* keepybit, SDL_Rect* clip, int x, int y){
//	//clip is the area of the cursors image that needs keeping
//	utility->StoreArea(keepybit, cursorsAreaStore, cursors, clip, x, y);
//}

//void SpriteStore::DrawStoredCursor(SDL_Surface* screen, int x, int y){
//	utility->apply_surface(x - crossHair.offset.x,
//						   y - crossHair.offset.y,
//						   cursorsAreaStore,
//						   screen,
//						   &crossHair.clip);
//}

void SpriteStore::TestFrame(int n){
	testAnim += n;
}

void SpriteStore::TestSprite(int n){
	testSprite += n;
	testAnim = 0;
	if(testSprite >= (int)anims.size())
		testSprite = 0;
	else if(testSprite < 0)
		testSprite = anims.size()-1;
}

void SpriteStore::DrawAnimations(SDL_Surface* screen){
	SDL_FillRect(screen, &screen->clip_rect, SDL_MapRGB(screen->format, 0x00,0x00,0x00));
	SDL_Rect *r;
	AnimObject* af = anims.at(testSprite);
	r = &af[testAnim].clip;
	utility->apply_surface(50-af[testAnim].offset.x,50-af[testAnim].offset.y, player1Sprites,screen,r);
	std::stringstream numberStream;
	numberStream << testAnim;
	fonts->RenderNumber(screen, numberStream.str(), 50, 70);
}

void SpriteStore::SetAnimations(const char* animFile) {
	const int w = 16;
	const int h = 10;
	int x, y, n;

	player1Sprites = utility->load_image(animFile);
	player2Sprites = utility->load_image_swap(animFile,
							SDL_MapRGB(player1Sprites->format, 68, 68, 237),
							SDL_MapRGB(player1Sprites->format, 0, 179, 0));

	crossHair.clip.x = crossHair.clip.y = 0;
	crossHair.clip.w = 28;
	crossHair.clip.h = 27;
	crossHair.offset.x = 16;
	crossHair.offset.y = 16;

	LemmingSelected.clip.x = 0;
	LemmingSelected.clip.y = 31;
	LemmingSelected.clip.w = 28;
	LemmingSelected.clip.h = 27;
	LemmingSelected.offset.x = 16;
	LemmingSelected.offset.y = 16;

	/*
	 *	Walkers
	 */
	y = 0;
	n = 0;
	for (x = 20; x < 9 * 16; x += 16) {
		walkerRight[n].offset.x = -3;
		walkerRight[n].offset.y = 0;
		walkerRight[n].clip.x = x;
		walkerRight[n].clip.y = y;
		walkerRight[n].clip.w = 7;
		walkerRight[n].clip.h = h;

		walkerLeft[7 - n].offset.x = -3;
		walkerLeft[7 - n].offset.y = 0;
		walkerLeft[7 - n].clip.x = x;
		walkerLeft[7 - n].clip.y = y + 10;
		walkerLeft[7 - n].clip.w = 7;
		walkerLeft[7 - n].clip.h = h;
		n++;
	}
	anims.push_back(&walkerRight[0]);
	anims.push_back(&walkerLeft[0]);
	/*
	 *	Fallers
	 */
	y = 20;
	n = 0;
	for (x = 16; x < (16 * 5); x += 16) {
		fallerRight[n].offset.x = -3;
		fallerRight[n].offset.y = 0;
		fallerRight[n].clip.x = x;
		fallerRight[n].clip.y = y;
		fallerRight[n].clip.w = 6;
		fallerRight[n].clip.h = h;

		fallerLeft[n].offset.x = -3;
		fallerLeft[n].offset.y = 0;
		fallerLeft[3 - n].clip.x = x;
		fallerLeft[3 - n].clip.y = y + 10;
		fallerLeft[3 - n].clip.w = 6;
		fallerLeft[3 - n].clip.h = h;
		n++;
	}
	anims.push_back(&fallerRight[0]);
	anims.push_back(&fallerLeft[0]);
	/*
	 *	Nuke
	 */
	y = 128;
	n = 0;
	for (x = 20; x < 17 * 16; x += 16) {
		nukes[n].offset.x = -4;
		nukes[n].offset.y = 0;
		nukes[n].clip.x = x;
		nukes[n].clip.y = y;
		nukes[n].clip.w = 8;
		nukes[n].clip.h = h;
		n++;
	}
	anims.push_back(&nukes[0]);
	//anims.push_back(&walkerLeft[0]);
	printf("nukes: %d\n", n);

	/*
	 *	Floaters
	 */
	y = 96;
	n = 0;
	int m = 7;
	for (x = 19; x < (16 * 9); x += 16) {
		int xx = -6;
		int yy = -6;
		if (n > 3) {

			floaterRight[n - 4].offset.x = xx;
			floaterRight[n - 4].offset.y = yy;
			floaterRight[n - 4].clip.x = x;
			floaterRight[n - 4].clip.y = y;
			floaterRight[n - 4].clip.w = w;
			floaterRight[n - 4].clip.h = 16;

			floaterRight[m].offset.x = xx;
			floaterRight[m].offset.y = yy;
			floaterRight[m].clip.x = x;
			floaterRight[m].clip.y = y;
			floaterRight[m].clip.w = w;
			floaterRight[m].clip.h = 16;

			floaterLeft[n].offset.x = xx;
			floaterLeft[n].offset.y = yy;
			floaterLeft[n - 4].clip.x = x;
			floaterLeft[n - 4].clip.y = y + 16;
			floaterLeft[n - 4].clip.w = w;
			floaterLeft[n - 4].clip.h = 16;

			floaterLeft[m].offset.x = xx;
			floaterLeft[m].offset.y = yy;
			floaterLeft[m].clip.x = x;
			floaterLeft[m].clip.y = y + 16;
			floaterLeft[m].clip.w = w;
			floaterLeft[m].clip.h = 16;

			m--;
		} else {
			openBrollyRight[n].offset.x = xx;
			openBrollyRight[n].offset.y = 0;
			openBrollyRight[n].clip.x = x;
			openBrollyRight[n].clip.y = y;
			openBrollyRight[n].clip.w = w;
			openBrollyRight[n].clip.h = 16;

			openBrollyLeft[n].offset.x = xx;
			openBrollyLeft[n].offset.y = 0;
			openBrollyLeft[n].clip.x = x;
			openBrollyLeft[n].clip.y = y + 16;
			openBrollyLeft[n].clip.w = w;
			openBrollyLeft[n].clip.h = 16;
		}
		n++;
	}
	printf("floaters: %d\n", n);
	anims.push_back(&floaterRight[0]);
	anims.push_back(&floaterLeft[0]);
	anims.push_back(&openBrollyRight[0]);
	anims.push_back(&openBrollyLeft[0]);
	/*
	 *	Going Home
	 */
	y = 182;
	n = 0;
	for (x = 20; x < 8 * 16; x += 16) {
		goingHomeRight[n].offset.x = 0;
		goingHomeRight[n].offset.y = 0;
		goingHomeRight[n].clip.x = x;
		goingHomeRight[n].clip.y = y;
		goingHomeRight[n].clip.w = 8;
		goingHomeRight[n].clip.h = h;
		n++;
	}

	y = 182;
	n = 0;
	for (x = 20; x < 8 * 16; x += 16) {
		goingHomeLeft[n].offset.x = -4;
		goingHomeLeft[n].offset.y = 0;
		goingHomeLeft[n].clip.x = x;
		goingHomeLeft[n].clip.y = y;
		goingHomeLeft[n].clip.w = 8;
		goingHomeLeft[n].clip.h = h;
		n++;
	}
	anims.push_back(&goingHomeRight[0]);
	anims.push_back(&goingHomeLeft[0]);
	/*
	 *	Blocker
	 */
	y = 148;
	n = 0;
	for (x = 20; x < 17 * 16; x += 16) {
		blockers[n].offset.x = -5;
		blockers[n].offset.y = 0;
		blockers[n].clip.x = x;
		blockers[n].clip.y = y;
		blockers[n].clip.w = 10;
		blockers[n].clip.h = h;
		n++;
	}
	anims.push_back(&blockers[0]);

	/*
	 *	Builders
	 */
	y = 195;
	n = 0;
	for (x = 20; x < 17 * 16; x += 16) {
		builderRights[n].offset.x = -5;
		builderRights[n].offset.y = -3;
		builderRights[n].clip.x = x;
		builderRights[n].clip.y = y;
		builderRights[n].clip.w = 9;
		builderRights[n].clip.h = h + 3;

		builderLefts[n].offset.x = -6;
		builderLefts[n].offset.y = -3;
		builderLefts[n].clip.x = x - 1;
		builderLefts[n].clip.y = y + 13;
		builderLefts[n].clip.w = 9;
		builderLefts[n].clip.h = h + 3;
		n++;
	}
	printf("Builders: %d\n", n);
	anims.push_back(&builderRights[0]);
	anims.push_back(&builderLefts[0]);
	/*
	 *	Builders
	 */
	y = 221;
	n = 0;
	for (x = 20; x < 8 * 16; x += 16) {
		doneBuildingRights[n].offset.x = -5;
		doneBuildingRights[n].offset.y = -3;
		doneBuildingRights[n].clip.x = x;
		doneBuildingRights[n].clip.y = y;
		doneBuildingRights[n].clip.w = 9;
		doneBuildingRights[n].clip.h = h + 3;

		doneBuildingLefts[n].offset.x = -5;
		doneBuildingLefts[n].offset.y = -3;
		doneBuildingLefts[n].clip.x = x - 1;
		doneBuildingLefts[n].clip.y = y + 13;
		doneBuildingLefts[n].clip.w = 9;
		doneBuildingLefts[n].clip.h = h + 3;
		n++;
	}
	printf("Builders: %d\n", n);
	anims.push_back(&doneBuildingRights[0]);
	anims.push_back(&doneBuildingLefts[0]);
	/*
	 *	Bashers
	 */
	y = 261;
	n = 0;
	for (x = 18; x < 17 * 16; x += 16) {
		basherRights[n].offset.x = -8;
		basherRights[n].offset.y = 0;
		basherRights[n].clip.x = x;
		basherRights[n].clip.y = y;
		basherRights[n].clip.w = w;
		basherRights[n].clip.h = h;

		basherRights[n + 16].offset.x = -8;
		basherRights[n + 16].offset.y = 0;
		basherRights[n + 16].clip.x = x;
		basherRights[n + 16].clip.y = y + 10;
		basherRights[n + 16].clip.w = w;
		basherRights[n + 16].clip.h = h;

		basherLefts[n].offset.x = -4;
		basherLefts[n].offset.y = 0;
		basherLefts[n].clip.x = x;
		basherLefts[n].clip.y = y + 20;
		basherLefts[n].clip.w = w;
		basherLefts[n].clip.h = h;

		basherLefts[n + 16].offset.x = -4;
		basherLefts[n + 16].offset.y = 0;
		basherLefts[n + 16].clip.x = x;
		basherLefts[n + 16].clip.y = y + 30;
		basherLefts[n + 16].clip.w = w;
		basherLefts[n + 16].clip.h = h;
		n++;
	}
	printf("Bashers: %d\n", n);
	anims.push_back(&basherRights[0]);
	anims.push_back(&basherLefts[0]);
	/*
	 * Miners
	 */
	y = 301;
	n = 0;
	for (x = 16; x < 13 * 16; x += 16) {
		minerRights[n].offset.x = -8;
		minerRights[n].offset.y = -2;
		minerRights[n].clip.x = x;
		minerRights[n].clip.y = y;
		minerRights[n].clip.w = w;
		minerRights[n].clip.h = 13;

		minerRights[n + 12].offset.x = -8;
		minerRights[n + 12].offset.y = -2;
		minerRights[n + 12].clip.x = x;
		minerRights[n + 12].clip.y = y + 13;
		minerRights[n + 12].clip.w = w;
		minerRights[n + 12].clip.h = 13;

		minerLefts[n].offset.x = -9;
		minerLefts[n].offset.y = -2;
		minerLefts[n].clip.x = x;
		minerLefts[n].clip.y = y + 26;
		minerLefts[n].clip.w = w;
		minerLefts[n].clip.h = 13;

		minerLefts[n + 12].offset.x = -9;
		minerLefts[n + 12].offset.y = -2;
		minerLefts[n + 12].clip.x = x;
		minerLefts[n + 12].clip.y = y + 39;
		minerLefts[n + 12].clip.w = w;
		minerLefts[n + 12].clip.h = 13;
		n++;
	}
	printf("miners: %d\n", n);
	anims.push_back(&minerRights[0]);
	anims.push_back(&minerLefts[0]);
	/*
	 *	Diggers
	 */
	y = 247;
	n = 0;
	for (x = 16; x < 17 * 16; x += 16) {
		diggerDowns[n].offset.x = -8;
		diggerDowns[n].offset.y = -2;
		diggerDowns[n].clip.x = x;
		diggerDowns[n].clip.y = y;
		diggerDowns[n].clip.w = 16;
		diggerDowns[n].clip.h = h + 3;
		n++;
	}
	printf("Diggers: %d\n", n);
	anims.push_back(&diggerDowns[0]);

	/*
	 *	squishers/splatter
	 */
	y = 138;
	n = 0;
	for (x = 16; x < 17 * 16; x += 16) {
		splatters[n].offset.x = -8;
		splatters[n].offset.y = 0;
		splatters[n].clip.x = x;
		splatters[n].clip.y = y;
		splatters[n].clip.w = w;
		splatters[n].clip.h = h - 1;
		n++;
	}
	printf("squishers splatters: %d\n", n);
	anims.push_back(&splatters[0]);
	/*
	 *	Drowners
	 */
	y = 158;
	n = 0;
	for (x = 19; x < 17 * 16; x += 16) {
		drowners[n].offset.x = -6;
		drowners[n].offset.y = 0;
		drowners[n].clip.x = x;
		drowners[n].clip.y = y;
		drowners[n].clip.w = w;
		drowners[n].clip.h = h - 1;
		n++;
	}
	printf("Drowners: %d\n", n);
	anims.push_back(&drowners[0]);
	/*
	 *	burners
	 */
	y = 174;
	n = 0;
	for (x = 19; x < 17 * 16; x += 16) {
		burners[n].offset.x = -6;
		burners[n].offset.y = 0;
		burners[n].clip.x = x;
		burners[n].clip.y = y;
		burners[n].clip.w = w;
		burners[n].clip.h = h - 1;
		n++;
	}
	printf("burners: %d\n", n);
	anims.push_back(&burners[0]);
	/*
	 *	Climbers
	 */
	y = 40;
	n = 0;
	for (x = 17; x < (16 * 9); x += 16) {
		climberRights[n].offset.x = -6;
		climberRights[n].offset.y = -1;
		climberRights[n].clip.x = x;
		climberRights[n].clip.y = y;
		climberRights[n].clip.w = w - 1;
		climberRights[n].clip.h = h + 2;

		climberLefts[n].offset.x = -3;
		climberLefts[n].offset.y = -2;
		climberLefts[n].clip.x = x + 5;
		climberLefts[n].clip.y = y + 12;
		climberLefts[n].clip.w = w - 1;
		climberLefts[n].clip.h = h + 2;
		n++;
	}
	printf("climbing: %d\n", n);
	anims.push_back(&climberRights[0]);
	anims.push_back(&climberLefts[0]);
	/*
	 *	Stopped climbing
	 */
	y = 64;
	n = 0;
	for (x = 16; x < (16 * 9); x += 16) {
		stoppedClimbingRights[n].offset.x = -6;
		stoppedClimbingRights[n].offset.y = -2;
		stoppedClimbingRights[n].clip.x = x;
		stoppedClimbingRights[n].clip.y = y;
		stoppedClimbingRights[n].clip.w = w;
		stoppedClimbingRights[n].clip.h = h + 5;

		stoppedClimbingLefts[n].offset.x = -4;
		stoppedClimbingLefts[n].offset.y = -2;
		stoppedClimbingLefts[n].clip.x = x + 5;
		stoppedClimbingLefts[n].clip.y = y + 16;
		stoppedClimbingLefts[n].clip.w = w;
		stoppedClimbingLefts[n].clip.h = h + 5;
		n++;
	}
	printf("stopped climbing: %d\n", n);
	anims.push_back(&stoppedClimbingLefts[0]);
	anims.push_back(&stoppedClimbingRights[0]);
	//count down numbers
	y = 32;
	n = 0;
	x = 217;
	for (n = 0; n < 7; n++) {
		countDown[n].offset.x = -2;
		countDown[n].offset.y = 0;
		countDown[n].clip.x = 0;
		countDown[n].clip.y = 0;
		countDown[n].clip.x = x;
		countDown[n].clip.y = y;
		countDown[n].clip.w = 5;
		countDown[n].clip.h = 5;
		x += 16;
	}
	printf("countdown: %d\n", n);
	anims.push_back(&countDown[0]);
	//now explosion 'mask'
	x = 176;
	y = 20;
	explosion.offset.x = 0;
	explosion.offset.y = 0;
	explosion.clip.x = 176;
	explosion.clip.y = 20;
	explosion.clip.w = 29;
	explosion.clip.h = 23;

	bashRightMasks[0].offset.x = -6;
	bashRightMasks[0].offset.y = -2;
	bashRightMasks[0].clip.x = 178;
	bashRightMasks[0].clip.y = 68;
	bashRightMasks[0].clip.w = 10;
	bashRightMasks[0].clip.h = 4;

	bashRightMasks[1].offset.x = 1;//-1;
	bashRightMasks[1].offset.y = -2;
	bashRightMasks[1].clip.x = 201;
	bashRightMasks[1].clip.y = 68;
	bashRightMasks[1].clip.w = 5;
	bashRightMasks[1].clip.h = 9;

	bashRightMasks[2].offset.x = 1;
	bashRightMasks[2].offset.y = 0;
	bashRightMasks[2].clip.x = 217;
	bashRightMasks[2].clip.y = 68;
	bashRightMasks[2].clip.w = 8;
	bashRightMasks[2].clip.h = 9;

	bashRightMasks[3].offset.x = 1;
	bashRightMasks[3].offset.y = 2;
	bashRightMasks[3].clip.x = 233;
	bashRightMasks[3].clip.y = 68;
	bashRightMasks[3].clip.w = 7;
	bashRightMasks[3].clip.h = 9;

	bashLeftMasks[0].offset.x = -3;
	bashLeftMasks[0].offset.y = -2;
	bashLeftMasks[0].clip.x = 245;
	bashLeftMasks[0].clip.y = 68;
	bashLeftMasks[0].clip.w = 10;
	bashLeftMasks[0].clip.h = 4;

	bashLeftMasks[1].offset.x = -5;
	bashLeftMasks[1].offset.y = -2;
	bashLeftMasks[1].clip.x = 256;
	bashLeftMasks[1].clip.y = 68;
	bashLeftMasks[1].clip.w = 6;
	bashLeftMasks[1].clip.h = 9;

	bashLeftMasks[2].offset.x = -8;
	bashLeftMasks[2].offset.y = -2;
	bashLeftMasks[2].clip.x = 271;
	bashLeftMasks[2].clip.y = 68;
	bashLeftMasks[2].clip.w = 8;
	bashLeftMasks[2].clip.h = 9;

	bashLeftMasks[3].offset.x = -10;
	bashLeftMasks[3].offset.y = 2;
	bashLeftMasks[3].clip.x = 287;
	bashLeftMasks[3].clip.y = 68;
	bashLeftMasks[3].clip.w = 9;
	bashLeftMasks[3].clip.h = 9;

	bang.offset.x = -16;
	bang.offset.y = -16;
	bang.clip.x = 248;
	bang.clip.y = 90;
	bang.clip.w = bang.clip.h = 32;

	anims.push_back(&bashLeftMasks[0]);
	anims.push_back(&bashRightMasks[0]);

	printf("DONE! setting animations\n");
}


void SpriteStore::DrawTestAnimationBlocks(SDL_Surface *screen) {
	//Clear the screen
	SDL_FillRect(screen, &screen->clip_rect, SDL_MapRGB(screen->format, 0x00,0x00,0x00));
	int yoffset = spriteDebugY;
	//first draw entire animation sheet
	utility->apply_surface(0, yoffset, player1Sprites, screen, NULL);

	SDL_Rect *r;
	for (int n = 0; n < 8; n++) {
		r = &walkerRight[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 8; n++) {
		r = &walkerLeft[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 4; n++) {
		r = &fallerLeft[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 4; n++) {
		r = &fallerRight[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 16; n++) {
		r = &diggerDowns[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 32; n++) {
		r = &basherRights[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 32; n++) {
		r = &basherLefts[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 16; n++) {
		r = &builderRights[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 16; n++) {
		r = &builderLefts[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 16; n++) {
		r = &blockers[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 16; n++) {
		r = &nukes[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 24; n++) {
		r = &minerRights[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 24; n++) {
		r = &minerLefts[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 16; n++) {
		r = &splatters[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 8; n++) {
		r = &floaterRight[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 8; n++) {
		r = &floaterLeft[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 4; n++) {
		r = &openBrollyRight[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 4; n++) {
		r = &openBrollyLeft[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
	for (int n = 0; n < 4; n++) {
		r = &bashLeftMasks[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
		r = &bashRightMasks[n].clip;
		utility->DrawBox(screen, r->x, r->y + yoffset, r->w, r->h);
	}
}
