/*
 * SpriteStore.h
 *
 *  Created on: 23 Jan 2010
 *      Author: mat
 */

#ifndef SPRITESTORE_H_
#define SPRITESTORE_H_

#include "SDL/SDL.h"
#include "SDL/SDL_image.h"
#include "GraphicsUtility.h"
#include "FontRenderer.h"
#include <vector>

class SpriteStore {
public:
	SpriteStore();
	virtual ~SpriteStore();
	void SetAnimations(const char* animFile);
	void DrawTestAnimationBlocks(SDL_Surface *screen);
	void DrawAnimations(SDL_Surface* screen);
	void TestFrame(int n);
	void TestSprite(int n);

	//void StoreCursor(SDL_Surface* keepybit, SDL_Rect* sprite, int x, int y);
	//void DrawStoredCursor(SDL_Surface* screen, int x, int y);
	struct Offset
	{
		int x;
		int y;
	};
	struct AnimObject
	{
		SDL_Rect clip;
		Offset offset;
	};
	std::vector<AnimObject*> anims;

	static const int WALKER_MAX = 8;
	static const int FALLER_MAX = 4;
	static const int DIGGERS_MAX = 16;
	static const int BASHERS_MAX = 32;
	static const int BUILDERS_MAX = 16;
	static const int BLOCKERS_MAX = 16;
	static const int NUKES_MAX = 16;
	static const int MINERS_MAX = 24;
	static const int COUNTDOWN_MAX = 7;
	static const int SPLATTERS_MAX = 16;
	static const int FLOATERS_MAX = 8;
	static const int OPEBROLLY_MAX = 4;
	static const int DONEBUILDING_MAX = 8;
	static const int CLIMBER_MAX = 8;
	static const int DROWNER_MAX = 16;
	static const int BURNER_MAX = 16;
	static const int STOPPEDCLIMBING_MAX = 8;
	static const int GOINGHOME_MAX = 8;
	static const int BASHMASK_MAX = 4;

	//Animation clips:
	AnimObject walkerRight[ WALKER_MAX ];
	AnimObject walkerLeft[ WALKER_MAX ];
	AnimObject fallerLeft[ FALLER_MAX ];
	AnimObject fallerRight[ FALLER_MAX ];
	AnimObject diggerDowns[ DIGGERS_MAX ];
	AnimObject basherRights[ BASHERS_MAX ];
	AnimObject basherLefts[ BASHERS_MAX ];
	AnimObject builderRights[ BUILDERS_MAX ];
	AnimObject builderLefts[ BUILDERS_MAX ];
	AnimObject blockers[ BLOCKERS_MAX ];
	AnimObject nukes[ NUKES_MAX ];
	AnimObject minerRights[ MINERS_MAX ];
	AnimObject minerLefts[ MINERS_MAX ];
	AnimObject countDown[ COUNTDOWN_MAX ];
	AnimObject splatters[ SPLATTERS_MAX ];
	AnimObject floaterRight[ FLOATERS_MAX ];
	AnimObject floaterLeft[ FLOATERS_MAX ];
	AnimObject openBrollyRight[ OPEBROLLY_MAX ];
	AnimObject openBrollyLeft[ OPEBROLLY_MAX ];
	AnimObject doneBuildingRights[ DONEBUILDING_MAX ];
	AnimObject doneBuildingLefts[ DONEBUILDING_MAX ];
	AnimObject climberRights[ CLIMBER_MAX ];
	AnimObject climberLefts[ CLIMBER_MAX ];
	AnimObject drowners[ BURNER_MAX ];
	AnimObject burners[ BURNER_MAX ];
	AnimObject stoppedClimbingRights[ STOPPEDCLIMBING_MAX ];
	AnimObject stoppedClimbingLefts[ STOPPEDCLIMBING_MAX ];
	AnimObject goingHomeRight[ GOINGHOME_MAX ];
	AnimObject goingHomeLeft[ GOINGHOME_MAX ];
	AnimObject explosion;
	AnimObject crossHair;
	AnimObject LemmingSelected;
	AnimObject bashLeftMasks[ BASHMASK_MAX ];
	AnimObject bashRightMasks[ BASHMASK_MAX ];
	AnimObject bang;

	SDL_Surface* player1Sprites;
	SDL_Surface* player2Sprites;
	SDL_Surface* cursors;
	//SDL_Surface* cursorsAreaStore;
private:
	GraphicsUtility *utility;
	int spriteDebugY;
	int testAnim;
	int testSprite;
	FontRenderer* fonts;
};

#endif /* SPRITESTORE_H_ */
