/*
 * IconDisplay.h
 *
 *  Created on: 16 Oct 2009
 *      Author: math
 */

#ifndef ICONDISPLAY_H_
#define ICONDISPLAY_H_

#include "GraphicsUtility.h"
#include "FontRenderer.h"
#include <sstream>
#include <vector>

#ifdef WIN32
	#include "SDL/SDL.h"
	#include "SDL/SDL_image.h"
#else
	#include "SDL/SDL.h"
	#include "SDL/SDL_image.h"
#endif

#include "SamplePlayer.h"

#define OVERVIEW_OFFSET_X 414
#define OVERVIEW_OFFSET_Y 2
#define OVERVIEW_WIDTH 196
#define OVERVIEW_HEIGHT 40
#define ICON_POSITION_Y ypos+2

class StatusPanel
{
public:
	enum GameType
	{
		Server,
		Client,
		SinglePlayer
	};
	StatusPanel(int newXpos, int newYpos, int screenWidth, int screenHeight, SamplePlayer* samples, int zoom);
	~StatusPanel();
	void AddToGreenTotal(GameType);
	void AddToBlueTotal(GameType);
	void SetTwoPlayerMode(bool);
	void Draw(SDL_Surface* screen);
	void CreateOverviewImage(SDL_Surface* fullSizeLevel);
	void SetGameStats(int, int, int, int, std::vector<int>*, int);//TODO: set this once only!
	void DrawMarker(int,int,SDL_Surface*);
	void DrawTotals(SDL_Surface*);
	void SetGameMode(GameType type);
	int SelectIcon(int, int);
	void UpdateOverviewOffset(int, int);
	void SetSelectedStatus(std::string, int);
	int GetSelectedIcon();
	int BlueHome();
	int GreenHome();
	SDL_Rect viewport;
	int xpos;
	int ypos;
	int zoom;
private:
	GraphicsUtility *utility;
	FontRenderer* fontRenderer;

	SDL_Surface* iconBar;
	SDL_Surface* iconBarClient;
	SDL_Surface* levelOverview;
	SDL_Surface* totalsImage;
	void SetSelectedIcon(int value);
	GameType type;

	void Draw(SDL_Surface* screen, SDL_Surface* icons);
	int iconSelected;
	int sIconX;
	int divx, divy;
	int timeRemaining;
	int totalOut;
	int percentHome;
	int minReleaseRate;
	int release_rate;
	std::string selectedType;
	int selectedCount;
	SamplePlayer* samples;
	//unsigned char*   tool_complement;
	std::vector<int>* tool_complement;
	SDL_Rect overviewRect;
	std::vector<StatusPanel::GameType> blueTotals;
	std::vector<StatusPanel::GameType> greenTotals;
};

#endif /* ICONDISPLAY_H_ */
