/*
 * TwoPlayerTotals.cpp
 *
 *  Created on: 19 Nov 2009
 *      Author: math
 */

#include "TwoPlayerTotals.h"

TwoPlayerTotals::TwoPlayerTotals() {
	//Load 2PlayerTotals image
	utility = GraphicsUtility::Instance();
	totalsImage = utility->load_image("data/graphics/TwoplayerTotals.png");
}

TwoPlayerTotals::~TwoPlayerTotals() {
	//delete image
	//delete(utility);
	SDL_FreeSurface(totalsImage);
}

void TwoPlayerTotals::SetGreens(int n)
{
	totalGreen = n;
}

void TwoPlayerTotals::SetBlues(int n)
{
	totalBlue = n;
}

void TwoPlayerTotals::Draw(SDL_Surface* screen)
{
	//Clear the screen
	SDL_FillRect(screen, &totalsImage->clip_rect, 0);
	utility->apply_surface(0,5, totalsImage, screen, &totalsImage->clip_rect);

	//now totals
	SDL_Rect clip;
	clip.x = 14;
	clip.y = 305 - totalBlue;
	clip.w = 15;
	clip.h = totalBlue;
	SDL_FillRect(screen, &clip, SDL_MapRGB(totalsImage->format, 85, 51, 254));

	clip.x = 14;
	clip.y = 305 - totalGreen;
	clip.w = 30;
	clip.h = totalGreen;
	SDL_FillRect(screen, &clip, SDL_MapRGB(totalsImage->format, 0, 186, 0));
}
