#ifdef WIN32
#include "SDL/SDL.h"
#include "SDL/SDL_image.h"
#else
#include "SDL/SDL.h"
#include "SDL/SDL_image.h"
#endif

#include "MainForm.h"
#include <string>
#include <iostream>

#ifdef WIN32
#include <windows.h>
int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, char* command_line,
		int nShowCmd) {
	int argc;
	char** argv;

	char* arg;
	int index;
	int result;

	// count the arguments

	argc = 1;
	arg = command_line;

	while (arg[0] != 0) {

		while (arg[0] != 0 && arg[0] == ' ') {
			arg++;
		}

		if (arg[0] != 0) {

			argc++;

			while (arg[0] != 0 && arg[0] != ' ') {
				arg++;
			}
		}
	}

	// tokenize the arguments

	argv = (char**) malloc(argc * sizeof(char*));

	arg = command_line;
	index = 1;

	while (arg[0] != 0) {

		while (arg[0] != 0 && arg[0] == ' ') {
			arg++;
		}

		if (arg[0] != 0) {

			argv[index] = arg;
			index++;

			while (arg[0] != 0 && arg[0] != ' ') {
				arg++;
			}

			if (arg[0] != 0) {
				arg[0] = 0;
				arg++;
			}

		}

	}

	// put the program name into argv[0]

	char filename[_MAX_PATH];

	GetModuleFileName(NULL, filename, _MAX_PATH);
	argv[0] = filename;

	// call the user specified main function

	result = main(argc, argv);

	free(argv);
	return result;
}
#endif

int main(int argc, char* args[]) {
	int width = 640;
	int height = 400;
	int buffer = 4;
	#ifdef PLATFORM_PANDORA
	bool fullscreen = true;
	#else
	bool fullscreen = false;
	#endif
	bool sound_enabled = true;

	//find res w h and f and use them
	for (int i = 0; i < argc; i++) {
		if (strcmp(args[i], "w") == 0) {
			width = atoi(args[i + 1]);
		} else if (strcmp(args[i], "h") == 0) {
			height = atoi(args[i + 1]);
		} else if (strcmp(args[i], "fs") == 0) {
			int fs = atoi(args[i + 1]);
			fullscreen = fs == 1 ? true : false;
		}else if (strcmp(args[i], "sound_enabed") == 0) {
			int ns = atoi(args[i + 1]);
			sound_enabled = ns == 1 ? true : false;
		}else if (strcmp(args[i], "buffer") == 0) {
			buffer = atoi(args[i + 1]);
		}
	}

	printf("in main\n");
	MainForm* mainform = new MainForm(width, height, fullscreen, sound_enabled, buffer);
	if(!mainform->Init(width, height, fullscreen, buffer))
	{
		printf("MainForm failed to initilise\n");
	}
	else{
		printf("about to MainLoop \n");
		mainform->MainLoop();
	}

	delete (mainform);
	return 0;
}
