/*
 * ClientSetup.cpp
 *
 *  Created on: 16 Jan 2010
 *      Author: mat
 */

#include "ClientSetup.h"

ClientSetup::ClientSetup(MenuItem* dad) : MenuItem(dad) {
	//set parent of level select as out parent, we won't come here again...
	clientLevelSelect = new ClientLevelSelect(dad);
	//TODO: load from a file!

	ipaddress_bits[0] = new char[3];
	ipaddress_bits[0][0] ='1';
	ipaddress_bits[0][1] ='2';
	ipaddress_bits[0][2] ='7';

	ipaddress_bits[1] = new char[3];
	ipaddress_bits[1][0] ='0';
	ipaddress_bits[1][1] ='0';
	ipaddress_bits[1][2] ='0';

	ipaddress_bits[2] = new char[3];
	ipaddress_bits[2][0] ='0';
	ipaddress_bits[2][1] ='0';
	ipaddress_bits[2][2] ='0';


	ipaddress_bits[3] = new char[3];
	ipaddress_bits[3][0] ='0';
	ipaddress_bits[3][1] ='0';
	ipaddress_bits[3][2] ='1';


}

ClientSetup::~ClientSetup() {
	delete(clientLevelSelect);
}

void ClientSetup::DrawSelf(SDL_Surface* screen){
	std::stringstream stream;
	stream.clear();

	if(++cursFlash % 20 == 0){
		doit = !doit;
		forceRedraw=true;
	}

	if(forceRedraw){
		forceRedraw = false;

		TileBackground(screen);

		int xPos = 180;
		int yPos = 180;
		int h = 32;

		xPos = 90;
		yPos = 90;
		h = 32;

		stream.str("");
		stream << "Please Type in Server IP Address";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos, BLUE, CENTER);

		stream.str("");



		int tot = 0;
		for(int octet = 0; octet < 4; octet++) {
			std::stringstream ss;
			ss.clear();
			ss << ipaddress_bits[octet];
			std::string s = std::string(ss.str());
			tot += s.size();
			bool numberStarted = false;
			for(int t = 0; t < 3; t++) {
				//if(currentOctet == octet && cursPosX == t){

				//}
				//else{
				if( (ipaddress_bits[octet][t] != '0') ){
					numberStarted = true;
				}
				if(numberStarted){
					if(t==2 &&  currentOctet == octet){
						if(!doit){
							stream << "_";
						}
						else{
							stream << ipaddress_bits[octet][t];
						}
					}
					else stream << ipaddress_bits[octet][t];
				}
			}

			if(!numberStarted ) {
				if(currentOctet == octet){
					if(!doit){
						stream << "_";
					}
					else{
						stream << '0';
					}
				} else{
					stream << '0';
				}
			}


			if(octet != 3)//only put a dot after the first 3!
				stream << ".";
		}
		if(scrlock())
			ipaddress = stream.str();

		fontRenderer->RenderString(screen, stream.str(), 40, yPos+=h*2, BLUE, CENTER);
		fontRenderer->RenderString(screen, "Press mouse to continue", 40, 400-FontHeight-2, BLUE, CENTER);
	}
}

void ClientSetup::HandleKey(int k){
	keypressed=false;
	if(k == SDLK_RETURN){
		forceRedraw=true;
		SetIP();
		SetCurrentScreen(clientLevelSelect);
	}
	else if(k == SDLK_PERIOD){
		//convert current octet into a number
		//and enter into array
		forceRedraw=true;
		//now we msut disregard any chars ahead in this octet
		//so move each forward

		//move onto next thingy
		//if(cursPosX!=0){
			currentOctet++;
			cursPosX = 2;
/*			if(currentOctet == 4)
			{
				forceRedraw=true;
				currentOctet = 0;
			}else {
				for(int t = 0; t < 3; t++) {
					ipaddress_bits[currentOctet][t] = '0';
				}
				octetKeyPressCount=0;
			}
*/
			for(int t = 0; t < 3; t++) {
				ipaddress_bits[currentOctet][t] = '0';
			}

		//}
	}
	else if(k == SDLK_RIGHT)
	{
		currentOctet++;
		if(currentOctet == 4)
		{
			currentOctet = 0;
		}
		octetKeyPressCount=0;
		forceRedraw=true;

	}
	else if(k == SDLK_LEFT)
	{
		currentOctet--;
		if(currentOctet == -1)
		{
			currentOctet = 3;
		}
		octetKeyPressCount=0;
		forceRedraw=true;
		/*doit=false;
		cursPosX--;
		if(cursPosX == -1)
		{
			cursPosX = 2;

			currentOctet--;
			if(currentOctet == -1)
			{
				currentOctet = 3;
				cursPosX = 2;
			}
		}*/
	}
	else if(k >= 48 && k <= 57){
		if(octetKeyPressCount==0){
			for(int t = 0; t < 3; t++) {
				ipaddress_bits[currentOctet][t] = '0';
			}
		}
		forceRedraw=true;
		keypressed = true;
		doit=false;
		//wherever we are we want to replace the char

		//ipaddress_bits[currentOctet][cursPosX] = k;

		//now re-arrange, so they appear in the right order
		if(cursPosX == 2){
			//currentOctet++;
			//if(currentOctet == 4){
			//	currentOctet = 0;
			//}
			char temp2 = ipaddress_bits[currentOctet][2];
			char temp1 = ipaddress_bits[currentOctet][1];
			ipaddress_bits[currentOctet][2] = k;
			ipaddress_bits[currentOctet][1] = temp2;
			ipaddress_bits[currentOctet][0] = temp1;

		}else if(cursPosX == 1){
			char temp2 = ipaddress_bits[currentOctet][2];
			char temp1 = ipaddress_bits[currentOctet][1];
			ipaddress_bits[currentOctet][2] = k;
			ipaddress_bits[currentOctet][1] = temp2;
			ipaddress_bits[currentOctet][0] = temp1;
		}else if(cursPosX == 0){
			char temp2 = ipaddress_bits[currentOctet][2];
			char temp1 = ipaddress_bits[currentOctet][1];
			ipaddress_bits[currentOctet][2] = k;
			ipaddress_bits[currentOctet][1] = temp2;
			ipaddress_bits[currentOctet][0] = temp1;
		}
		cursPosX--;
		if(cursPosX==-1){
			cursPosX=2;
		}
		//currentOctet++;
		//if(currentOctet == 4){
		//	currentOctet = 0;
		//}
/*
		cursPosX++;
		if(cursPosX == 3){
			cursPosX = 0;
			currentOctet++;
			if(currentOctet == 4){
				currentOctet = 0;
				cursPosX = 0;
			}
			else {
				//clear the octet
				//for(int t = 0; t < 3; t++) {
				//	ipaddress_bits[currentOctet][t] = '0';
				//}
			}
		}*/

		octetKeyPressCount++;
	}
}

void ClientSetup::HandleMouse(int mx,int my,long lb,long rb){
	if(leftclick)
	{
		forceRedraw=true;
		SetIP();
		SetCurrentScreen(clientLevelSelect);
	}
}
void ClientSetup::SetIP(){
	std::stringstream stream;
	for(int octet = 0; octet < 4; octet++) {
		std::stringstream ss;
		ss.clear();
		ss << ipaddress_bits[octet];
		std::string s = std::string(ss.str());
		bool dunum=false;
		for(int t = 0; t < 3; t++) {
			if( !(ipaddress_bits[octet][t] == '0' && dunum==false) || t == 2 /*|| currentOctet == octet*/)
			{
				dunum=true;
				stream << ipaddress_bits[octet][t];
			}
		}
		if(octet != 3)//only put a dot after the first 3!
			stream << ".";
	}

	ipaddress = stream.str();

	printf("ipaddress: %s\n", ipaddress.c_str());
}
void ClientSetup::Init(){
	octetKeyPressCount = 0;
	doit = false;
	currentOctet = 0;
	cursPosX = 2;
	MenuItem::Init();
}
