/*
 * GameScreen.cpp
 *
 *  Created on: 10 Dec 2009
 *      Author: math
 */

#include "OnePlayerGameScreen.h"

OnePlayerGameScreen::OnePlayerGameScreen(MenuItem* newParent) :  MenuItem(newParent){
	frameCount = 0;
	sendClick=false;
	drawhand=false;
	//Parent is LevelSelect
	onePlayerGameOver = new OnePlayerGameOver(newParent);
	speed = game_frame_mult;
}

OnePlayerGameScreen::OnePlayerGameScreen(MenuItem* newParent, int new_width, int new_height) : MenuItem(newParent, new_width, new_height) {
	frameCount = 0;
	sendClick = false;
	drawhand = false;
}

OnePlayerGameScreen::~OnePlayerGameScreen() {
	delete(onePlayerGameOver);
}

/*
 * only update screen every 3 frames to get correct fps
 */
void OnePlayerGameScreen::DrawSelf(SDL_Surface* screen){
	if(leftclick) sendClick = true;

	if(frameCount >= speed){
		game->SetMouseClick(mouse_x, mouse_y, sendClick);
		game->AnimateFrame();
		frameCount = 0;
		forceRedraw = true;
		sendClick = false;
	}
	else{
		frameCount++;
	}

	if(forceRedraw || !scrlock())
		game->Draw(screen);
}

void OnePlayerGameScreen::DrawMousePointer(SDL_Surface* screen){
	game->DrawCursor(screen);
}

void OnePlayerGameScreen::HandleKey(int k){
	if(k == SDLK_s)
	{
		if(speed == game_frame_mult)
			speed = 0;
		else
			speed = game_frame_mult;
	}
	else
		game->HandleKey(k);
}

void OnePlayerGameScreen::HandleMouse(int mx,int my, long lb,long rb){
	forceRedraw = game->SetMousePosition(mx, my, leftclick, rb, lb);
	if(!weDidIt && game->IsGameComplete()){//having this here doesn't make sense
		SendEscape();
		game->CloseConnection();
		weDidIt = true;
	}
}

void OnePlayerGameScreen::Init(){
	weDidIt = false;
	speed = game_frame_mult;
}

MenuItem* OnePlayerGameScreen::SendEscape() {
	if(scrlock())
	{
		this->Reset();
		return SetCurrentScreen(onePlayerGameOver);
	}
	else return this;
}

