/*
 * ServerScreen.cpp
 *
 *  Created on: 18 Dec 2009
 *      Author: mat
 */

#include "ServerLevelSelect.h"

ServerLevelSelect::ServerLevelSelect(MenuItem* daddy) : MenuItem(daddy){
	serverGameScreen = new ServerGameScreen(this);
	connected = false;
}

ServerLevelSelect::~ServerLevelSelect() {
	delete(serverGameScreen);
}

void ServerLevelSelect::DrawSelf(SDL_Surface* screen){
	std::stringstream stream;
	stream.clear();
	if(forceRedraw){
		forceRedraw = false;
		//clear screen
		SDL_FillRect(screen, &screen->clip_rect, SDL_MapRGB( screen->format, 0x00, 0x00, 0x00 ) );

		TileBackground(screen);

		DrawLevelPreview(screen);

		int xPos = 180;
		int yPos = 180;
		int h = 32;
		stream << "Level " << levelLoader->currentLevel+1;
		fontRenderer->RenderString(screen, stream.str(), 1, yPos-32, RED, ABSOLUTE);

		stream.str("");
		stream << game->currentLevel->GetLevelName();
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos-32, RED, ABSOLUTE);

		stream.str("");
		stream << "(you) Blue  Player has " << game->blueGameMaxLems << " Lemmings" ;
		fontRenderer->RenderString(screen, stream.str(), 10, yPos+=h, BLUE, ABSOLUTE);

		stream.str("");
		stream << "      Green Player has " << game->greenGameMaxLems << " Lemmings " ;
		fontRenderer->RenderString(screen, stream.str(), 10, yPos+=h, GREEN, ABSOLUTE);

		stream.str("");
		stream << "Release Rate " << game->currentLevel->GetReleaseRate();
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos+=h, BROWN, CENTER);
	}

	if(!waitingForConnection)
		fontRenderer->RenderString(screen, "Press left button to start", 40, 400-FontHeight-2, BLUE, CENTER);
	else
	{
		fontRenderer->RenderString(screen, "Waiting for client to connect...", 40, 400-FontHeight-2, BLUE, CENTER);
		if(!connected)
		{
			connected = game->WaitForClientToConnect();
			if(connected){
				sleeping = false;
				printf("server connected, yay set to game screen\n");
				//if now connected send the level to the client, before changin screen
				game->SetClientLevel(levelLoader->currentLevel);
				SetCurrentScreen(serverGameScreen);
			}
		}
	}
}

MenuItem* ServerLevelSelect::SendEscape() {
	game->CloseConnection();
	return MenuItem::SendEscape();
}

void ServerLevelSelect::HandleKey(int k){
	if(k == SDLK_RETURN){
		if(!waitingForConnection){
			waitingForConnection = true;
			sleeping = true;
			forceRedraw=true;
			game->ConnectToGame(StatusPanel::Server,"");
		}
	}
	if(!connected){
		if(k == SDLK_RIGHT )
		{
			forceRedraw=true;
			levelLoader->NextTwoPlayerLevel();
			Init();
		}
		else if(k == SDLK_LEFT)
		{
			forceRedraw=true;
			levelLoader->PreviousTwoPlayerLevel();
			Init();
		}
	}
}

void ServerLevelSelect::HandleMouse(int mx,int my,long lb,long rb){
	if(leftclick && !waitingForConnection){
		sleeping = true;
		waitingForConnection = true;
		forceRedraw=true;
		game->ConnectToGame(StatusPanel::Server,"");
	}
}

void ServerLevelSelect::Reset(){
	sleeping = false;
	MenuItem::Reset();
}

void ServerLevelSelect::Init(){
	game->Load2PlayerLevel(levelLoader);
	game->Init(StatusPanel::Server);
	waitingForConnection = false;
	connected = false;
	printf("done a ConnectToGame as server\n");
	printf("Initiated serverLevelSelect and Game object for server.\n");
	MenuItem::Init();
}

