/*
 * TitleScreen.cpp
 *
 *  Created on: 10 Dec 2009
 *      Author: mat
 */

#include "TitleScreenMenu.h"
#include "OnePlayerLevelSelect.h"
#include "TwoPlayerSetupScreen.h"

using namespace std;

TitleScreenMenu::TitleScreenMenu(MenuItem* newParent, int new_width, int new_height, bool Sound_enabled, int buffer) : MenuItem(newParent, new_width, new_height) {
	sound_enabled = Sound_enabled;
	if (game == NULL) {
		game = new Game(new_width / 2, new_height / 2, 25, 2, sound_enabled, buffer);
		printf("created a new game\n");
	}

	ohnomore = utility->load_image("data/graphics/ohnomore.png");
	titlescreen = utility->load_image("data/graphics/title_screen.png", 255);

	//load all the level icons in
	filllevelIcon(utility->load_image("data/graphics/fun.png"), LevelLoader::Fun);
	filllevelIcon(utility->load_image("data/graphics/tricky.png"), LevelLoader::Tricky);
	filllevelIcon(utility->load_image("data/graphics/taxing.png"), LevelLoader::Taxing);
	filllevelIcon(utility->load_image("data/graphics/mayhem.png"), LevelLoader::Mayhem);
	//oh no, more lemmings!
	filllevelIcon(utility->load_image("data/graphics/tame.png"), LevelLoader::Tame);
	filllevelIcon(utility->load_image("data/graphics/crazy.png"), LevelLoader::Crazy);
	filllevelIcon(utility->load_image("data/graphics/wild.png"), LevelLoader::Wild);
	filllevelIcon(utility->load_image("data/graphics/wicked.png"), LevelLoader::Wicked);
	filllevelIcon(utility->load_image("data/graphics/havoc.png"), LevelLoader::Havoc);

	soundIcons.push_back(utility->load_image("data/graphics/music.png"));
	soundIcons.push_back(utility->load_image("data/graphics/FX.png"));

	scrollyArea = new SDL_Rect();
	scrollyArea->x = 0;
	scrollyArea->y = titlescreen->clip_rect.h;
	scrollyArea->w = titlescreen->clip_rect.w;
	scrollyArea->h = new_height - titlescreen->clip_rect.h;
	//scrollyMsg = "                                     Lemmings SDL......all graphics ripped shamelessly from the original Amiga version. So, sorry for that Psygnosis...or Sony now I should say. Well, I don't think I'm doing anything morally wrong, so just enjoy the Lemmings.....                                                ";
	//scrollyMsg = "                                          This is the second release of Lemmings SDL, soon to become Zomblins(?). I've pandored (can you see what I did there?) to the desires of several forum members for this version. Still a few issues to be ironed out but I'm getting there (those damn exit animations are doing my nut in!) For your information the Multiplayer game apparently does work on the Internet as tested by forum member RubiX. He used a program called 'Hamachi' in order to bypass his (I think) firewall settings (The port that needs to be opened is 2001). I have fixed the crappy IP address entry system and made it slightly less crappy but still definately crappy. So as you can see not everything is perfect yet..........Hey, I like writing scrolling messages. Very boring to read though I would imagine!!!!!,.,., :-)........just play the game.......mutliplayer should be lots of fun. I haven't actually played it yet :-( yippeeeee! Let's go!                                             ";scrollPos = pos = 0;
	//scrollyMsg = "                                          LemmingsSDL V0.9.1. Press 'F' or 'F11' for fullscreen mode. If you have problems running fullscreen, then use command line parameters to set screen size (eg LemmingsSDL w 640 h 320 fs 0). Now onto the old scroller.........This is the closest to perfection I've managed to reach so far with this pointless quest and I thought it was time to release it, so all of the 2 or 3 people who actually might get around to having a look at it can! I really don't mind. It's been fun fiddling with the code until it (nearly) works! Programming this game is starting to drive me insane, why am I even typing this crap? The problem is that trying to replicate the Amiga version perfectly is proving to be incredibly difficult, I might just leave this at this and forget about it. The code is out there so anyone is free to try and reach perfection with it (though, quite why anyone would want to do such a strange thing, I'll never know...). Yunno, someone should write a piece of software that emulates these old computers so we can play them perfectly! Anyway, signing off now as this text is plain bat-shit insane!!! byeeee!                                            ";scrollPos = pos = 0;
	scrollyMsg = "                                          LemmingsSDL V0.9.3 Press 'F' or 'F11' for fullscreen mode. If you have problems running fullscreen, then use command line parameters to set screen size (eg LemmingsSDL w 640 h 480 fs 0). Not going to write a scroller this time. Maybe I'll do it when it's finally finished...so that would be never then! This is version is the first version with network-frame-buffering(tm)!                                            ";scrollPos = pos = 0;
	currentLevelSet=0;
	//now add it's child screen
	onePlayerLevelSelectObject = new OnePlayerLevelSelect(this);
	twoPlayerSetupScreenObject = new TwoPlayerSetupScreen(this);
	designer = new DesignerScreen(this);
	if(sound_enabled)
		playingMusic = true;
	else
		playingMusic = false;

	if(plevelSelect == NULL) plevelSelect = onePlayerLevelSelectObject;
	Mix_HookMusicFinished( &MenuItem::FreeMusic );
	playmusic();
}


TitleScreenMenu::TitleScreenMenu(MenuItem* newParent) : MenuItem(newParent) {
}

TitleScreenMenu::~TitleScreenMenu() {
	//delete background
	SDL_FreeSurface(titlescreen);
	SDL_FreeSurface(ohnomore);
	delete(onePlayerLevelSelectObject);
	delete(twoPlayerSetupScreenObject);
	delete(scrollyArea);
	delete(game);
	for(unsigned int n = 0; n < levelIcons.size(); n++)
		SDL_FreeSurface(levelIcons[n]->icon);

	for(unsigned int n = 0; n < soundIcons.size(); n++)
		SDL_FreeSurface(soundIcons[n]);
}

void TitleScreenMenu::DrawSelf(SDL_Surface* screen){
	std::stringstream stream;
	stream.clear();

	//clear screen
	if(forceRedraw){
		SDL_FillRect(screen, &screen->clip_rect, SDL_MapRGB( screen->format, 0x00, 0x00, 0x00 ) );
		utility->apply_surface(0,0, titlescreen, screen, NULL);
		if(currentLevelSet > 3) utility->apply_surface(103,32,ohnomore,screen,NULL);
		utility->apply_surface(520,259,levelIcons[currentLevelSet]->icon,screen,NULL);
		utility->apply_surface(395,259,soundIcons[currentSoundSetting],screen,NULL);
		forceRedraw=false;
	}

	int xPos = 0;
	int yPos = 330;
	int h = 32;

	stream.str("");
	stream << scrollyMsg.substr(pos, 46);

	//SDL_FillRect(screen, &screen->clip_rect, SDL_MapRGB( screen->format, 0x00, 0x00, 0x00 ) );
	SDL_FillRect(screen, scrollyArea, SDL_MapRGB( screen->format, 0x00, 0x00, 0x00 ) );

	fontRenderer->RenderString(screen, stream.str(), (xPos - scrollPos/100), yPos += h, GREEN, ABSOLUTE);

	scrollPos += 250;
	if(scrollPos >= 16*4*100)
	{
		scrollPos = 0;
		pos += 4;
		if(pos > scrollyMsg.length() - 46)
		  pos = 0;
	}
}

void TitleScreenMenu::HandleKey(int k){
	if(k == SDLK_1){
		SetCurrentScreen(onePlayerLevelSelectObject);
		Mix_FadeOutMusic(1000);
		playingMusic = false;
	}
	else if(k == SDLK_2)
		SetCurrentScreen(twoPlayerSetupScreenObject);
	else if(k == SDLK_UP){
		if((++currentLevelSet) >= (int)levelIcons.size())
			currentLevelSet=(int)levelIcons.size()-1;
		levelLoader->SetLevelSet(currentLevelSet);
		levelLoader->SetLevel(0);
		forceRedraw=true;
	}else if(k == SDLK_DOWN){
		if((--currentLevelSet) < 0)
			currentLevelSet = 0;
		levelLoader->SetLevelSet(currentLevelSet);
		levelLoader->SetLevel(0);
		forceRedraw=true;
	}else if(k == SDLK_RETURN){
		levelLoader->SetLevelSet(currentLevelSet);
		SetCurrentScreen(onePlayerLevelSelectObject);
		if(sound_enabled){
			Mix_FadeOutMusic(1000);
		}
		playingMusic = false;
		forceRedraw=true;
	}else if(k == SDLK_m){
		if(++currentSoundSetting  >= soundIcons.size()){
			playingMusic=true;
			game->SetMusicOn();
			playmusic();
			forceRedraw=true;
		}
		else if(currentSoundSetting==1)
		{
			playingMusic=false;
			game->SetMusicOff();
			Mix_FadeOutMusic(1000);
			forceRedraw=true;
		}
	}
}

void TitleScreenMenu::HandleMouse(int mx,int my,long lb,long rb){
	if(leftclick) {
		//is it in the vicinity of 1-player?
		if(mx > 18 && mx < 114 && my > 246 && my < 370) {
			levelLoader->SetLevelSet(currentLevelSet);
			SetCurrentScreen(onePlayerLevelSelectObject);
			Mix_FadeOutMusic(1000);
			playingMusic = false;
			forceRedraw=true;
		}
		else if(mx > 148 && mx < 235 && my > 244 && my < 370) {
			levelLoader->SetLevelSet(currentLevelSet);
			game->ResetMultiplayer();
			SetCurrentScreen(twoPlayerSetupScreenObject);
			Mix_FadeOutMusic(1000);
			forceRedraw=true;
		}
		else if(mx > 278 && mx < 325 && my > 244 && my < 370) {
			SetCurrentScreen(designer);
			forceRedraw=true;
		}
		else if(mx >= 600 && mx < 620 && my > 267 && my < 295) {
			if((++currentLevelSet) >= (int)levelIcons.size())
				currentLevelSet=(int)levelIcons.size()-1;
			levelLoader->SetLevelSet(currentLevelSet);
			levelLoader->SetLevel(0);
			forceRedraw=true;
		}
		else if(mx >= 600 && mx < 620 && my > 296 && my < 323) {
			if((--currentLevelSet) < 0)
				currentLevelSet = 0;
			levelLoader->SetLevelSet(currentLevelSet);
			levelLoader->SetLevel(0);
			forceRedraw=true;
		}
		else if(mx >= 394 && mx < 494 && my > 259 && my < 329) {
			if(++currentSoundSetting  >= soundIcons.size()){
				playingMusic=true;
				game->SetMusicOn();
				playmusic();
				forceRedraw=true;
			}
			else if(currentSoundSetting==1)
			{
				playingMusic=false;
				game->SetMusicOff();
				Mix_FadeOutMusic(1000);
				forceRedraw=true;
			}
		}
	}
}

void TitleScreenMenu::playmusic(){
	if(sound_enabled){
		if(playingMusic){
			currentSoundSetting = 0;
			if(Mix_PlayMusic(Mix, -1) == -1) {
				printf("Mix_PlayMusic: %s\n", Mix_GetError());
			}
		}
	}
	else printf("not playing music\n");
}

void TitleScreenMenu::filllevelIcon(SDL_Surface* image, LevelLoader::LevelSet set )
{
	LevelIcon* temp = new LevelIcon();
	temp->icon = image;
	temp->levelSet = set;
	levelIcons.push_back(temp);
}

void TitleScreenMenu::Init(){
	playmusic();
	MenuItem::Init();
}


