/*
 * TwoPlayerSetupScreen.cpp
 *
 *  Created on: 10 Dec 2009
 *      Author: math
 */

#include "TwoPlayerSetupScreen.h"

TwoPlayerSetupScreen::TwoPlayerSetupScreen(MenuItem* newParent) : MenuItem(newParent) {
	serverLevelSelect = new ServerLevelSelect(this);
	clientSetup = new ClientSetup(this);
	serverBox.x = 200;
	serverBox.w = 100;
	serverBox.y = 220;
	serverBox.h = 50;

	clientBox.x = 330;
	clientBox.w = 100;
	clientBox.y = 220;
	clientBox.h = 50;

}

TwoPlayerSetupScreen::~TwoPlayerSetupScreen() {
	delete(serverLevelSelect);
	delete(clientSetup);
}

void TwoPlayerSetupScreen::DrawSelf(SDL_Surface* screen){
	std::stringstream stream;
 	stream.clear();

 	if(forceRedraw){
 		forceRedraw = false;
		TileBackground(screen);

		stream.str("");
		stream << "Click on server or client";
		fontRenderer->RenderString(screen, stream.str(), 0,  serverBox.y-80, BLUE, CENTER);

		stream.str("");
		stream << "Server";
		fontRenderer->RenderString(screen, stream.str(), serverBox.x,  serverBox.y, BLUE, ABSOLUTE);

		stream.str("");
			stream << "Client";
			fontRenderer->RenderString(screen, stream.str(), clientBox.x,  clientBox.y, GREEN, ABSOLUTE);


		if(overserver)utility->DrawBox(screen,&serverBox, serverBox.x,serverBox.y);
		if(overclient)utility->DrawBox(screen,&clientBox, clientBox.x,clientBox.y);
 	}
}

void TwoPlayerSetupScreen::HandleKey(int k){
}

void TwoPlayerSetupScreen::HandleMouse(int mx,int my,long lb,long rb){
	overserver=false;
	overclient=false;
	if(mx > serverBox.x && mx < serverBox.x+serverBox.w &&
					my > serverBox.y && my < serverBox.y+serverBox.h) {
		overserver = true;
		forceRedraw=true;
	}
	else if(mx > clientBox.x && mx < clientBox.x+clientBox.w &&
			my > clientBox.y && my < clientBox.y+clientBox.h) {
		overclient = true;
		forceRedraw=true;
	}
	if(leftclick)
	{
		levelLoader->SetLevel(0);
		if(overserver){
			SetCurrentScreen(serverLevelSelect);
		}
		else if(overclient){
			SetCurrentScreen(clientSetup);
		}
	}
	else if(rb)
	{
		printf("setting to client setup screen\n");

	}
}

void TwoPlayerSetupScreen::Init(){
	MenuItem::Init();
}

