#ifndef FONT_REN_H_
#define FONT_REN_H_

#include "SDL/SDL.h"
#include "SDL/SDL_image.h"
#include "GraphicsUtility.h"
#include <string>
#include <iostream>

#define NUM_CHARS 94
#define NUM_DIGITS 10
#define FontHeight 32
#define FontWidth 18
#define DIGIT_WIDTH 10

enum FONT_COLOR
{
	RED,
	GREEN,
	BLUE,
	LIGHT_BLUE,
	PURPLE,
	BROWN
};

enum POSITION
{
	ABSOLUTE,
	CENTER	
};

class FontRenderer
{
	public:
		FontRenderer();
		~FontRenderer();
	
		void RenderString(SDL_Surface* surface, std::string, int,int,enum FONT_COLOR, enum POSITION);
		void RenderNumber(SDL_Surface* surface, std::string number, int xPos, int yPos);
		void Init();
	private:
		//Members
		SDL_Rect characters[NUM_CHARS];
		SDL_Rect digits[NUM_DIGITS];	
		SDL_Surface* fontMap;
		SDL_Surface* digittMap;
		GraphicsUtility *utility;

		//Functions
		SDL_Surface* load_image( std::string );
		void DrawChar(int, int, SDL_Surface*, SDL_Surface*, SDL_Rect*, enum FONT_COLOR);
};

#endif
