#ifndef GAME_H_
#define GAME_H_

#ifdef WIN32
	#include "SDL/SDL.h"
	#include "SDL/SDL_image.h"
	#include "SDL/SDL_net.h"
#else 
	#include "SDL/SDL.h"
	#include "SDL/SDL_image.h"
	#include "SDL/SDL_net.h"
#endif

#include "Lemming.h"
#include "lemmings_graphical_object.h"
#include "lemmings_level.h"
#include <string>
#include <iostream>
#include <vector>
#include "FontRenderer.h"
#include "GraphicsUtility.h"
#include "StatusPanel.h"
#include "LevelLoader.h"
#include "SamplePlayer.h"
#include "SpriteStore.h"
#include "Level.h"

#define IsServerLemming(x) ( ((x)%2) == 0 )

//final + 4 is for the current frame
#define BUFFER_SIZE max_num_lemmings*(3*4)
#define Y_OFFSET 8

/*
* this is basically where it all happens baby!
 */
class Game
{
	public:
		Game(int, int, int);
		~Game();

		void Pause();
		bool IsGameComplete();
		void Init(StatusPanel::GameType);
		bool ConnectToGame(StatusPanel::GameType Sender, std::string IPAddress);
		bool WaitForClientToConnect();
		bool CloseConnection();
		void AnimateFrame();
		bool WasGameWon();
		bool WasGameNuked();
		void Draw(SDL_Surface*);
		bool RequestForData();
		void HandleKey(int);
		void AddNewLemming();
		void SetMousePosition(int, int, long, long, long);
		void SetMouseClick(int, int, long);
		int GetPercentDone();
		SDL_Surface* GetLevelPreview();
		int LemmingsSavedPercent();
		int LemmingsNeededPercent();
		int TimeRemaining();
		void LoadLevel(LevelLoader*);
		void Load2PlayerLevel(LevelLoader*);
		void SetMusicOn();
		void SetMusicOff();
		void SetAllSoundOff();
		void ResetMultiplayer();
		int BlueHome();
		int GreenHome();
		StatusPanel::GameType GetGameType();

		int blueGamesWon, greenGamesWon;
		int blueGameMaxLems, greenGameMaxLems;
		int timeRemaining;
		Level* currentLevel;
	private:
		struct Offset
		{
			int x;
			int y;
		};

		//TODO: should be able to reduce this even further
		//as max single player lem is actually 80 (I.E. less than
		//256/2=128. So we should be able to use the
		//top 4 bits for 0-80 and the bottom 4 for state
		struct LemData
		{
			byte new_state;//0-8
			byte index;//0-160 (should be 0-80!!!!)
		};

		static const int data_transfer_size = 2;//TODO: get this down to 1!!
		static const int max_num_lemmings = 160;
		static const int min_multiplay_lemmings = 40;
		static const int lemming_arrived_home = -1;

		union ulemmings{Lemming* lemmings[max_num_lemmings]; byte b[103680];}ulemmings;
		int getDistanceToLemming(Lemming* l, int xp, int yp);
		int AnimateLemming(Lemming*);
		bool DoLemmingAction(LemData*, Lemming*, int);
		void LoadLevel(int, std::string, std::string);
		void DrawActionIcons(SDL_Surface*);
		void DrawLemmings(SDL_Surface*, SDL_Surface*);

		//private members:
		FontRenderer* fontRenderer;
		GraphicsUtility *utility;
		StatusPanel* statusPanel;
		SpriteStore* sprites;
		SamplePlayer* samples;
		Lemming* selectedSprite;
		LemData lemOutData;
		LemData lemInData;
		Mix_Music *levelTune;
		SDL_Surface* selectedIcon;
		SDL_Surface* screen;

		TCPsocket sd, csd; // Socket descriptor, Client socket descriptor
		int ticksSinceGameStart;
		int ticksSinceNukeClick;
		bool totalledUp;
		bool blueNuked, greenNuked;
		int blueOut, greenOut;
		int releasePoint;//the entrance the lemming is released at
		bool effects_only;
		bool music_now_on;
		u32 minReleaseRate;
		int screenWidth, screenHeight, framesPerSecond;
		StatusPanel::GameType gameType;
		bool connected;
		bool pause;
		bool nukeAll;
		short nukeCount;
		int debugMode;
		int releaseCounter;
		u32 numberReleased;
		int totalOut;
		u32 numHome;
		int mouseX, mouseY;
		int fpsCount;
};

#endif /*GAME_H_*/
