#ifndef UTILITY_H_
#define UTILITY_H_

/*#ifdef WIN32
	#include "SDL/SDL.h"
	#include "SDL/SDL_image.h"
#else */
	#include "SDL/SDL.h"
	#include "SDL/SDL_image.h"
//#endif

#include <string>
//#include <iostream>
#define FADE_MAX 8
#define NUM_CHARS 94

class GraphicsUtility
{
	public:
		GraphicsUtility();
		~GraphicsUtility();
	
		SDL_Surface* load_image( std::string filename );
		SDL_Surface* load_image_swap(std::string filename,  Uint32 color1,  Uint32 color2 );
		Uint32 getpixel(SDL_Surface *surface, int x, int y);
		void SetPixel(SDL_Surface *surface, int x, int y, Uint32 color);

		void apply_surface_hack( int x, int y, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip );
		void apply_surface( int x, int y, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip );
		void apply_surface( int x, int y, SDL_Surface* source, SDL_Surface* destination, SDL_Rect* clip, Uint32 color );

		void apply_surface_zoomed( int x, int y, SDL_Surface* source, SDL_Surface* destination, int zoom, int yoffset  );
		void apply_surface_zoomed( int x, int y, SDL_Surface* source, SDL_Surface* destination, int zoom);
		void apply_surface_zoomed( int x, int y, SDL_Surface* source, SDL_Surface* destination);

		void DrawBox(SDL_Surface *screen, int x, int y, int w, int h, Uint32 c);
		void DrawBox(SDL_Surface *screen, int x, int y, int w, int h);
		void DrawBox(SDL_Surface *screen, SDL_Rect* r, int x, int y);

	private:
		int s;
		SDL_Rect rect;//used for drawing the one pixel ting.
};

#endif
