/***********************************************************************
 * This is a Lemming, dunno why I didn't call it Lemming.cpp really... 
 * 
 * *********************************************************************/
#include "Lemming.h"

Vector2D* Lemming::gravity = new Vector2D();
short Lemming::fps = 20;
int Lemming::NoCanDo =  BLOCKER|FALLING|NUKE|SPLATTED|DROWNER|BURNER;
int explodeScale=100;//arrrgh, it's geting messy agina!
GraphicsUtility* Lemming::util = new GraphicsUtility();

void Lemming::ChangeDirection()
{
	//it was solid all the way up so turn around:
	if((state & GOING_LEFT) == GOING_LEFT)
	{
		state ^= GOING_LEFT;
		state |= GOING_RIGHT;
	}
	else
	{
		state ^= GOING_RIGHT;
		state |= GOING_LEFT;
	}	
}

Lemming::Lemming(int SpriteWidth, int SpriteHeight, int startX, int startY)
{	spriteW = SpriteWidth;
	spriteH = SpriteHeight;
	position = new Vector2D();
	position->SetX(startX);
	position->SetY(startY);
	playerNum = 1;
	SetState(DEAD);
	frame=explosionFrames=0;
	nukeCount = -2;
	stepping = 0;
	gravity->SetX(0);
	gravity->SetY(20);
	pingponganim=false;
	animInc=1;
}

Lemming::~Lemming()
{
	delete(position);
}

/*
 * This clears a lemming so he can turn back into a walker
 */
void Lemming::ClearLemming()
{
	if(state & FALLING) state ^= FALLING;
	if(state & DROWNER) state ^= DROWNER;
	if(state & WALKING) state ^= WALKING;
	if(state & BUILDER) state ^= BUILDER;
	if(state & BASHER) state ^= BASHER;
	if(state & DIGGER) state ^= DIGGER;
	if(state & BLOCKER) state ^= BLOCKER;
	if(state & MINER) state ^= MINER;
	if(state & DONE_BUILDING) state ^= DONE_BUILDING;
	if(state & EXPLODING) state ^= EXPLODING;
}

void Lemming::SetAlive(short x, short y)
{
	state = GOING_RIGHT;
	SetState(WALKING);
	SetState(FALLING);
	explosionFrames=0;
	position->SetX(x);
	position->SetY(y);
	inThisLemming = NULL;
	ohno_time=5001;//TODO: set const for this
}

/*
 * This checks if this lemming is blocked by the given lemming
 * if he is then set a flag to say he's in a block
 * but keep walking.
 * If he is not then if flag is on
 */
void Lemming::CheckForBlocker(Lemming* sprite)
{
	short cpX, cpY;
	//first is the given sprite a blocker and this is not a blocker
	if(sprite->GetState() & BLOCKER && !(GetState() & BLOCKER))
	{
		//make sure our lemming is not a blocker, that would be silly:

		cpY = position->GetY() + spriteH - 2;
		cpX = position->GetX();

		if(cpX >= sprite->GetX() - 4 && cpX <= sprite->GetX() + 4 &&
				cpY >= sprite->GetY() && cpY <= sprite->GetY() + GetHeight() + 4)
		{
			//stop whatever he's doing:
			if(state & BASHER){ state ^= BASHER; state |= WALKING;}
			if(state & MINER){ state ^= MINER; state |= WALKING;}
			if(state & DIGGER){ state ^= DIGGER; state |= WALKING;}
			if(state & BASHER){ state ^= BASHER; state |= WALKING;}

			//if 'inside' flag is off
			//then turn around,
			//if 'inside flag is on
			//then not keep walking
			if(inThisLemming == NULL)
			{
				//only change direction if w
				if(cpX > sprite->GetX() && (state & GOING_LEFT))
					ChangeDirection();
				else if(cpX < sprite->GetX() && (state & GOING_RIGHT))
					ChangeDirection();

				inThisLemming = sprite;
			}
		}
		else
		{
			//was he in THIS lemming
			if(inThisLemming == sprite)
			{
				//he WAS, now he's not so good
				inThisLemming = NULL;
			}
		}
	}
}

void Lemming::SetBurning()
{
	SetState(BURNER);
	if(state & NUKE) state ^= NUKE;
	nukeCount=-2;
}

void Lemming::SetDrowning()
{
	SetState(DROWNER);
	if(state & NUKE) state ^= NUKE;
	nukeCount=-2;
}

void Lemming::SetGoingHome()
{
	SetState(GOING_HOME);	
	if(state & GOING_RIGHT)
		position->SetX(position->GetX()-1);
	else
		position->SetX(position->GetX()+1);
	if(state & NUKE) state ^= NUKE;
	if(state & EXPLODING) state ^= EXPLODING;
	nukeCount=-2;
}

void Lemming::SetDead()
{
	SetState(DEAD);
}

void Lemming::SetToWalker()
{	
	SetState(WALKING);
}

bool Lemming::SetToBlocker()
{
	bool ret=false;
	if( !(state & FALLING) &&
		!(state & SPLATTED) &&
		!(state & BURNER) &&
		!(state & GOING_HOME) &&
		!(state & NOW_CLIMBING) &&
		!(state & STOPPED_CLIMBING) )
	{
		if(!(state & BLOCKER))
		{
			SetState(BLOCKER);
			ret =true;
		}
	}
	return ret;
}

bool Lemming::SetToNuke()
{
	bool ret=false;
	if(!(state & NUKE) && !(state & SPLATTED) && (state != DEAD) && !(state & BURNER) && !(state & GOING_HOME))
	{
		SetState(NUKE);
		ret = true;
	}
	return ret;
}

bool Lemming::SetToDigger()
{
	bool ret=false;
	if( !(state & BLOCKER) &&
		!(state & FALLING) &&
		!(state & NUKE) &&
		!(state & SPLATTED) &&
		!(state & BURNER) &&
		!(state & GOING_HOME) &&
		!(state & NOW_CLIMBING) &&
		!(state & STOPPED_CLIMBING) )
	{
		if(!(state & DIGGER))
		{
			SetState(DIGGER);
			ret = true;
		}
	}
	return ret;
}

bool Lemming::SetToMiner()
{
	bool ret=false;
	if( !(state & BLOCKER) &&
		!(state & FALLING) &&
		!(state & NUKE) &&
		!(state & SPLATTED) &&
		!(state & BURNER) &&
		!(state & GOING_HOME) &&
		!(state & NOW_CLIMBING) &&
		!(state & STOPPED_CLIMBING) )
	{
		if(!(state & MINER))
		{
			SetState(MINER);
			return true;
		}
	}
	return ret;
}

bool Lemming::SetToBasher()
{
	bool ret=false;
	if( !(state & BLOCKER) &&
		!(state & FALLING) &&
		!(state & NUKE) &&
		!(state & SPLATTED) &&
		!(state & BURNER) &&
		!(state & GOING_HOME) &&
		!(state & NOW_CLIMBING) &&
		!(state & STOPPED_CLIMBING) )
	{
		if(!(state & BASHER))
		{
			SetState(BASHER);
			ret = true;
		}
	}
	return ret;
}

bool Lemming::SetToFloater()
{
	bool ret=false;
	if( !(state & BLOCKER) && !(state & NUKE) && !(state & SPLATTED) && !(state & BURNER) && !(state & GOING_HOME))
	{
		if(!(state & FLOATER))
		{
			SetState(FLOATER);
			ret = true;
		}
	}
	return ret;
}

bool Lemming::SetToClimber()
{
	bool ret=false;
	if( !(state & BLOCKER) &&
		!(state & NUKE) &&
		!(state & SPLATTED) &&
		!(state & BURNER) &&
		!(state & GOING_HOME) &&
		!(state & STOPPED_CLIMBING) )
	{
		if(!(state & CLIMBER))
		{
			SetState(CLIMBER);
			ret = true;
		}
	}
	return ret;
}

bool Lemming::SetToBuilder()
{
	bool ret=false;
	if(!(state & NoCanDo) && !(state & NOW_CLIMBING) )
	{
		if(!(state & BUILDER))
		{
			SetState(BUILDER);
			ret = true;
		}
	}
	return ret;
}

bool Lemming::GetAliveState()
{
	return (state != DEAD);
}

int Lemming::GetState()
{
	return state;	
}

void Lemming::SetState(int newState)
{
	pingponganim=false;
	animInc=1;
	if(newState == DEAD)
	{
		state = DEAD;
	}
	else if(newState & WALKING)
	{
		if(!(state & WALKING))
		{
			ClearLemming();
			state |= WALKING;
			frame = animCount = fallDistance = 0;
			if(!(state & NUKE)) nukeCount = -2;
			frameMax = 7;
		}
	}
	else if(newState & DIGGER)
	{
		if(!(state & DIGGER))
		{
			ClearLemming();
			state |= DIGGER;
			frame = animCount = actionCount = 0;
			frameMax = 15;
		}
	}
	else if(newState & BUILDER)
	{
		if(!(state & BUILDER))
		{
			ClearLemming();
			state |= BUILDER;
			frameMax = 15;
			frame = animCount = blockBuiltCount = actionCount = 0;
		}
	}
	else if(newState & BLOCKER)
	{
		if(!(state & BLOCKER))
		{
			ClearLemming();
			state |= BLOCKER;
			frameMax = 15;
			frame = animCount = 0;
		}
	}
	else if(newState == DEAD)
	{
		frameMax = frame = 0;
		state = DEAD;
		nukeCount = -2;
	}
	else if(newState & BASHER)
	{
		if( !(state & BASHER) )
		{
			ClearLemming();
			state |= BASHER;
			frame = 0;
			frameMax = 31;
		}
	}
	else if(newState & MINER)
	{
		if(!(state & MINER))
		{
			ClearLemming();
			state |= MINER;
			frame = 0;
			frameMax = 23;
		}
	}
	else if(newState == SPLATTED)
	{
		if(!(state & SPLATTED))
		{
			ClearLemming();
			state |= SPLATTED;
			frame = 0;
			frameMax = 16;
		}
	}
	else if(newState & FALLING)
	{
		if(!(state & FALLING))
		{
			ClearLemming();
			state |= FALLING;
			fallDistance = frame = 0;
			frameMax = 3;
		}
	} 
	else if(newState & GOING_HOME)
	{
		if(!(state & GOING_HOME))
		{
			ClearLemming();
			state |= GOING_HOME;
			//state = newState;
			frame = 0;
			frameMax = 7;
		}
	}
	else if(newState & DROWNER)
	{
		if(!(state & DROWNER))
		{
			ClearLemming();
			state |= DROWNER;
			frame = 0;
			frameMax = 16;
		}
	}
	else if(newState & BURNER)
		{
			if(!(state & BURNER))
			{
				ClearLemming();
				state |= BURNER;
				frame = 0;
				frameMax = 16;
			}
		}
	else if(newState & NUKE)
	{
		if(!(state & NUKE))
		{
			state |= NUKE;
			nukeCount = Lemming::fps*5;	
		}	
	}
	else if(newState & DONE_BUILDING)
	{
		if(!(state & DONE_BUILDING))
		{
			ClearLemming();
			state |= DONE_BUILDING;
			frame = 0;
			frameMax = 7;
		}	
	}
	else if(newState & FLOATER)
	{
		state |= FLOATER;
	}
	else if(newState & CLIMBER)
	{
		state |= CLIMBER;
	}
}

int Lemming::GetRawNukeCount(){
	return nukeCount;
}

short Lemming::CountingDown()
{
	if(nukeCount != -2)
		return nukeCount/fps;
	else 
		return nukeCount;
}

int Lemming::GetFrame()
{
	return frame;
}

int Lemming::GetWidth()
{
	return 	spriteW;
}

int Lemming::GetHeight()
{
	return 	spriteH;
}

void Lemming::AnimateFrame()
{
	frame += animInc;

	if(pingponganim)
	{
		if(frame > frameMax || frame < 0)
		{
			animInc = -animInc;
			if(frame > frameMax)
				frame = frameMax;
			else
				frame = 0;
		}
	}
	else
	{
		if(frame > frameMax)
			frame = 0;
	}
}

bool Lemming::GetBuilderRunOut()
{
	return ((state & BUILDER) && frame == 9 && blockBuiltCount > MAX_BLOCK_BUILT-3 );
}

/*
 * Determines what state the lemming is in and then moves
 * on in the appropriate way.
 */
void Lemming::Move(SDL_Surface* background)
{
	//check nuke first and tick his counter on
	if(state & NUKE)
	{
		if(nukeCount > 0)
		{
			nukeCount--;
		}
		else if(nukeCount == 0)
		{
			state = NUKE;//just set him to nuke now
			frame = 0;
			frameMax = 16;
			nukeCount = -1;
		}
		else if(nukeCount == -1)
		{
			Nuke(background);
		}
	}

	if(state & EXPLODING)
	{
		Exploding();
	}
	else if(state & WALKING)
	{
		WalkerMove(background);
	}
	else if(state & DIGGER)
	{
		DigDown(background);
	}
	else if(state & BUILDER)
	{
		Build(background);
	}
	else if(state & BLOCKER)
	{
		if(!CheckFloor(0, 1,background))
		{
			state ^= BLOCKER;
			SetState(WALKING);
		}
	}
	else if(state & FALLING)
	{
		Falling(background);
	}
	else if(state & BASHER)
	{
		Bash(background);
	}
	else if(state & SPLATTED)
	{
		Splatter();
	}
	else if(state & DONE_BUILDING)
	{
		if(frame == 7)
		{
			SetToWalker();
		}
	}
	else if(state & NOW_CLIMBING)
	{
		Climb(background);
	}
	else if(state & STOPPED_CLIMBING)
	{
		if(frame == 7)
		{
			state ^= STOPPED_CLIMBING;
			SetState(WALKING);
			position->SetY(position->GetY() - 3);
			if(state & GOING_LEFT)
				position->SetX(position->GetX() - 2);
			else
				position->SetX(position->GetX() + 2);
		}
	}
	else if(state & GOING_HOME)
	{
		if(frame >= 7)
		{
			SetDead();
		}
	}
	else if(state & DROWNER)
	{
		if(frame >= 16)
		{
			SetDead();
		}
	}
	else if(state & BURNER)
		{
			if(frame >= 16)
			{
				SetDead();
			}
		}
	else if(state & MINER)
	{
		Mining(background);
	}
}

void Lemming::Splatter()
{
	if(frame == 15) state = DEAD;
}

/*
*
*/
void Lemming::Mining(SDL_Surface* background)
{
	if(frame == 0)
	{
		position->SetY(position->GetY() + 1);
	}
	else if(frame == 4)
	{
		position->SetX(position->GetX() + ((state & GOING_RIGHT) ? 1 : -1));
	}
	else if(frame == 15)
	{
		position->SetX(position->GetX() + ((state & GOING_RIGHT) ? 2 : -2));

		if( !CheckFloor(2, 2, background))
		{
			position->SetY(position->GetY()+1);
			state ^= MINER;
			SetState(WALKING);
		}
	}
	else if(frame == 2)
		position->SetX(position->GetX() + ((state & GOING_RIGHT) ? -1 : 1));
}

/*
 * This function is bloody horrible...very bad
 */
void Lemming::Bash(SDL_Surface* background)
{
	//bash a block (need a mask!!) away
	SDL_Rect rect;
	rect.y = position->GetY()+1;
	rect.w = 11;
	rect.h = 9;
	
	//Uint32 p;
	int cpX, cpY;

	//in the right direction:
	if(state & GOING_RIGHT)
	{
		rect.x = position->GetX();
	}
	else if(state & GOING_LEFT)
	{
		rect.x = position->GetX()-5;
	}
	//god awful hack
	if(frame == 11 ||frame == 12 || frame == 13 || frame == 14
		|| frame == 27 ||frame == 28 ||frame == 29 || frame == 30 )
	{
		int newX = position->GetX() + ((state & GOING_RIGHT) ? 1 : -1);
		position->SetX(newX);
		
		cpY = position->GetY() + spriteH/2;
		bool found = false;
		//now check along a line coming from the Lemmings middle point (yunno, like that bit in Donnie Darko?)
		for(int n = 0; n < 8; n++)
		{
			if(state & GOING_RIGHT)
			{
				cpX = position->GetX() /*+ spriteW +*/ + n;
			}
			else
			{
				cpX = position->GetX() - n - 6;
			}

			int newX = position->GetX() + ((state & GOING_RIGHT) ? 1 : -1);
			int newY = position->GetY() + spriteH + 1;

			if(util->getpixel(background, cpX, cpY) && util->getpixel(background, newX, newY))
			{
				found = true;
				break;
			}
		}	
		
		//we've just bashed, so check for wall area:
		if(!found)
		{
			state ^= BASHER;
			SetState(WALKING);
		}
	}
}

bool Lemming::FallingFarEnoughToOpenBrolly()
{
	return (fallDistance > MAX_FALL_BEFORE_BROLLY+1);
}

void Lemming::Falling(SDL_Surface* background)
{
	if((state & FLOATER))
	{
		if( fallDistance >= MAX_FALL_BEFORE_BROLLY+1)
		{
			//first open the brolly
			if( !(state & OPENING_BROLLY) )
			{
				if(fallDistance == MAX_FALL_BEFORE_BROLLY+1)
				{
					state |= OPENING_BROLLY;
					frame = 0;
					frameMax = 3;
					pingponganim=false;
				}
			}
			else
			{
				if(frame == frameMax)
				{
					state ^= OPENING_BROLLY;
					frame = 0;
					frameMax = 7;
					pingponganim = true;
					animInc = 1;
				}
			}
		
			position->SetY(position->GetY()+1);
			fallDistance++;

			if(util->getpixel(background, position->GetX() + 2, position->GetY() + spriteH) != 0)
			{
				state ^= FALLING;
				SetState(WALKING);
			}
		}
		else
		{
			for(int n = 1; n < 4; n++)
			{
				position->SetY(position->GetY()+1);
				fallDistance++;
				if(CheckFloor(0, 0, background))
				{
					position->SetY(position->GetY()-1);
					state ^= FALLING;
					SetState(WALKING);
					break;
				}
			}
		}
	}
	else
	{
		for(int n = 1; n < 4; n++)
		{
			position->SetY(position->GetY()+1);	
			fallDistance++;

			if(CheckFloor(0, 0, background))
			{
				if(fallDistance > MAX_FALL)
				{
					SetState(SPLATTED);
				}
				else
				{
					position->SetY(position->GetY()-1);
					state ^= FALLING;
					SetState(WALKING);
				}
				break;
			}
		}
	}
}

/*
 * This return a number indicating if the lemming has mined a portion 
 * of the screen
 */
int Lemming::Mined()
{
	//ensure he's a miner
	if(state & MINER)
	{
		//yep, he sure is!
		//what frame is he on
		if(frame == 0 || frame == 1 ||frame == 2 ||frame == 3)
		{
			return 1;
		}	
	}
	
	return 0;
}

/*
 * Candidate for complete implementation in a separate Graphics API
 * independent LemmingDrawer interface...
 * Also needs scaling up for a smoother, more cinematic type effect.
 */
int Lemming::DrawExplosion(SDL_Surface* screen, SDL_Rect* offset)
{
	SDL_Rect rect;
	rect.w = 1; rect.h = 1;
	Point* p;
	for(int n = 0; n < EXPLOSION_POINTS; n++)
	{
		p = &points[n];
		if(p->life)
		{
			rect.x = ((p->pos.GetX())/explodeScale) - offset->x;
			rect.y = ((p->pos.GetY())/explodeScale) - offset->y;
			if(rect.x >= 0 && rect.x <= 320*explodeScale && rect.y >= 0 && rect.y <= 200*explodeScale)
				SDL_FillRect( screen, &rect, p->color );
			else p->life=0;//out of screen, so kill point
		}
	}
	return explosionFrames;
}

bool Lemming::ShallIDrawExplosion()
{
	return explosionFrames == 1;
}

/*
 * Candidate for complete implementation in a separate Graphics API
 * independent LemmingDrawer interface...
 * Also needs scaling up for a smoother, more cinematic type effect.
 */
void Lemming::Exploding()
{
	SDL_Rect rect;
	rect.w = 1; rect.h = 1;
	Point* p;

	for(int n = 0; n < EXPLOSION_POINTS; n++)
	{
		p = &points[n];
		p->pos.Add(&p->vel);
		p->vel.Add(Lemming::gravity);
	}

	if(++explosionFrames > 90)
	{
		frame = explosionFrames = 0;
		SetState(DEAD);
	}
}

void Lemming::Nuke(SDL_Surface* background)
{
	int vel=350;
	if(frame == 16)
	{
		//now create the array of Points, randomly around the lemming
		//TODO: Ideally this would be the actually pixels of the lemming
		Point* p;
		for(int n = 0; n < EXPLOSION_POINTS; n++)
		{
			p = &points[n];
			p->pos.SetX( (position->GetX() + (rand() % 5) - 2)*explodeScale );
			p->pos.SetY( (position->GetY() + (rand() % 8)+8)*explodeScale );
			
			p->vel.SetX(0); p->vel.SetY(0);
			while(!p->vel.GetX()) p->vel.SetX( ((rand() % vel)-vel/2) );
			while(!p->vel.GetY()) p->vel.SetY( -( (rand() % vel*2)) );
			p->life = 1500 + (rand() % 10);
			p->color = SDL_MapRGB(background->format,rand()%256,rand()%256,rand()%256);
		}
		
		state = EXPLODING;
		explosionFrames = 0;
		frame = 17; //make sure no
		nukeCount=-3;
	}
}

void Lemming::Build(SDL_Surface* background)
{
	if(frame == 15)
	{
		if(state & GOING_LEFT)
		{
			position->SetX(position->GetX() - 2);
		}
		else
		{
			position->SetX(position->GetX() + 2);
		}

		//up a pixel
		position->SetY(position->GetY() - 1);

		if(blockBuiltCount == MAX_BLOCK_BUILT)
		{
			blockBuiltCount = 0;
			SetState(DONE_BUILDING);
		}
		else if(CheckHeadHit(background,  BUILDER))
		{
			blockBuiltCount = 0;	
		}
		else if(CheckNoBlockAhead(background))
		{
			blockBuiltCount = 0;
			state ^= BUILDER;
			SetState(WALKING);
			ChangeDirection();
		}
		
		//bit of a hack - frame isn't being reset at the right time?
		//This will probably fook up the network game...
		frame = 0;
	}
	else
	{
		if(frame == 9)
		{
			SDL_Rect block;
			block.w = spriteW;
			block.h = 1;
	
			block.y = position->GetY() + spriteH;

			if(state & GOING_LEFT)
				block.x = position->GetX() - 5;
			else
				block.x = position->GetX() + 1;

			//draw the actual block
			SDL_FillRect( background, &block, SDL_MapRGB( background->format, 0xFF, 0xFF, 0xFF ) );

			blockBuiltCount++;
		}
	}
}

/*
 * Dig straight down
 */
void Lemming::DigDown(SDL_Surface* background)
{
	SDL_Rect block;
	block.w = 9;
	block.h = 4;
	block.x = position->GetX() - 4;
	block.y = position->GetY() + 8;

	if(CheckFloor(0, 1, background) || CheckFloor(-4, 1, background) || CheckFloor(4, 1, background) || CheckFloor(8, 1, background))
	{
		//if(actionCount == 8 || actionCount == 16)
		if(GetFrame() == 8 || GetFrame()==15)
		{
			position->SetY(position->GetY() + 1);
		}
	}
	else
	{
		//take a chop anyway (as we don't know what frame it was on..
		position->SetY(position->GetY() + 1);

		//change back to walker
		state ^= DIGGER;
		SetToWalker();
	}
}

void Lemming::Climb(SDL_Surface* background)
{
	Uint32 p;
	int cpX, cpY;
	
	//move up
	position->SetY(position->GetY()-1);
		
	if(state & GOING_RIGHT)
	{
		cpX = position->GetX() + 1;
	}
	else
	{
		cpX = position->GetX() - 1;
	}
		
	cpY = position->GetY() + 2;

	p = util->getpixel(background, cpX, cpY);
	
	//there's something there
	if(!p)
	{
		position->SetY(position->GetY()-4);
		 position->SetX( position->GetX() + ((state&GOING_RIGHT)?-1:0) );
		//stop being a climber
		state ^= NOW_CLIMBING;
		state |= STOPPED_CLIMBING;
		frame=0;
	}
	else CheckHeadHit(background, NOW_CLIMBING);
}

bool Lemming::CheckHeadHit(SDL_Surface* background, int type)
{
	bool hit = false;
	//now check right above his head
	int cpX = position->GetX();
	int	cpY = position->GetY();
	if(util->getpixel(background, cpX, cpY))
	{
		state ^= type;
		SetState(WALKING);
		ChangeDirection();
		hit = true;
	}
	return hit;
}

/*
 *  Pass background and offset. Offset is the amount past the sprite to test
 *  ONLY USED IN BUILDER FUNCTION
 */
bool Lemming::CheckNoBlockAhead(SDL_Surface* background)
{
	Uint32 p;
	bool itsFree = false;
	
	//gonn clean this up someday


	if( CheckFloor(((state & GOING_RIGHT) ? 1 : -1), 0, background) ) //check one pixel ahead
	{
		//there's something there, check how much we need to step up
		
		int stepHeight = 0;
		bool bStopChecking = false;
		//now see how high the step is:
		for(int n=1; n < MAX_STEP_UP; n++)
		{
			//now check 1 pixel ahead and n pixels
			p = CheckFloor(((state & GOING_RIGHT) ? 1 : -1), -n, background);
			
			if(!p && !bStopChecking)
			{
				bStopChecking = true;
				stepHeight = n;
				break;
			}
		}
		
		if(stepHeight == 0 || stepHeight == MAX_STEP_UP-1)
		{
			if(state & CLIMBER && !(state & BUILDER))
			{
				state ^= WALKING; 
				state |= NOW_CLIMBING;
				frame=0;
			}
			else
				ChangeDirection();
		}
		else 
		{
			if(state & NOW_CLIMBING && !(state & BUILDER))
			{
				//stop climbing
				state ^= NOW_CLIMBING;
				state |= STOPPED_CLIMBING;
				frame=0;
			}
			else
			{
				position->SetY(position->GetY() - stepHeight);
			}
		}
		
		itsFree = true;
	}
	
	return itsFree;
}

/*
 * This checks if there is floor directly below the lemming
 * Returns true if there is and false otherwise
 */
bool Lemming::CheckFloor(int xo, int yOffset, SDL_Surface* background)
{
	//Get the position of the pixel we're checking
	int cpY = position->GetY() + spriteH + yOffset;
	return (util->getpixel(background, position->GetX()+xo, cpY) != 0);
}


/*
 * Continue walking in whatever direction the lemming is going
 * unless he falls off a cliff or hit a wall.
 */
void Lemming::WalkerMove(SDL_Surface* background)
{
	bool doneStepping;
    
    //get the next new X point:
	int newX = position->GetX() + ((state & GOING_RIGHT) ? 1 : -1);
	int newY = position->GetY() + spriteH;

	//next, check of that point is floor
	if(util->getpixel(background, newX, newY))//there is a pixel in the new spot
	{
		//so, next we know we need to step up 1 pixel
		newY -= 1;
		position->SetY(position->GetY()-1);
		//but is there a pixel above that pixel - this would mean a step up
		doneStepping=false;
		for(int stepUp = 1; !doneStepping && stepUp < 6; stepUp++)
		{
			if(!util->getpixel(background, newX, newY-stepUp))
			{
		      position->SetX(newX);
	          position->SetY(position->GetY()-(stepUp-1));
			  doneStepping = true;
			}
		}

		if(!doneStepping)
		{
		  //no stepping at all, so first move back down
		  if(state & CLIMBER)
		  {
			  position->SetY(position->GetY()+1);
			  state ^= WALKING;
			  state = state | NOW_CLIMBING;
			  frame=0;
		  }
		  else
		  {
			  position->SetY(position->GetY()+1);
			  ChangeDirection();
		  }
		}
		else
		{

		}
	}
	else//there is no pixel there, we must go down now whatever happens
	{
		//position->SetY(position->GetY()-1); WHY DONT WE NEED THIS?
		//but how far
		int stepDown=0;
		doneStepping = false;
		for(stepDown = 1; !doneStepping && stepDown < 6; stepDown++)
		{
			if(util->getpixel(background, newX, newY+stepDown))
			{
			  //we have a pixel to land on, stick lemmy there
			  position->SetX(newX);
			  position->SetY(position->GetY()+(stepDown-1));
			  doneStepping = true;
			}
		}

		if(!doneStepping)
	    {
		  if(stepDown == 6)//should we go to falling mode?
		  {
		  	SetState(FALLING);
		  	position->SetX(newX);
		  }
	    }
	}
}


bool Lemming::IsPointWithin(int x,int y)
{
	return (x >= position->GetX() - 8 && x <= position->GetX() + 10 &&
		    y >= position->GetY()-4 && y <= position->GetY() + GetHeight()+8);
}

int Lemming::getRadius()
{
	return spriteW/2;	
}

int Lemming::GetX()
{
	return position->GetX();
}

int Lemming::GetY()
{
	return position->GetY();
}

void Lemming::SetX(int x)
{
	position->SetX(x);	
}

void Lemming::SetY(int y)
{
	position->SetY(y);	
}


