#include "LevelLoader.h"
//#include <vector>
#include <string>
# include <dirent.h>
#include <cstdio>
#include <iostream>
#include <algorithm>

LevelLoader::LevelLoader()
{
	currentLevel=0;
	levelSet=Fun;
	max_songs=30;
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_cancan.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_lem1.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim2.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_lem2.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim8.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim3.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim5.xm"));
	songs.push_back(string("data/music/standard_ingame/doggie.mod"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim6.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_lem3.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim7.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim9.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim2.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim10.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim4.xm"));//level 15]
	songs.push_back(string("data/music/standard_ingame/tenlemmings.mod"));//level 16
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_mountain.xm"));

	songs.push_back(string("data/music/standard_ingame/lemming_amiga_cancan.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_lem1.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim2.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_lem2.xm"));
	//songs.push_back(string("music/standard_ingame/beasti.mod"));
	//songs.push_back(string("music/standard_ingame/LemEngine_Beast.mp3"));
	songs.push_back(string("data/music/standard_ingame/track_18.mod"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim3.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim5.xm"));
	songs.push_back(string("data/music/standard_ingame/doggie.mod"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim6.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_lem3.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim7.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim9.xm"));
	songs.push_back(string("data/music/standard_ingame/lemming_amiga_tim1.xm"));

	setupDone = false;
}

LevelLoader::~LevelLoader()
{

}

string LevelLoader::GetSong()
{
	if(currentLevel>=0)
	{
		return songs.at(currentLevel % (max_songs-1));
	}
	else
	{
		//this will never happen once I've removed the debug stuff
		//printf("getting song: %d", (max_songs + currentLevel));
		return songs.at(max_songs + currentLevel);
	}
}

string* LevelLoader::GetTwoPlayerLevel(int n)
{
	return &twoPlayerLevels.at(currentLevel);
}

string* LevelLoader::GetLevel()
{
	printf("getting level at %d", currentLevel);
	int maxlevel = 255;
	int n = currentLevel;

	if(n >= 0 && n < maxlevel )
	{
		n = n;//?!
	}
	else if(n < 0)
	{
		printf("n is %d\n", n);
		n = maxlevel - ((n*-1));
		printf("n is smaller than 0 trying to load: %d\n", n);
	}
	else if(n >= maxlevel )
	{
		n = n % maxlevel ;
		printf("n is smaller than 0 trying to load: %d\n", n);
	}

	return &levels.at(levelPositions.at((int)levelSet)+n);;
}

std::string LevelLoader::GetLevelSetName(){
	printf("level set name %s", levelSetNames.at((int)levelSet).c_str());
	return levelSetNames.at((int)levelSet);
}

void LevelLoader::Setup()
{
	if(!setupDone){
		count = 0;
		levelPositions.push_back(0);
		LoadSet("data/levels/1player/standard/Lems A - Fun/", "Fun");
		LoadSet("data/levels/1player/standard/Lems B - Tricky/", "Tricky");
		LoadSet("data/levels/1player/standard/Lems C - Taxing/", "Taxing");
		LoadSet("data/levels/1player/standard/Lems D - Mayhem/", "Mayhem");
		LoadSet("data/levels/1player/standard/Oh No A - Tame/", "Tame");
		LoadSet("data/levels/1player/standard/Oh No B - Crazy/", "Crazy");
		LoadSet("data/levels/1player/standard/Oh No D - Wicked/", "Wicked");
		LoadSet("data/levels/1player/standard/Oh No E - Havoc/", "Havoc");
		LoadSet("data/levels/1player/standard/Xmas 1991/", "Xmas 91");
		LoadSet("data/levels/1player/standard/Xmas 1992/", "Xmas 92");
		LoadSet("data/levels/1player/standard/Xmas A - Frost/", "Frost");
		LoadSet("data/levels/1player/standard/Xmas B - Hail/", "Hail");
		LoadSet("data/levels/1player/standard/Xmas C - Flurry/", "Flurry");
		LoadSet("data/levels/1player/standard/Xmas D - Blizzard/", "Blizzard");

		LoadTwoPlayerLevels("data/levels/2player/");
		sort(twoPlayerLevels.begin(), twoPlayerLevels.end());

		SetLevelSet(Fun);

		setupDone = true;
	}
}

void LevelLoader::LoadSet(const char *path, const char *name)
{
	string str = string(path);
	//first off, we need to create a pointer to a directory
	vector<string> temp;

    DIR *pdir = NULL; // remember, it's good practice to initialise a pointer to NULL!
    pdir = opendir (path); // "." will refer to the current directory

    struct dirent *pent = NULL;

    if (pdir == NULL) // if pdir wasn't initialised correctly
    { // print an error message and exit the program
        printf ("\nERROR! level directory could not be initialised correctly %s\n", path);
        return; // exit the function
    }

    while ((pent = readdir (pdir))) // while there is still something in the directory to list
    {
        if (pent == NULL) // if pent has not been initialised correctly
        { // print an error message, and exit the program
            printf ("\nERROR! pent could not be initialised correctly %s\n", path);
            return; // exit the function
        }
        str = path;
        str = str + pent->d_name;

        if(string(pent->d_name).length() > 3)
		{
        	temp.push_back(string(str));
        	count++;
        }
    }
    closedir (pdir);

    sort(temp.begin(), temp.end());

    for(int i = 0; i < temp.size(); i++)
    	levels.push_back(temp.at(i));

    levelPositions.push_back(levels.size());
    levelSetNames.push_back(string(name));
}


void LevelLoader::LoadTwoPlayerLevels(const char *path)
{
	string str = string(path);
	//first off, we need to create a pointer to a directory

    DIR *pdir = NULL; // remember, it's good practice to initialise a pointer to NULL!

    pdir = opendir (path); // "." will refer to the current directory

    struct dirent *pent = NULL;

    if (pdir == NULL) // if pdir wasn't initialised correctly
    { // print an error message and exit the program
        printf ("\nERROR! pdir could not be initialised correctly");
        return; // exit the function
    }
    int n=0;
    while ((pent = readdir (pdir))) // while there is still something in the directory to list
    {
        if (pent == NULL) // if pent has not been initialised correctly
        { // print an error message, and exit the program
            printf ("\nERROR! pent could not be initialised correctly");
            return; // exit the function
        }
        str = path;
        str = str + pent->d_name;

        if(n++ >= 0)
        {
        	if(string(pent->d_name).length() > 3)
        	{
        	twoPlayerLevels.push_back(string(str));
        	count++;
        	}
        }
    }
    // sort (levels.begin(), levels.end());
    // finally, let's close the directory
    closedir (pdir);
}

int LevelLoader::LevelCount()
{
	return 30;
}

void LevelLoader::SetLevel(int n){
	//currentLevel = levelPositions.at(levelSet)+n;
	currentLevel=n;
	printf("setting level %d\n", currentLevel);
}

int LevelLoader::SetLevelSet(int newLevel)
{
	if(newLevel>=0)
	{
		levelSet = (LevelSet)newLevel;
		//printf("set levelSet: %d\n",levelSet);
	}
	return 0;
}

void LevelLoader::NextLevel()
{
	currentLevel++;
}

void LevelLoader::PreviousLevel()
{
	if(currentLevel>0)
		currentLevel--;
}


