#ifndef LEVELLOADER_
#define LEVELLOADER_

#ifdef WIN32
#include "SDL/SDL.h"
#else 
#include "SDL/SDL.h"
#endif

#include "GraphicsUtility.h"
#include <vector>
#include <string>
using namespace std;

/*
 *
 */
class LevelLoader
{
public:
    enum LevelSet
    {
    	Fun = 0,
    	Tricky,
    	Taxing,
    	Mayhem,
    	Tame,
    	Crazy,
    	Wild,
    	Wicked,
    	Havoc,
    	Xmas1991,
    	Xmas1992,
    	XmasFrost,
    	XmasHail,
    	XmasFlurry,
    	XmasBlizzard,
    	MaxLevel
    };

	string* GetLevel();
	string* GetTwoPlayerLevel(int);
	void Setup();
	LevelLoader();
	~LevelLoader();
	int LevelCount();
	void NextLevel();
	void PreviousLevel();

	void SetLevel(int);
	int SetLevelSet(int);
	string GetSong();
	string GetLevelSetName();
	int currentLevel;
private:
	vector<string> levels;
	vector<string> twoPlayerLevels;
	vector<string> songs;
	vector<string> levelSetNames;
	void LoadSet(const char *path, const char *name);
	void LoadTwoPlayerLevels(const char *path);
	LevelSet levelSet;
	vector<int> levelPositions;
	int max_songs;
	int count;
	bool setupDone;
};
#endif
