#include "MainForm.h"
#include "Timer.h"
#include <iostream>
#include <string.h>

#include "SDL/SDL.h"
#include "SDL/SDL_mixer.h"

#include <sys/time.h>
#include <time.h>
#include <unistd.h>

MainForm::MainForm(const char* type, int new_width, int new_height, int zoom)
{
	game_type = type;
	Init(new_width, new_height, zoom);
}

MainForm::MainForm(int new_width, int new_height, int zoom)
{
	game_type = NULL;
	Init(new_width, new_height, zoom);
}

MainForm::~MainForm()
{

}

/*
 * This initiliases the form!
 */
bool MainForm::Init(int new_width, int new_height, int zoom)
{
	SCREEN_BPP = 32;
	width = new_width;
	height =  new_height;
	fullscreen = true;

	levelNumber = 0;

	//Initialise all SDL subsystems*
	if( SDL_Init( SDL_INIT_EVERYTHING ) == -1 )
    {
        return false;
    }

	screen = SDL_SetVideoMode( width, height, SCREEN_BPP, SDL_HWSURFACE |
														  (fullscreen ? SDL_FULLSCREEN : 0) /*|
														  SDL_DOUBLEBUF    */);

	//We're going to be requesting certain things from our audio
	//device, so we set them up beforehand
	int audio_rate = 44100;
	Uint16 audio_format = AUDIO_S16; // 16-bit stereo
	int audio_channels = 2;
	int audio_buffers = 1024;

	// This is where we open up our audio device.  Mix_OpenAudio takes
	// as its parameters the audio format we'd /like/ to have.
	if(Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers))
	{
		printf("Unable to open audio!\n");
	}
	Mix_VolumeMusic(50);
	Mix_Volume(1,40);
	SDL_ShowCursor(false);
	
    //If there was an error in setting up the screen
    if( screen == NULL )
        return false;
    
    //Set the window caption
    SDL_WM_SetCaption( "Lemmings SDL", NULL );
	
	gameMenu = new TitleScreenMenu(NULL, new_width, new_height);

    return true;
}

bool MainForm::MainLoop()
{
	int updateFPS = 1000 / 60;
	Timer fps;
	exitProgram = pause = false;

	SDL_Rect rect;
	rect.x = rect.y = 0;
	rect.w = width;
	rect.h = height;
	long diff = 0;
	int x, y;
	while(!exitProgram && gameMenu != NULL)
	{
		fps.start();
		handle_sdl_events();
		Uint8 buttons = SDL_GetMouseState(&x, &y);

		if(x > width) SDL_WarpMouse(width, y);
		if(y > height) SDL_WarpMouse(x, height);

		gameMenu = gameMenu->SetMouse(x, y, (buttons & SDL_BUTTON(1)), (buttons & SDL_BUTTON(3)));
		gameMenu->Draw(screen);

		//if ticks passed is LESS than our intended frame-rate then pause for a few ms
		diff = updateFPS - fps.get_ticks();
		SDL_Flip(screen);
		if( diff > 0 )
		{ 
			SDL_Delay( diff );
		}
	}
	delete(gameMenu);
	// This is the cleaning up part
	Mix_CloseAudio();
	SDL_Quit();
	return true;
}

/*
 * Horribly dull function dealing with keypresses and  
 * mouse twitches and other such bullshit.
 */
void MainForm::handle_sdl_events()
{
	upPressed = downPressed = leftPressed = rightPressed = escapePressed = nextLevel = false;
	spacePressed = enterPressed = mPressed = false;

	//While there's events to handle
    while( SDL_PollEvent( &event ) == 1)
    {
       //If the user has Xed out the window
       if( event.type == SDL_QUIT )
       {
         exitProgram = true;
       }
       
       if( event.type == SDL_KEYDOWN ) 
       {
    	   gameMenu->SetKey(event.key.keysym.sym);
	       	//Set the proper message surface 
	       	switch( event.key.keysym.sym ) 
	       	{ 
				case SDLK_UP:
	            	upPressed = true;
				break;

				case SDLK_DOWN:
					downPressed = true;
				break;

				case SDLK_LEFT:
					leftPressed = true;
				break;

				case SDLK_RIGHT:
					rightPressed = true;

				break;
	       		case SDLK_1:
	       			onePressed = true;
	       		case SDLK_2:
	       			twoPressed = true;
	       		break; 
	       		
	       		case SDLK_ESCAPE:
	       			escapePressed = true;
	       		 gameMenu = gameMenu->SendEscape();
	       		break;
	       		
	       		case SDLK_x:
	       			//exitProgram = true;
	       		break;
	       		
	       		case SDLK_p:
	       		//	game->Pause();
	       		break;
	       		
				case SDLK_m:
					mPressed = true;
				break;

				case SDLK_F11:
	       		case SDLK_f:
	       			fullscreen = !fullscreen;
	       			screen = SDL_SetVideoMode( width, height, SCREEN_BPP, SDL_HWSURFACE | (fullscreen ? SDL_FULLSCREEN : 0) /*| SDL_DOUBLEBUF*/ );
	       			SDL_WarpMouse(width/4, height/4);
	       		break;
	       		
				case SDLK_SPACE:
					spacePressed = true;
					break;

	       		case SDLK_RETURN:
					enterPressed = true;
					break;

				default:
	       		
	       		break;
	       	} 
       }
       if(exitProgram)
    	   for(int n=0; n<5; n++)
    	       gameMenu = gameMenu->SendEscape();
    }
}

//Unused
int MainForm::my_thread( ) 
{ 
	Timer fps; 
	
	//While the program is not over 
	int n = 10000;
	while( --n ) 
	{ 
		//Start the frame timer 
		fps.start(); 
	
	//	game->RequestForData();
	
		if( fps.get_ticks() < 1000 / 20 ) 
		{ 
			//SDL_Delay( ( 1000 / 20 ) - fps.get_ticks() );
		} 
	}
	
	return 0; 
}

//unused
void MainForm::runThread()
{
    SDL_CreateThread(&StaticThreadProcMy_thread,this);
}
