#ifndef MAINFORM_H_
#define MAINFORM_H_

#ifdef WIN32
#pragma warning(disable:4786)
#include "SDL/SDL.h"
#include "SDL/SDL_thread.h"
#else
#include "SDL/SDL.h"
#include "SDL/SDL_thread.h"
#endif
#include <vector>
//#include "MenuSystem.h"
#include "menuSystem/TitleScreenMenu.h"

using namespace std;

#define FRAMES_PER_SECOND 20

class MainForm
{
public:
	enum Game_Type
	{
		Server,
		Client	
	};
    MainForm(const char* type, int, int, int);
    MainForm(int, int, int);
	~MainForm();

	bool MainLoop();

private:
	bool sendLButton;
	bool upPressed, downPressed, leftPressed, rightPressed, escapePressed;
	bool onePressed, twoPressed;
	bool spacePressed, enterPressed;
	bool mPressed;
	bool pause;
	int levelNumber;
	bool exitProgram;
	bool nextLevel;
	bool fullscreen;
	//Screen attributes
	int SCREEN_BPP;
	int updateFPS;
	const char* game_type;
	//The surfaces
	SDL_Surface *screen;
	//The event structure
	SDL_Event event;
	bool leftButtonDown, rightButtonDown;
	MenuItem* gameMenu;
	int width, height;

	void handle_sdl_events();
	bool Init(int, int, int);
	int my_thread( );
	void runThread();
	static int StaticThreadProcMy_thread(void* pParam)
	{
    	return ((MainForm*)pParam)->my_thread();
	}
};

#endif /*MAINFORM_H_*/ 
