/*
 * SamplePlayer.h
 *
 *  Created on: 21 Oct 2009
 *      Author: math
 */

#ifndef SAMPLEPLAYER_H_
#define SAMPLEPLAYER_H_
#include "SDL/SDL_mixer.h"

#include <string>

enum Sample
{
	DOACTION = 0,
	CHANGEOP,
	BOING,
	SPLAT,
	OHNO,
	TING,
	EXPLODE,
	LETSGO,
	SPLASH,
	DOOR,
	DIE,
	CHINK,
	FIRE,
	MAX_SAMPLES
};
/*
 * This class is used for loading up the samples and playing them.
 * Why does it exist? Dunno, thought it would be neater having them in a
 * seperate class. Also, it could mean that I could re-implement
 * the sample player using somthing other than SDL_Mixer, without affecting the
 * main code.
 */
class SamplePlayer
{
public:
	SamplePlayer();
	~SamplePlayer();
	void PlaySample(Sample);
private:
	Mix_Chunk *samples[MAX_SAMPLES];
};

#endif /* SAMPLEPLAYER_H_ */
