/*
 * SpriteStore.h
 *
 *  Created on: 23 Jan 2010
 *      Author: mat
 */

#ifndef SPRITESTORE_H_
#define SPRITESTORE_H_

#include "SDL/SDL.h"
#include "SDL/SDL_image.h"
#include "GraphicsUtility.h"
#include "FontRenderer.h"
#include <vector>

class SpriteStore {
public:
	SpriteStore();
	virtual ~SpriteStore();
	void SetAnimations(const char* animFile);
	void DrawTestAnimationBlocks(SDL_Surface *screen);
	void DrawAnimations(SDL_Surface* screen);
	void TestFrame(int n);
	void TestSprite(int n);

	struct Offset
	{
		int x;
		int y;
	};
	struct AnimObject
	{
		SDL_Rect clip;
		Offset offset;
	};
	std::vector<AnimObject*> anims;

	//Animation clips:
	AnimObject walkerRight[ 8 ];
	AnimObject walkerLeft[ 8 ];
	AnimObject fallerLeft[ 4 ];
	AnimObject fallerRight[ 4 ];
	AnimObject diggerDowns[ 16 ];
	AnimObject basherRights[ 32 ];
	AnimObject basherLefts[ 32 ];
	AnimObject builderRights[ 16 ];
	AnimObject builderLefts[ 16 ];
	AnimObject blockers[ 16 ];
	AnimObject nukes[ 16 ];
	AnimObject minerRights[ 24 ];
	AnimObject minerLefts[ 24 ];
	AnimObject countDown[ 7 ];
	AnimObject splatters[ 16 ];
	AnimObject floaterRight[ 8 ];
	AnimObject floaterLeft[ 8 ];
	AnimObject openBrollyRight[ 4 ];
	AnimObject openBrollyLeft[ 4 ];
	AnimObject doneBuildingRights[ 8 ];
	AnimObject doneBuildingLefts[ 8 ];
	AnimObject climberRights[ 8 ];
	AnimObject climberLefts[ 8 ];
	AnimObject drowners[ 16 ];
	AnimObject burners[ 16 ];
	AnimObject stoppedClimbingRights[ 8 ];
	AnimObject stoppedClimbingLefts[ 8 ];
	AnimObject goingHomeRight[ 8 ];
	AnimObject goingHomeLeft[ 8 ];
	AnimObject explosion;
	AnimObject crossHair;
	AnimObject LemmingSelected;
	AnimObject bashLeftMasks[ 4 ];
	AnimObject bashRightMasks[ 4 ];
	AnimObject bang;

	SDL_Surface* player1Sprites;
	SDL_Surface* player2Sprites;
	SDL_Surface* cursors;
private:
	GraphicsUtility *utility;
	int spriteDebugY;
	int testAnim;
	int testSprite;
	FontRenderer* fonts;
};

#endif /* SPRITESTORE_H_ */
