#include "StatusPanel.h"
#include "Lemming.h"

/*
 * IconDisplay.cpp
 *
 *  Created on: 16 Oct 2009
 *      Author: math
 */

StatusPanel::StatusPanel(int newXpos, int newYpos, SamplePlayer* newSamples)
{
	samples = newSamples;
	utility = new GraphicsUtility();
	fontRenderer = new FontRenderer();
	fontRenderer->Init();
	levelOverview = NULL;
	iconBar = utility->load_image("data/graphics/amigaIcons.png");
	iconBarClient = utility->load_image_swap("data/graphics/amigaIcons.png",
												SDL_MapRGB(iconBar->format, 85, 51, 254),
												SDL_MapRGB(iconBar->format, 0, 186, 0));
	totalsImage = utility->load_image("data/graphics/TwoplayerTotals.png");

	xpos = newXpos;
	ypos = newYpos;
	tool_complement = NULL;
	viewport.x = viewport.y = 0;
	viewport.w = 320;
	viewport.h = 160;
	iconSelected = CLIMBER;
	sIconX = 64;
	selectedCount = 0;
}

StatusPanel::~StatusPanel()
{
	delete(utility);
	SDL_FreeSurface(iconBar);
	SDL_FreeSurface(iconBarClient);
	delete(fontRenderer);
	SDL_FreeSurface(levelOverview);
	SDL_FreeSurface(totalsImage);
}

void StatusPanel::SetGameMode(GameType new_type)
{
	type = new_type;
	printf("StatusPanel: setting mode %d\n", type);
	blueTotals.clear();
	greenTotals.clear();
}

int StatusPanel::BlueHome()
{
	return blueTotals.size();
}

int StatusPanel::GreenHome()
{
	return greenTotals.size();
}

void StatusPanel::AddToGreenTotal(GameType newOne)
{
	greenTotals.push_back(newOne);
}

void StatusPanel::AddToBlueTotal(GameType newOne)
{
	blueTotals.push_back(newOne);
}

int LEVEL_X_SIZE;
int LEVEL_Y_SIZE;

void StatusPanel::CreateOverviewImage(SDL_Surface* fullSizeLevel)
{
	int x,y;
	overviewRect.w = overviewRect.h = 1;
	LEVEL_X_SIZE = fullSizeLevel->w;
	LEVEL_Y_SIZE = fullSizeLevel->h;

	divx = fullSizeLevel->w/OVERVIEW_WIDTH;
	divy = fullSizeLevel->h/OVERVIEW_HEIGHT;

	if(levelOverview == NULL)
	{
		levelOverview = SDL_CreateRGBSurface (fullSizeLevel->flags,
									OVERVIEW_WIDTH,
									OVERVIEW_HEIGHT,
									fullSizeLevel->format->BitsPerPixel,
									fullSizeLevel->format->Rmask,
									fullSizeLevel->format->Gmask,
									fullSizeLevel->format->Bmask,
									fullSizeLevel->format->Amask);
	}
	else
	{
		//Clear the screen
		SDL_FillRect( levelOverview, &levelOverview->clip_rect, SDL_MapRGB( levelOverview->format, 0x00, 0x00, 0x00 ) );
	}

	for (y = 1; y < fullSizeLevel->h; y++)
	{
		overviewRect.y = y/divy;
		for (x = 1; x < fullSizeLevel->w; x++)
		{
			overviewRect.x = x/divx;
			if(utility->getpixel(fullSizeLevel, x, y))
			{
				if(overviewRect.x >=0 && overviewRect.x < OVERVIEW_WIDTH && overviewRect.y < OVERVIEW_HEIGHT && overviewRect.y >= 0)
					SDL_FillRect( levelOverview, &overviewRect, SDL_MapRGB(levelOverview->format,
							0,100,0));

			}
		}
	}
}

void StatusPanel::SetSelectedStatus(std::string type, int count)
{
	selectedType = type;
	selectedCount = count;
}

void StatusPanel::SetGameStats(int TimeRemaining, int TotalOut, int PercentHome, int Release_rate, std::vector<int>* counts, int MinReleaseRate)
{
	tool_complement = counts;
	minReleaseRate = MinReleaseRate;
	timeRemaining = TimeRemaining;
	totalOut = TotalOut;
	percentHome = PercentHome;
	release_rate = Release_rate;
	tool_complement = counts;
}

SDL_Rect r;
void StatusPanel::DrawMarker(int x,int y, SDL_Surface* screen)
{
	r.w=1;r.h=2;
	r.x = (xpos + x/divx + OVERVIEW_OFFSET_X )-1;
	r.y = (ypos + y/divy + OVERVIEW_OFFSET_Y + FontHeight)+1;

	//and draw a little dot on the overview window:
	if(levelOverview != NULL)
		SDL_FillRect( screen, &r, SDL_MapRGB(levelOverview->format, 200,200,0));
}

void StatusPanel::Draw(SDL_Surface* screen)
{
	if(type == SinglePlayer || type == Server )
		Draw(screen, iconBar);
	else if(type == Client)
		Draw(screen, iconBarClient);
}

void StatusPanel::Draw(SDL_Surface* screen, SDL_Surface* icons)
{
	//Draw the icons
	SDL_Rect r;
	r.w = screen->w;
	r.h = screen->h - ypos;
	r.x = xpos;
	r.y = ypos;

	//Clear the screen
	SDL_FillRect( screen, &r, SDL_MapRGB( screen->format, 0x00, 0x00, 0x00 ) );

	utility->apply_surface( xpos, ypos+FontHeight, icons, screen, NULL );

	//Draw Overview
	if(levelOverview != NULL)
		utility->apply_surface( xpos + OVERVIEW_OFFSET_X, ypos + OVERVIEW_OFFSET_Y + FontHeight, levelOverview, screen, NULL );
	//draw view port
	utility->DrawBox(screen, xpos + OVERVIEW_OFFSET_X + viewport.x/divx, ypos + FontHeight + OVERVIEW_OFFSET_Y + viewport.y/divy, viewport.w/divx, OVERVIEW_HEIGHT, SDL_MapRGB(screen->format, 0,187,0) );
	utility->DrawBox(screen, xpos + OVERVIEW_OFFSET_X + viewport.x/divx + 1, ypos + FontHeight + OVERVIEW_OFFSET_Y + viewport.y/divy - 1, viewport.w/divx, OVERVIEW_HEIGHT, SDL_MapRGB(screen->format, 0,187,0) );

	if(selectedCount > 0)
	{
		std::stringstream selectedLemming;
		selectedLemming << selectedType;
		if(selectedCount > 1) selectedLemming  << " " << selectedCount;
		fontRenderer->RenderString(screen, selectedLemming.str(), type == SinglePlayer ? 1 : 64, ypos, GREEN, ABSOLUTE);
	}

	int numPos = ypos + OVERVIEW_OFFSET_Y + FontHeight;

	//No time limit for multi-player
	//also, totals are graphical.
	if(type == SinglePlayer)
	{
		std::stringstream StrStream;
		StrStream << totalOut;

		std::string outCount = "OUT ";
		outCount += StrStream.str();
		fontRenderer->RenderString(screen, outCount, 200, ypos, GREEN, ABSOLUTE);

		std::stringstream numHomeStr;
		numHomeStr << "";
		if(percentHome == 0)
		{
			numHomeStr << "00";
		}
		else
		{
			if(percentHome < 10) numHomeStr << "0";
			numHomeStr << percentHome;
		}

		std::string inCount = "IN ";
		inCount += numHomeStr.str();
		inCount += "%";
		fontRenderer->RenderString(screen, inCount, 335, ypos, GREEN, ABSOLUTE);

		std::stringstream timeStream;
		timeStream.clear();
		timeStream << "TIME ";
		timeStream << timeRemaining/60;
		timeStream << "-";
		if(timeRemaining - (timeRemaining/60)*60 == 0)
			timeStream << "00";
		else if (timeRemaining - (timeRemaining/60)*60 < 10)
		{
			timeStream << "0";
			timeStream << timeRemaining - (timeRemaining/60)*60;
		}
		else timeStream << timeRemaining - (timeRemaining/60)*60;

		std::string timeLeft = timeStream.str();
		fontRenderer->RenderString(screen, timeLeft, 490, ypos, GREEN, ABSOLUTE);
	}

	std::stringstream numberStream;
	if(tool_complement != NULL)
	{
		int toolX = 69;
		for(int tool = 0; tool < 8; tool++)
		{
			if(tool_complement->at(tool) > 0)
			{
				numberStream.str("");
				if(tool_complement->at(tool) < 10)
					numberStream << "" << "0";

				numberStream << "" << (int)(tool_complement->at(tool));

				fontRenderer->RenderNumber(screen, numberStream.str(), toolX, numPos);
			}
			toolX += 32;
		}
	}

	numberStream.str("");
	if(release_rate < 10)
		numberStream  << "0";
	numberStream <<  (int)(release_rate);

	fontRenderer->RenderNumber(screen, numberStream.str(), 38, numPos);

	numberStream.str("");
	if(minReleaseRate < 10)
			numberStream  << "0";

	numberStream << (int)(minReleaseRate);
	fontRenderer->RenderNumber(screen, numberStream.str(), 8, numPos);

	//draw box over selected icon
	utility->DrawBox(screen, sIconX,  ypos+FontHeight, 32, 44);
	utility->DrawBox(screen, sIconX+1,  ypos+FontHeight+1, 30, 43);

	if(type != SinglePlayer)
	{
		//Clear the screen
		SDL_FillRect(screen, &totalsImage->clip_rect, 0);
		utility->apply_surface(0,5, totalsImage, screen, &totalsImage->clip_rect);

		SDL_Rect clip;

		//now each thingy
		clip.y = 305;
		clip.x = 14;
		clip.w = 15;
		clip.h = 2;
		for(unsigned int n = 0; n < blueTotals.size(); n++)
		{
			if(blueTotals[n] == StatusPanel::Server)
				SDL_FillRect(screen, &clip, SDL_MapRGB(totalsImage->format, 85, 51, 254));
			else
				SDL_FillRect(screen, &clip, SDL_MapRGB(totalsImage->format, 0, 186, 0));

			clip.y -= 2;
		}

		clip.y = 305;
		clip.x = 30;
		clip.w = 15;
		clip.h = 2;
		//now each thingy
		for(unsigned int n = 0; n < greenTotals.size(); n++)
		{
			if(greenTotals[n] == StatusPanel::Server)
				SDL_FillRect(screen, &clip, SDL_MapRGB(totalsImage->format, 85, 51, 254));
			else
				SDL_FillRect(screen, &clip, SDL_MapRGB(totalsImage->format, 0, 186, 0));

			clip.y -= 2;
		}
	}
}
void StatusPanel::SetSelectedIcon(int value)
{
	iconSelected = value;
	samples->PlaySample(CHANGEOP);
}

int StatusPanel::GetSelectedIcon()
{
	return iconSelected;
}

int StatusPanel::SelectIcon(int mouseX, int mouseY)
{
	if(mouseY > ypos+FontHeight)
	{
		if(mouseX > 354 && mouseX <= 354+32)
		{
			return 3;
		}
		else
		{
			if(mouseX > 324 && mouseX <= 324+32)
			{
				return -2;
			}
			else if(mouseX > 288 && mouseX <= 288+32)
			{
				SetSelectedIcon(DIGGER);
				sIconX = 288;
			}
			else if(mouseX > 256 && mouseX <= 256+32)
			{
				SetSelectedIcon(MINER);
				sIconX = 256;
			}
			else if(mouseX > 224 && mouseX <= 224+32)
			{
				SetSelectedIcon(BASHER);
				sIconX = 224;
			}
			else if(mouseX > 192 && mouseX <= 192+32)
			{
				SetSelectedIcon(BUILDER);
				sIconX = 192;
			}
			else if(mouseX > 160 && mouseX <= 160+32)
			{
				SetSelectedIcon(BLOCKER);
				sIconX = 160;
			}
			else if(mouseX > 128 && mouseX < 128+32)
			{
				SetSelectedIcon(NUKE);
				sIconX = 128;
			}
			else if(mouseX > 96 && mouseX <= 96+32)
			{
				SetSelectedIcon(FLOATER);
				sIconX = 96;
			}
			else if(mouseX > 64 && mouseX <= 64+32)
			{
				SetSelectedIcon(CLIMBER);
				sIconX = 64;
			}
		}
	}
	return iconSelected;
}

void StatusPanel::UpdateOverviewOffset(int mouseX, int mouseY)
{
	if(mouseY > ypos+FontHeight)
	{
		if(mouseX >= OVERVIEW_OFFSET_X && mouseY >= OVERVIEW_OFFSET_Y
				&& mouseX >= OVERVIEW_OFFSET_X)
		{
			//now check the arrow is within the current
			viewport.x = ((mouseX - viewport.w/(LEVEL_X_SIZE/OVERVIEW_WIDTH)/2)-OVERVIEW_OFFSET_X )*(LEVEL_X_SIZE/OVERVIEW_WIDTH);
			if(viewport.x < 0)
				viewport.x = 0;
			if(viewport.x > LEVEL_X_SIZE - 320)
				viewport.x = LEVEL_X_SIZE - 320;
		}
	}
}
