#include "Vector2D.h"
#include <cmath>


int Vector2D::GetX()
{
	return x;	
}

int Vector2D::GetY()
{
	return y;	
}

void Vector2D::SetX(int newX)
{
	x = newX;	
}

void Vector2D::SetY(int newY)
{
	y = newY;	
}

void Vector2D::Add(Vector2D* vector)
{
	x += vector->GetX();
	y += vector->GetY();
}

Vector2D Vector2D::Subtract(Vector2D* vector)
{
	Vector2D v;
	v.SetX(x -= vector->GetX());
	v.SetY(y -= vector->GetY());
	return v;
}

int Vector2D::Dot(Vector2D* vector)
{
	int retVal = 0;
	
	retVal = vector->GetX()*x + vector->GetY()*y;
	
	return retVal;
}

int Vector2D::GetLength()
{
	int retVal;
	
	retVal = sqrt( x*x + y*y );
	return  retVal;	
}

Vector2D Vector2D::Multiply(int m)
{
  Vector2D v;
  v.SetX(x * m);
  v.SetY(y * m);
  return v;
}

Vector2D Vector2D::Normalize()
{
  Vector2D v;
  v.SetX(x);
  v.SetY(y);
  int length = v.GetLength();
  v.SetX(v.GetX()/length);
  v.SetY(v.GetY()/length);
  return v;
}