/*
 * ClientGameScreen.cpp
 *
 *  Created on: 21 Dec 2009
 *      Author: mat
 */

#include "ClientGameScreen.h"

ClientGameScreen::ClientGameScreen(MenuItem* momma) : OnePlayerGameScreen(momma) {
	gameOverScreen = new MultiplayerGameOverScreen(momma);
}

ClientGameScreen::~ClientGameScreen() {
	delete(gameOverScreen);
}

void ClientGameScreen::DrawSelf(SDL_Surface* screen){
	if(leftclick) sendClick = true;
	if(frameCount == game_frame_mult){
		game->SetMouseClick(mouse_x, mouse_y, sendClick);
		if(scrlock() && !game->RequestForData()){
			SetCurrentScreen(gameOverScreen);
		}
		game->AnimateFrame();
		frameCount = 0;
		forceRedraw = true;
		sendClick = false;
	}
	else{
		frameCount++;
	}

	if(forceRedraw)
		game->Draw(screen);
}


MenuItem* ClientGameScreen::SendEscape() {
	this->Reset();
	return SetCurrentScreen(gameOverScreen);
}

void ClientGameScreen::Init(){
	OnePlayerGameScreen::Init();
}
