/*
 * ClientLevelSelect.cpp
 *
 *  Created on: 21 Dec 2009
 *      Author: mat
 */

#include "ClientLevelSelect.h"
bool enteringIP;
ClientLevelSelect::ClientLevelSelect(MenuItem* daddy) : MenuItem(daddy) {
	cursPosX=0;
	clientGameScreen = new ClientGameScreen(this);
	connected = tryToConnect = false;
}

ClientLevelSelect::~ClientLevelSelect() {
	delete(clientGameScreen);
}

void ClientLevelSelect::DrawSelf(SDL_Surface* screen){
	std::stringstream stream;
	stream.clear();

	TileBackground(screen);

	int xPos = 180;
	int yPos = 180;
	int h = 32;

	DrawLevelPreview(screen);

	stream << "Level " << levelLoader->currentLevel+1;
	fontRenderer->RenderString(screen, stream.str(), 1, yPos-32, RED, ABSOLUTE);

	stream.str("");
	stream << game->currentLevel->GetLevelName();
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos-32, RED, ABSOLUTE);

	stream.str("");
	stream << "      Blue  Player has " << game->blueGameMaxLems << " Lemmings " ;
	fontRenderer->RenderString(screen, stream.str(), 10, yPos+=h, BLUE, ABSOLUTE);

	stream.str("");
	stream << "(you) Green Player has " << game->greenGameMaxLems << " Lemmings " ;
	fontRenderer->RenderString(screen, stream.str(), 10, yPos+=h, GREEN, ABSOLUTE);

	stream.str("");
	stream << "Release Rate " << game->currentLevel->GetReleaseRate();
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos+=h, BROWN, CENTER);

	if(tryToConnect){
		fontRenderer->RenderString(screen, "Trying to connect to server...", 40, 400-FontHeight-2, BLUE, CENTER);
		if(!connected){
			printf("client about to connect: %s\n",ipaddress.c_str());
			connected = game->ConnectToGame(StatusPanel::Client, ipaddress.c_str());
		}
	}else
		fontRenderer->RenderString(screen, "Press left button to start", 40, 400-FontHeight-2, BLUE, CENTER);

	if(connected)
	{
		printf("client trying to set game screen\n");
		SetCurrentScreen(clientGameScreen);
	}
}

void ClientLevelSelect::Init(){
	game->Load2PlayerLevel(levelLoader);
	game->Init(StatusPanel::Client);
	connected = false;
	tryToConnect = false;
	MenuItem::Init();
}

void ClientLevelSelect::HandleKey(int k){
	if(k==SDLK_RETURN || k==SDLK_SPACE){
		tryToConnect = true;
	}
}

void ClientLevelSelect::HandleMouse(int x,int y ,long lb,long rb){
	if(leftclick){
		tryToConnect = true;
	}
}
