/*
 * MenuItem.cpp
 *
 *  Created on: 10 Dec 2009
 *      Author: mat
 */

#include "MenuItem.h"

GraphicsUtility* MenuItem::utility = new GraphicsUtility();
FontRenderer* MenuItem::fontRenderer = NULL;
LevelLoader* MenuItem::levelLoader = NULL;
SDL_Surface* MenuItem::hand = NULL;
SDL_Surface* MenuItem::background = NULL;
bool MenuItem::playingMusic = true;
Mix_Music* MenuItem::Mix = NULL;
int MenuItem::currentLevelSet = 0;
unsigned int MenuItem::currentSoundSetting = 0;
Game* MenuItem::game = NULL;
int MenuItem::screen_width = 320;
int MenuItem::screen_height = 200;
bool MenuItem::leftclick = false;
bool MenuItem::leftButtonDown = false;
MenuItem* MenuItem::home = NULL;
MenuItem* MenuItem::plevelSelect = NULL;
MenuItem* MenuItem::multiplayerLevelSelect = NULL;
int MenuItem::game_frame_mult = 2;
SDL_Surface* MenuItem::temp = NULL;
MenuItem* MenuItem::nextMenuItemObject  = NULL;
int MenuItem::fadingOut = 0;
int MenuItem::fadingIn = 0;
bool MenuItem::forceRedraw = false;
int MenuItem::mouse_x = 0;
int MenuItem::mouse_y = 0;
std::string  MenuItem::ipaddress;

MenuItem::MenuItem(MenuItem* newParent) {
	if(home == NULL) home = this;
	parent = newParent;
	currentMenuItemObject = this;
	leftclick = false;
	drawhand=true;
	fadingOut = 256;
	fadingIn = 255;
}

MenuItem::MenuItem(MenuItem* newParent, int new_width, int new_height) {
	if(home == NULL) home = this;
	currentMenuItemObject = this;
	parent = newParent;
	drawhand = true;
	leftclick = false;
	fadingOut = 256;
	fadingIn = 255;
	screen_width = new_width;
	screen_height = new_height;
	leftButtonDown = false;

	if (Mix == NULL)
		Mix = Mix_LoadMUS("data/music/track13Remix.mp3");

	if (background == NULL)
		background = utility->load_image(
				"data/graphics/lemmings_background_fs.png");

	if (hand == NULL)
		hand = utility->load_image("data/graphics/hand.bmp");

	if (game == NULL) {
		game = new Game(new_width / 2, new_height / 2, 25);
		printf("created a new game\n");
	}

	if (levelLoader == NULL) {
		levelLoader = new LevelLoader();
		levelLoader->Setup();
	}

	if (fontRenderer == NULL) {
		fontRenderer = new FontRenderer();
		fontRenderer->Init();
	}
}

MenuItem::~MenuItem() {
	if(parent != NULL) delete(parent);
	delete (utility);
	delete (fontRenderer);
	SDL_FreeSurface(background);
	SDL_FreeSurface(hand);
}

void MenuItem::TileBackground(SDL_Surface* screen) {
	utility->apply_surface_zoomed(0, 0, background, screen);
}

/*
 * Draws the screen calls virtual draw then
 */
void MenuItem::Draw(SDL_Surface* screen) {

	/*THIS NEEDS MOVING*/
	if(temp == NULL)
	{
		temp = SDL_CreateRGBSurface (screen->flags,
	                                screen->w,
	                                screen->h,
	                                screen->format->BitsPerPixel,
	                                screen->format->Rmask,
	                                screen->format->Gmask,
	                                screen->format->Bmask,
	                                screen->format->Amask);
	}

	DrawSelf(screen);

	//fading in or out or not?
	if(fadingOut < 256)
	{
		forceRedraw = true;
		SDL_SetAlpha(temp, SDL_SRCALPHA, fadingOut);
		SDL_BlitSurface( temp, NULL, screen, &screen->clip_rect);
		fadingOut += FADE_SPEED;
		if(fadingOut >= 255)
		{
			fadingOut = 256;
			fadingIn = 255;
			if(nextMenuItemObject != NULL)
			{
				currentMenuItemObject = nextMenuItemObject;
				nextMenuItemObject = NULL;
			}
		}
	}
	else if(fadingIn > 0)
	{
		forceRedraw = true;
		//printf("dafind in\n");
		//fade out current screen
		SDL_SetAlpha(temp, SDL_SRCALPHA, fadingIn);
		SDL_BlitSurface( temp, NULL, screen, &screen->clip_rect);

		fadingIn -= FADE_SPEED;
		if(fadingIn <= FADE_SPEED)
		{
			fadingIn = -FADE_SPEED;
			fadingOut = 256;
		}
	}
	else forceRedraw = false;

	if (drawhand)
		utility->apply_surface(mouse_x, mouse_y, hand, screen, NULL);
}

MenuItem* MenuItem::SetCurrentScreen(MenuItem* item){
	if(scrlock())
	{
		nextMenuItemObject = item->Reset();
		fadingOut = 0;
		fadingIn = 0;
	}
	return this;
}

MenuItem* MenuItem::SendEscape() {
	if(scrlock())
	{
		this->Reset();
		return SetCurrentScreen(parent);
	}
	else return this;
}

bool MenuItem::scrlock(){
	return !(fadingOut < 256 || fadingIn > 0);
}

MenuItem* MenuItem::SetMouse(int x, int y, int leftdown, int rightdown) {
	leftclick = false;
	mouse_x = x;
	mouse_y = y;

	if (leftdown && scrlock()) {
		//but was it before?
		if (!leftButtonDown) {
			//no, it wasn't, we can send it
			leftclick = leftButtonDown = true;
		}
	} else {
		//button not, down
		leftButtonDown = false;
	}

	HandleMouse(x,y,leftdown,rightdown);

	return currentMenuItemObject;
}

bool MenuItem::SetKey(int k) {
	if(scrlock()){
		HandleKey(k);
	}
	return true;
}

void MenuItem::Init() {
}

void MenuItem::DrawLevelPreview(SDL_Surface* screen)
{
	SDL_Surface* preview = game->GetLevelPreview();
	if(preview != NULL){
		SDL_Rect blu;
		blu.h = preview->clip_rect.h + 40;
		blu.w = preview->clip_rect.w;
		blu.x = blu.y = 0;
		SDL_FillRect(screen, &blu, SDL_MapRGB(screen->format, 0x00, 0x00, 0x33));
		utility->apply_surface(0, 25, preview, screen, NULL);
	}
}

MenuItem* MenuItem::Reset(){
	currentMenuItemObject = this;
	Init();
	return this;
}




