/*
 * MenuItem.h
 *
 *  Created on: 10 Dec 2009
 *      Author: mat
 */

#ifndef MENUITEM_H_
#define MENUITEM_H_

#ifdef WIN32
#include "SDL/SDL.h"
#else
#include "SDL/SDL.h"
#endif

#include "SDL/SDL_mixer.h"
#include "../GraphicsUtility.h"
#include "../FontRenderer.h"
#include "../LevelLoader.h"
#include <vector>
#include <sstream>
#include "../Game.h"

using namespace std;

#define DRAW_SELF -1
#define FADE_SPEED 20

class MenuItem {
public:
	MenuItem(MenuItem*);
	MenuItem(MenuItem*, int, int);
	virtual ~MenuItem();

	void Draw(SDL_Surface*);
	MenuItem* SetMouse(int, int, int, int);
	bool SetKey(int);
	virtual void Init();
	virtual MenuItem* SendEscape();
	MenuItem* Reset();

	static LevelLoader* levelLoader;
protected:
	virtual void DrawSelf(SDL_Surface*) = 0;
	virtual void HandleKey(int) = 0;
	virtual void HandleMouse(int, int, long, long) = 0;

	int AddMenuItem(MenuItem* item);
	void TileBackground(SDL_Surface*);
	MenuItem* SetCurrentScreen(MenuItem* item);
	void DrawLevelPreview(SDL_Surface*);
	bool scrlock();
	static int mouse_x;
	static int mouse_y;
	static bool leftclick;
	bool drawhand;
	MenuItem* parent;

	static GraphicsUtility* utility;
	static FontRenderer* fontRenderer;
	static bool playingMusic;
	static Mix_Music *Mix;
	static int currentLevelSet;
	static unsigned int currentSoundSetting;
	static int screen_width;
	static int screen_height;
	static Game* game;
	static SDL_Surface* background;
	static SDL_Surface* temp;
	static bool forceRedraw;
	static SDL_Surface* hand;
	static MenuItem* home;
	static MenuItem* plevelSelect;
	static MenuItem* multiplayerLevelSelect;
	static int game_frame_mult;
	static MenuItem* nextMenuItemObject;
	static std::string ipaddress;
private:
	static bool leftButtonDown;
	static int fadingOut;
	static int fadingIn;
	MenuItem* currentMenuItemObject;

};

#endif /* MENUITEM_H_ */
