/*
 * ClientGameOverScreen.cpp
 *
 *  Created on: 22 Dec 2009
 *      Author: math
 */

#include "MultiplayerGameOverScreen.h"

MultiplayerGameOverScreen::MultiplayerGameOverScreen(MenuItem* momma) : MenuItem(momma) {

}

MultiplayerGameOverScreen::~MultiplayerGameOverScreen() {

}

void MultiplayerGameOverScreen::DrawSelf(SDL_Surface* screen){
	std::stringstream stream;
	stream.clear();

	TileBackground(screen);

	int xPos = 70;
	int yPos = 0;
	int h = 32;

	stream.str("");
	stream << "All lemmings accounted for.";
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos, RED, CENTER);

	yPos+=h;
	yPos+=h;

	stream.str("");
	stream << "Blue player rescued ";
	stream << blueHome;
	stream << " Lemmings";
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos, BLUE, ABSOLUTE);

	yPos+=h;

	stream.str("");
	stream << "Green player rescued ";
	stream << greenHome;
	stream << " Lemmings";
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos, GREEN, ABSOLUTE);

	yPos+=h;
	yPos+=h;

	stream.str("");
	stream << "Blue player has won ";
	stream << game->blueGamesWon;
	stream << " games";
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos, BLUE, ABSOLUTE);

	yPos+=h;
	stream.str("");
	stream << "Green player has won ";
	stream << game->greenGamesWon;
	stream << " games";
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos, GREEN, ABSOLUTE);

	yPos+=h;
	yPos+=h;
	stream.str("");
	if(blueHome != greenHome){
		if(game->WasGameWon()) {
			stream << "You won that round dude!";
			if(blueHome > greenHome)
				fontRenderer->RenderString(screen, stream.str(), xPos, yPos, BLUE, CENTER);
			else
				fontRenderer->RenderString(screen, stream.str(), xPos, yPos, GREEN, CENTER);
		}
		else{
			stream << "You lost that round. Loser!";
			if(blueHome < greenHome)
				fontRenderer->RenderString(screen, stream.str(), xPos, yPos, BLUE, CENTER);
			else
				fontRenderer->RenderString(screen, stream.str(), xPos, yPos, GREEN, CENTER);
		}
	}
	else{
		stream << "You both lose. The round was a draw!";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos, RED, CENTER);
	}


	stream.str("");
	stream << "Press mouse button to continue";
	fontRenderer->RenderString(screen, stream.str(), xPos,  400 - FontHeight - 2, BROWN, CENTER);
}

void MultiplayerGameOverScreen::HandleKey(int k){
	if(k == SDLK_RETURN || k == SDLK_SPACE)
		SetCurrentScreen(parent);
}

void MultiplayerGameOverScreen::HandleMouse(int mx,int my, long lb,long rb){
	if(leftclick)
		SetCurrentScreen(parent);
}

MenuItem* MultiplayerGameOverScreen::SendEscape(){
	SetCurrentScreen(parent);
	return this;
}

void MultiplayerGameOverScreen::Init(){
	Mix_FadeOutMusic(500);
	blueHome = game->BlueHome();
	greenHome = game->GreenHome();
	levelLoader->NextLevel();
	MenuItem::Init();
}

