/*
 * OnePlayerGameOver.cpp
 *
 *  Created on: 17 Dec 2009
 *      Author: math
 */

#include "OnePlayerGameOver.h"

OnePlayerGameOver::OnePlayerGameOver(MenuItem* newParent) : MenuItem(newParent) {
}

OnePlayerGameOver::~OnePlayerGameOver() {
}

/*
 * only update screen every 3 frames to get correct fps
 */
void OnePlayerGameOver::DrawSelf(SDL_Surface* screen){
	std::stringstream stream;
	stream.clear();

	TileBackground(screen);

	int xPos = 90*2;
	int yPos = 0;
	int h = 32;

	if(timeLeft > 0)
	{
		stream.str("");
		stream << "All lemmings accounted for.";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos, LIGHT_BLUE, CENTER);
	}
	else
	{
		stream.str("");
		stream << "Your time is up!";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos, LIGHT_BLUE, CENTER);
	}

	stream.str("");
	stream << "You needed  ";
	stream << lemsNeeded << "%";
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos+2*h, PURPLE, CENTER);

	stream.str("");
	stream << "You rescued ";
	stream << percentDone << "%";
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos+3*h, PURPLE, CENTER);

	if(percentDone == 100)
	{
		stream.str("");
		stream << "Superb! you rescued every lemming on";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos+5*h, RED, CENTER);
		stream.str("");
		stream << "that level. Can you do it again?";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos+6*h, RED, CENTER);
	}
	else if(percentDone == 0)
	{
		stream.str("");
		stream << "ROCK BOTTOM! I hope for your sake";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos+5*h, RED, CENTER);
		stream.str("");
		stream << "that you nuked that level";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos+6*h, RED, CENTER);
	}
	else if(percentDone > lemsNeeded)
	{
		stream.str("");
		stream << "You totally stormed that level!";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos+5*h, RED, CENTER);
		stream.str("");
		stream << "let's see if you can storm the next.";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos+6*h, RED, CENTER);
	}
	else if(percentDone == lemsNeeded)
	{
		stream.str("");
		stream << "SPOT ON. You can't get much closer";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos+5*h, RED, CENTER);
		stream.str("");
		stream << "than that. Let's try the next....";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos+6*h, RED, CENTER);
	}
	else
	{
		stream.str("");
		stream << "You failed in your quest";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos+5*h, RED, CENTER);
		stream.str("");
		stream << "sort your life out mate.";
		fontRenderer->RenderString(screen, stream.str(), xPos, yPos+6*h, RED, CENTER);
	}

	if(timeLeft == 0 || percentDone < lemsNeeded)
	{
		stream.str("");
		stream << "Press left button to try again";
		fontRenderer->RenderString(screen, stream.str(), xPos,  400 - FontHeight*2 - 2, BLUE, CENTER);
		stream.str("");
		stream << "Press right button for menu";
		fontRenderer->RenderString(screen, stream.str(), xPos,  400 - FontHeight - 2, BLUE, CENTER);
	}
	else
	{
		stream.str("");
		stream << "Press mouse button to continue";
		fontRenderer->RenderString(screen, stream.str(), xPos,  400 - FontHeight - 2, BLUE, CENTER);
	}
}

void OnePlayerGameOver::HandleKey(int k){
	if(k == SDLK_RETURN || k == SDLK_SPACE)
		SetCurrentScreen(plevelSelect);
}

void OnePlayerGameOver::HandleMouse(int mx,int my, long lb,long rb){
	if(leftclick && plevelSelect != NULL)
		SetCurrentScreen(plevelSelect);
	else if(rb)
		SetCurrentScreen(home);
}

void OnePlayerGameOver::Init(){
	Mix_FadeOutMusic(500);
	percentDone = game->GetPercentDone();
	lemsNeeded = game->LemmingsNeededPercent();
	timeLeft = game->timeRemaining;
	if(game->WasGameWon())
		levelLoader->NextLevel();
}



