/*
 * OnePlayerLevelSelect.cpp
 *
 *  Created on: 10 Dec 2009
 *      Author: math
 */

#include "OnePlayerLevelSelect.h"
#include "OnePlayerGameScreen.h"

OnePlayerLevelSelect::OnePlayerLevelSelect(MenuItem* newParent) : MenuItem(newParent) {
	if(plevelSelect == NULL) plevelSelect = this;
	gameScreenObject = new OnePlayerGameScreen(newParent);
}

OnePlayerLevelSelect::~OnePlayerLevelSelect()  {
	delete(gameScreenObject);
}

void OnePlayerLevelSelect::SetLevelInformation(string new_title, int new_numberOfLemmings, int new_precentToBeSaved, int new_releaseRate, int new_time, string new_rating)
{
	levelNumber = levelLoader->currentLevel+1;
	title = new_title;
	numberOfLemmings = new_numberOfLemmings;
	precentToBeSaved = new_precentToBeSaved;
	releaseRate = new_releaseRate;
	time = new_time;
}

void OnePlayerLevelSelect::DrawSelf(SDL_Surface* screen){
	std::stringstream stream;
	stream.clear();

	//clear screen
	SDL_FillRect(screen, &screen->clip_rect, SDL_MapRGB( screen->format, 0x00, 0x00, 0x00 ) );

	TileBackground(screen);

	DrawLevelPreview(screen);

	int xPos = 150;
	int yPos = 180;
	int h = 32;
	stream << "Level " << levelLoader->currentLevel+1;
	fontRenderer->RenderString(screen, stream.str(), 1, yPos-32, RED, ABSOLUTE);

	stream.str("");
	stream << game->currentLevel->GetLevelName();
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos-32, RED, ABSOLUTE);

	stream.str("");
	stream << "Number of Lemmings " << numberOfLemmings;
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos, BLUE, ABSOLUTE);

	stream.str("");
	stream << precentToBeSaved << "% To Be Saved";
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos+=h, GREEN, ABSOLUTE);

	stream.str("");
	stream << "Release Rate " << releaseRate;
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos+=h, BROWN, ABSOLUTE);

	stream.str("");
	stream << "Time  " << time << " Minutes";
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos+=h, LIGHT_BLUE, ABSOLUTE);

	stream.str("");
	stream << "Rating  " << levelLoader->GetLevelSetName();
	fontRenderer->RenderString(screen, stream.str(), xPos, yPos+=h, PURPLE, ABSOLUTE);

	fontRenderer->RenderString(screen, "Press left button to continue", 40, 400-FontHeight-2, BLUE, CENTER);
}

void OnePlayerLevelSelect::HandleKey(int k){
	if(k == SDLK_RETURN || k == SDLK_SPACE)
	{
		SetCurrentScreen(gameScreenObject);
	}
	else if(k == SDLK_RIGHT)
	{
		levelLoader->NextLevel();
		Init();
	}
	else if(k == SDLK_LEFT)
	{
		levelLoader->PreviousLevel();
		Init();
	}
}

void OnePlayerLevelSelect::HandleMouse(int mx,int my,long lb,long rb){
	if(leftclick)
		SetCurrentScreen(gameScreenObject);
}

void OnePlayerLevelSelect::Init(){
	if(game != NULL){
		game->LoadLevel(levelLoader);
		game->Init(StatusPanel::SinglePlayer);
		SetLevelInformation(game->currentLevel->GetLevelName(),
							game->currentLevel->GetNumLemmings(),
							game->LemmingsNeededPercent(),
							game->currentLevel->GetReleaseRate(),
							game->currentLevel->GetTimeInMinutes(),
							game->currentLevel->GetRatingDescription());
	}
	MenuItem::Init();
}


