/*
 * ServerGameScreen.cpp
 *
 *  Created on: 21 Dec 2009
 *      Author: mat
 */

#include "ServerGameScreen.h"
#include "ServerLevelSelect.h"

ServerGameScreen::ServerGameScreen(MenuItem* papa) : OnePlayerGameScreen(papa){
	gameOverScreen = new MultiplayerGameOverScreen(papa);
}

ServerGameScreen::~ServerGameScreen() {
}

/*
 * only update screen every 3 frames to get correct fps
 */
void ServerGameScreen::DrawSelf(SDL_Surface* screen){
	if(leftclick) sendClick = true;
	if(frameCount == game_frame_mult)
	{
		game->SetMouseClick(mouse_x, mouse_y, sendClick);
		if(scrlock() && !game->RequestForData())
		{
			gameover=true;
			SetCurrentScreen(gameOverScreen);
		}
		game->AnimateFrame();
		frameCount=0;

		forceRedraw = true;
		sendClick=false;
	}
	else
	{
		frameCount++;
	}

	if(forceRedraw)
		game->Draw(screen);
}

MenuItem* ServerGameScreen::SendEscape() {
	this->Reset();
	return SetCurrentScreen(gameOverScreen);
}

void ServerGameScreen::Init(){
	gameover=false;
	OnePlayerGameScreen::Init();
}
