/*
 * TitleScreen.h
 *
 *  Created on: 10 Dec 2009
 *      Author: mat
 */

#ifndef TITLESCREEN_H_
#define TITLESCREEN_H_

#include "MenuItem.h"
#include "OnePlayerLevelSelect.h"
#include "TwoPlayerSetupScreen.h"
#include "../LevelDesigner/DesignerScreen.h"

class TitleScreenMenu : public MenuItem {
public:
	TitleScreenMenu(MenuItem*);
	TitleScreenMenu(MenuItem*, int,int);
	virtual ~TitleScreenMenu();
	void Init();

protected:
	void DrawSelf(SDL_Surface*);
	void HandleKey(int);
	void HandleMouse(int,int,long,long);

private:
	struct LevelIcon{
		LevelLoader::LevelSet levelSet;
		SDL_Surface* icon;
	};

	void filllevelIcon(SDL_Surface* image, LevelLoader::LevelSet set );

	SDL_Surface* titlescreen;
	std::vector<LevelIcon*> levelIcons;
	std::vector<SDL_Surface*> soundIcons;
	std::string scrollyMsg;
	unsigned int pos;
	int scrollPos;

	OnePlayerLevelSelect* onePlayerLevelSelectObject;
	TwoPlayerSetupScreen* twoPlayerSetupScreenObject;
	DesignerScreen* designer;
	void playmusic();
};

#endif /* TITLESCREEN_H_ */
